/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.ProductAction;
import com.google.android.gms.analytics.ecommerce.Promotion;
import com.google.android.gms.analytics.internal.zzaa;
import com.google.android.gms.analytics.internal.zzal;
import com.google.android.gms.analytics.internal.zzc;
import com.google.android.gms.analytics.internal.zze;
import com.google.android.gms.analytics.internal.zzg;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.internal.zzgm;
import com.google.android.gms.internal.zzgn;
import com.google.android.gms.internal.zzgo;
import com.google.android.gms.internal.zzgp;
import com.google.android.gms.internal.zzkg;
import com.google.android.gms.internal.zzkm;
import com.google.android.gms.internal.zzkp;
import com.google.android.gms.internal.zzkq;
import com.google.android.gms.internal.zzkr;
import com.google.android.gms.internal.zzks;
import com.google.android.gms.internal.zzkt;
import com.google.android.gms.internal.zzku;
import com.google.android.gms.internal.zzkv;
import com.google.android.gms.internal.zzkw;
import com.google.android.gms.internal.zzkx;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class zzb
extends zzc
implements zzkm {
    private static DecimalFormat zzEl;
    private final zze zzEb;
    private final String zzEm;
    private final Uri zzEn;
    private final boolean zzEo;
    private final boolean zzEp;

    public zzb(zze zze2, String string) {
        this(zze2, string, true, false);
    }

    public zzb(zze zze2, String string, boolean bl, boolean bl2) {
        super(zze2);
        zzv.zzbS((String)string);
        this.zzEb = zze2;
        this.zzEm = string;
        this.zzEo = bl;
        this.zzEp = bl2;
        this.zzEn = zzb.zzav(this.zzEm);
    }

    static Uri zzav(String string) {
        zzv.zzbS((String)string);
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("uri");
        builder.authority("google-analytics.com");
        builder.path(string);
        return builder.build();
    }

    @Override
    public Uri zzfR() {
        return this.zzEn;
    }

    @Override
    public void zzb(zzkg zzkg2) {
        zzv.zzr((Object)zzkg2);
        zzv.zzb((boolean)zzkg2.zzue(), (Object)"Can't deliver not submitted measurement");
        zzv.zzbJ((String)"deliver should be called on worker thread");
        zzkg zzkg3 = zzkg2.zztZ();
        zzgp zzgp2 = zzkg3.zze(zzgp.class);
        if (TextUtils.isEmpty((CharSequence)zzgp2.zzgk())) {
            this.zzgH().zze(zzb.zzc(zzkg3), "Ignoring measurement without type");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)zzgp2.getClientId())) {
            this.zzgH().zze(zzb.zzc(zzkg3), "Ignoring measurement without client id");
            return;
        }
        if (this.zzEb.zzgV().getAppOptOut()) {
            return;
        }
        double d = zzgp2.zzgq();
        if (zzal.zza(d, zzgp2.getClientId())) {
            this.zzb("Sampling enabled. Hit sampled out. sampling rate", d);
            return;
        }
        Map<String, String> map = zzb.zzc(zzkg3);
        map.put("v", "1");
        map.put("_v", "ma4.5.0");
        map.put("tid", this.zzEm);
        if (this.zzEb.zzgV().isDryRunEnabled()) {
            String string = zzb.zzy(map);
            this.zzc("Dry run is enabled. GoogleAnalytics would have sent", string);
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        zzal.zzb(hashMap, "uid", zzgp2.zzgl());
        zzkp zzkp2 = zzkg2.zzd(zzkp.class);
        if (zzkp2 != null) {
            zzal.zzb(hashMap, "an", zzkp2.zziE());
            zzal.zzb(hashMap, "aid", zzkp2.zzqT());
            zzal.zzb(hashMap, "av", zzkp2.zziG());
            zzal.zzb(hashMap, "aiid", zzkp2.zzus());
        }
        zzg zzg2 = new zzg(0L, zzgp2.getClientId(), this.zzEm, !TextUtils.isEmpty((CharSequence)zzgp2.zzgm()), 0L, hashMap);
        long l = this.zzfZ().zza(zzg2);
        map.put("_s", String.valueOf(l));
        zzaa zzaa2 = new zzaa(this.zzgH(), map, zzkg2.zzuc(), true);
        this.zzfZ().zza(zzaa2);
    }

    public static Map<String, String> zzc(zzkg zzkg2) {
        zzkp zzkp2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        zzgm zzgm2;
        zzkx zzkx2;
        zzkw zzkw2;
        zzku zzku2;
        zzkq zzkq2;
        Object object5;
        Object object6;
        Object object7;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        zzgo zzgo2 = zzkg2.zzd(zzgo.class);
        if (zzgo2 != null) {
            object7 = zzgo2.zzgj().entrySet().iterator();
            while (object7.hasNext()) {
                object6 = (Map.Entry)object7.next();
                object5 = zzb.zze(object6.getValue());
                if (object5 == null) continue;
                hashMap.put((String)object6.getKey(), (String)object5);
            }
        }
        if ((object7 = zzkg2.zzd(zzgp.class)) != null) {
            zzb.zza(hashMap, "t", ((zzgp)object7).zzgk());
            zzb.zza(hashMap, "cid", ((zzgp)object7).getClientId());
            zzb.zza(hashMap, "uid", ((zzgp)object7).zzgl());
            zzb.zza(hashMap, "sc", ((zzgp)object7).zzgo());
            zzb.zza(hashMap, "sf", ((zzgp)object7).zzgq());
            zzb.zza(hashMap, "ni", ((zzgp)object7).zzgp());
            zzb.zza(hashMap, "adid", ((zzgp)object7).zzgm());
            zzb.zza(hashMap, "ate", ((zzgp)object7).zzgn());
        }
        if ((object6 = zzkg2.zzd(zzkv.class)) != null) {
            zzb.zza(hashMap, "cd", ((zzkv)object6).zzuL());
            zzb.zza(hashMap, "a", ((zzkv)object6).zzaJ());
            zzb.zza(hashMap, "dr", ((zzkv)object6).zzuO());
        }
        if ((object5 = zzkg2.zzd(zzkt.class)) != null) {
            zzb.zza(hashMap, "ec", ((zzkt)object5).zzuI());
            zzb.zza(hashMap, "ea", ((zzkt)object5).getAction());
            zzb.zza(hashMap, "el", ((zzkt)object5).getLabel());
            zzb.zza(hashMap, "ev", ((zzkt)object5).getValue());
        }
        if ((zzkq2 = zzkg2.zzd(zzkq.class)) != null) {
            zzb.zza(hashMap, "cn", zzkq2.getName());
            zzb.zza(hashMap, "cs", zzkq2.getSource());
            zzb.zza(hashMap, "cm", zzkq2.zzut());
            zzb.zza(hashMap, "ck", zzkq2.zzuu());
            zzb.zza(hashMap, "cc", zzkq2.getContent());
            zzb.zza(hashMap, "ci", zzkq2.getId());
            zzb.zza(hashMap, "anid", zzkq2.zzuv());
            zzb.zza(hashMap, "gclid", zzkq2.zzuw());
            zzb.zza(hashMap, "dclid", zzkq2.zzux());
            zzb.zza(hashMap, "aclid", zzkq2.zzuy());
        }
        if ((zzku2 = zzkg2.zzd(zzku.class)) != null) {
            zzb.zza(hashMap, "exd", zzku2.getDescription());
            zzb.zza(hashMap, "exf", zzku2.zzuJ());
        }
        if ((zzkw2 = zzkg2.zzd(zzkw.class)) != null) {
            zzb.zza(hashMap, "sn", zzkw2.zzuS());
            zzb.zza(hashMap, "sa", zzkw2.getAction());
            zzb.zza(hashMap, "st", zzkw2.getTarget());
        }
        if ((zzkx2 = zzkg2.zzd(zzkx.class)) != null) {
            zzb.zza(hashMap, "utv", zzkx2.zzuT());
            zzb.zza(hashMap, "utt", zzkx2.getTimeInMillis());
            zzb.zza(hashMap, "utc", zzkx2.zzuI());
            zzb.zza(hashMap, "utl", zzkx2.getLabel());
        }
        if ((zzgm2 = zzkg2.zzd(zzgm.class)) != null) {
            object4 = zzgm2.zzgh();
            object3 = object4.entrySet().iterator();
            while (object3.hasNext()) {
                object2 = (Map.Entry)object3.next();
                object = com.google.android.gms.analytics.zzc.zzF((Integer)object2.getKey());
                if (TextUtils.isEmpty((CharSequence)object)) continue;
                hashMap.put((String)object, (String)object2.getValue());
            }
        }
        if ((object4 = zzkg2.zzd(zzgn.class)) != null) {
            object3 = ((zzgn)object4).zzgi();
            object2 = object3.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                Map.Entry<String, String> entry = com.google.android.gms.analytics.zzc.zzH((Integer)object.getKey());
                if (TextUtils.isEmpty((CharSequence)((Object)entry))) continue;
                String entry2 = zzb.zza((Double)object.getValue());
                hashMap.put((String)((Object)entry), entry2);
            }
        }
        if ((object3 = zzkg2.zzd(zzks.class)) != null) {
            object2 = ((zzks)object3).zzuE();
            if (object2 != null) {
                for (Map.Entry<String, String> entry : ((ProductAction)object2).build().entrySet()) {
                    if (entry.getKey().startsWith("&")) {
                        hashMap.put(((String)entry.getKey()).substring(1), (String)entry.getValue());
                        continue;
                    }
                    hashMap.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            int n = 1;
            for (Promotion promotion : ((zzks)object3).zzuH()) {
                hashMap.putAll(promotion.zzaC(com.google.android.gms.analytics.zzc.zzL(n)));
                ++n;
            }
            n = 1;
            for (Product product : ((zzks)object3).zzuF()) {
                hashMap.putAll(product.zzaC(com.google.android.gms.analytics.zzc.zzJ(n)));
                ++n;
            }
            n = 1;
            for (Map.Entry<String, List<Product>> entry : ((zzks)object3).zzuG().entrySet()) {
                List<Product> list = entry.getValue();
                String string = com.google.android.gms.analytics.zzc.zzO(n);
                int n2 = 1;
                for (Product product : list) {
                    hashMap.putAll(product.zzaC(string + com.google.android.gms.analytics.zzc.zzM(n2)));
                    ++n2;
                }
                if (!TextUtils.isEmpty((CharSequence)entry.getKey())) {
                    hashMap.put(string + "nm", entry.getKey());
                }
                ++n;
            }
        }
        if ((object2 = zzkg2.zzd(zzkr.class)) != null) {
            zzb.zza(hashMap, "ul", ((zzkr)object2).getLanguage());
            zzb.zza(hashMap, "sd", ((zzkr)object2).zzuz());
            zzb.zza(hashMap, "sr", ((zzkr)object2).zzuA(), ((zzkr)object2).zzuB());
            zzb.zza(hashMap, "vp", ((zzkr)object2).zzuC(), ((zzkr)object2).zzuD());
        }
        if ((zzkp2 = zzkg2.zzd(zzkp.class)) != null) {
            zzb.zza(hashMap, "an", zzkp2.zziE());
            zzb.zza(hashMap, "aid", zzkp2.zzqT());
            zzb.zza(hashMap, "aiid", zzkp2.zzus());
            zzb.zza(hashMap, "av", zzkp2.zziG());
        }
        return hashMap;
    }

    private static void zza(Map<String, String> map, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            map.put(string, string2);
        }
    }

    static String zza(double d) {
        if (zzEl == null) {
            zzEl = new DecimalFormat("0.######");
        }
        return zzEl.format(d);
    }

    private static void zza(Map<String, String> map, String string, double d) {
        if (d != 0.0) {
            map.put(string, zzb.zza(d));
        }
    }

    private static void zza(Map<String, String> map, String string, boolean bl) {
        if (bl) {
            map.put(string, "1");
        }
    }

    private static void zza(Map<String, String> map, String string, int n, int n2) {
        if (n > 0 && n2 > 0) {
            map.put(string, n + "x" + n2);
        }
    }

    private static String zzy(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append(entry.getValue());
        }
        return stringBuilder.toString();
    }

    private static String zze(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (!TextUtils.isEmpty((CharSequence)string)) {
                return string;
            }
            return null;
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            if (d != 0.0) {
                return zzb.zza(d);
            }
            return null;
        }
        if (object instanceof Boolean) {
            if (object != Boolean.FALSE) {
                return "1";
            }
            return null;
        }
        return String.valueOf(object);
    }
}

