/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.util.Log;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzkv;
import java.util.HashMap;
import java.util.Map;

public final class zzky
implements Application.ActivityLifecycleCallbacks {
    private final zzko zzawY;
    private final Map<Activity, zzkv> zzawZ;

    public zzky(zzko zzko2) {
        zzv.zzr((Object)zzko2);
        this.zzawY = zzko2;
        this.zzawZ = new HashMap<Activity, zzkv>();
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            return;
        }
        Bundle bundle = savedInstanceState.getBundle("com.google.android.gms.measurement.screen_view");
        if (bundle == null) {
            return;
        }
        int n = bundle.getInt("id");
        if (n <= 0) {
            Log.w((String)"com.google.android.gms.measurement.internal.ActivityLifecycleTracker", (String)"Invalid screenId in saved activity state");
            return;
        }
        zzkv zzkv2 = this.zza(activity, n);
        zzkv2.setScreenName(bundle.getString("name"));
        zzkv2.zzgJ(bundle.getInt("referrer_id"));
        zzkv2.zzdd(bundle.getString("referrer_name"));
        zzkv2.zzad(bundle.getBoolean("interstitial"));
        zzkv2.zzuP();
    }

    public void onActivityStarted(Activity activity) {
        zzkv zzkv2 = this.zza(activity, 0);
        this.zzawY.zzb(zzkv2, activity);
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        if (outState == null) {
            return;
        }
        zzkv zzkv2 = this.zzawZ.get(activity);
        if (zzkv2 == null) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putInt("id", zzkv2.zzaJ());
        bundle.putString("name", zzkv2.zzuL());
        bundle.putInt("referrer_id", zzkv2.zzuM());
        bundle.putString("referrer_name", zzkv2.zzuN());
        bundle.putBoolean("interstitial", zzkv2.zzuQ());
        outState.putBundle("com.google.android.gms.measurement.screen_view", bundle);
    }

    public void onActivityDestroyed(Activity activity) {
        this.zzawZ.remove(activity);
    }

    zzkv zza(Activity activity, int n) {
        zzv.zzr((Object)activity);
        zzkv zzkv2 = this.zzawZ.get(activity);
        if (zzkv2 == null) {
            zzkv2 = n == 0 ? new zzkv(true) : new zzkv(true, n);
            zzkv2.setScreenName(activity.getClass().getCanonicalName());
            this.zzawZ.put(activity, zzkv2);
        }
        return zzkv2;
    }
}

