/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.tagmanager.ContainerHolder;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzcb;
import com.google.android.gms.tagmanager.zzct;
import com.google.android.gms.tagmanager.zzcu;
import com.google.android.gms.tagmanager.zzd;
import com.google.android.gms.tagmanager.zzo;
import com.google.android.gms.tagmanager.zzp;
import com.google.android.gms.tagmanager.zzs;
import com.google.android.gms.tagmanager.zzw;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TagManager {
    private final zza zzaFK;
    private final Context mContext;
    private final DataLayer zzaCl;
    private final zzct zzaFL;
    private final ConcurrentMap<zzo, Boolean> zzaFM;
    private final zzs zzaEH;
    private static TagManager zzaFN;

    TagManager(Context context, zza containerHolderLoaderProvider, DataLayer dataLayer, zzct serviceManager) {
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.mContext = context.getApplicationContext();
        this.zzaFL = serviceManager;
        this.zzaFK = containerHolderLoaderProvider;
        this.zzaFM = new ConcurrentHashMap<zzo, Boolean>();
        this.zzaCl = dataLayer;
        this.zzaCl.zza(new DataLayer.zzb(){

            @Override
            public void zzE(Map<String, Object> map) {
                Object object = map.get("event");
                if (object != null) {
                    TagManager.this.zzdX(object.toString());
                }
            }
        });
        this.zzaCl.zza(new zzd(this.mContext));
        this.zzaEH = new zzs();
        this.zzxK();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TagManager getInstance(Context context) {
        Class<TagManager> clazz = TagManager.class;
        synchronized (TagManager.class) {
            if (zzaFN == null) {
                if (context == null) {
                    zzbg.zzak("TagManager.getInstance requires non-null context.");
                    throw new NullPointerException();
                }
                zza zza2 = new zza(){

                    @Override
                    public zzp zza(Context context, TagManager tagManager, Looper looper, String string, int n, zzs zzs2) {
                        return new zzp(context, tagManager, looper, string, n, zzs2);
                    }
                };
                zzw zzw2 = new zzw(context);
                zzaFN = new TagManager(context, zza2, new DataLayer(zzw2), zzcu.zzxF());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzaFN;
        }
    }

    public DataLayer getDataLayer() {
        return this.zzaCl;
    }

    public PendingResult<ContainerHolder> loadContainerDefaultOnly(String containerId, int defaultContainerResourceId) {
        zzp zzp2 = this.zzaFK.zza(this.mContext, this, null, containerId, defaultContainerResourceId, this.zzaEH);
        zzp2.zzwx();
        return zzp2;
    }

    public PendingResult<ContainerHolder> zzc(String string, int n, String string2) {
        zzp zzp2 = this.zzaFK.zza(this.mContext, this, null, string, n, this.zzaEH);
        zzp2.load(string2);
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerDefaultOnly(String containerId, int defaultContainerResourceId, Handler handler) {
        zzp zzp2 = this.zzaFK.zza(this.mContext, this, handler.getLooper(), containerId, defaultContainerResourceId, this.zzaEH);
        zzp2.zzwx();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferNonDefault(String containerId, int defaultContainerResourceId) {
        zzp zzp2 = this.zzaFK.zza(this.mContext, this, null, containerId, defaultContainerResourceId, this.zzaEH);
        zzp2.zzwy();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferNonDefault(String containerId, int defaultContainerResourceId, Handler handler) {
        zzp zzp2 = this.zzaFK.zza(this.mContext, this, handler.getLooper(), containerId, defaultContainerResourceId, this.zzaEH);
        zzp2.zzwy();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferFresh(String containerId, int defaultContainerResourceId) {
        zzp zzp2 = this.zzaFK.zza(this.mContext, this, null, containerId, defaultContainerResourceId, this.zzaEH);
        zzp2.zzwz();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferFresh(String containerId, int defaultContainerResourceId, Handler handler) {
        zzp zzp2 = this.zzaFK.zza(this.mContext, this, handler.getLooper(), containerId, defaultContainerResourceId, this.zzaEH);
        zzp2.zzwz();
        return zzp2;
    }

    public void dispatch() {
        this.zzaFL.dispatch();
    }

    public void setVerboseLoggingEnabled(boolean enableVerboseLogging) {
        zzbg.setLogLevel(enableVerboseLogging ? 2 : 5);
    }

    synchronized boolean zzl(Uri uri) {
        zzcb zzcb2 = zzcb.zzxl();
        if (zzcb2.zzl(uri)) {
            String string = zzcb2.getContainerId();
            switch (zzcb2.zzxm()) {
                case zzaEu: {
                    for (zzo zzo2 : this.zzaFM.keySet()) {
                        if (!zzo2.getContainerId().equals(string)) continue;
                        zzo2.zzdB(null);
                        zzo2.refresh();
                    }
                    break;
                }
                case zzaEv: 
                case zzaEw: {
                    for (zzo zzo3 : this.zzaFM.keySet()) {
                        if (zzo3.getContainerId().equals(string)) {
                            zzo3.zzdB(zzcb2.zzxn());
                            zzo3.refresh();
                            continue;
                        }
                        if (zzo3.zzwu() == null) continue;
                        zzo3.zzdB(null);
                        zzo3.refresh();
                    }
                    break;
                }
            }
            return true;
        }
        return false;
    }

    void zza(zzo zzo2) {
        this.zzaFM.put(zzo2, true);
    }

    boolean zzb(zzo zzo2) {
        return this.zzaFM.remove(zzo2) != null;
    }

    private void zzdX(String string) {
        for (zzo zzo2 : this.zzaFM.keySet()) {
            zzo2.zzdz(string);
        }
    }

    private void zzxK() {
        if (Build.VERSION.SDK_INT >= 14) {
            this.mContext.registerComponentCallbacks((ComponentCallbacks)new ComponentCallbacks2(){

                public void onTrimMemory(int i) {
                    if (i == 20) {
                        TagManager.this.dispatch();
                    }
                }

                public void onConfigurationChanged(Configuration configuration) {
                }

                public void onLowMemory() {
                }
            });
        }
    }

    public static interface zza {
        public zzp zza(Context var1, TagManager var2, Looper var3, String var4, int var5, zzs var6);
    }
}

