/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.gms.internal.zzc;
import com.google.android.gms.internal.zzmq;
import com.google.android.gms.internal.zzmw;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.tagmanager.zzbf;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzcb;
import com.google.android.gms.tagmanager.zzs;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

class zzcl
implements Runnable {
    private final Context mContext;
    private final zzmx zzaEE;
    private final String zzaCk;
    private final String zzaEF;
    private zzbf<zzc.zzj> zzaEG;
    private volatile zzs zzaEH;
    private volatile String zzaCH;
    private volatile String zzaEI;

    public zzcl(Context context, String string, zzs zzs2) {
        this(context, string, new zzmx(), zzs2);
    }

    zzcl(Context context, String string, zzmx zzmx2, zzs zzs2) {
        this.mContext = context;
        this.zzaEE = zzmx2;
        this.zzaCk = string;
        this.zzaEH = zzs2;
        this.zzaCH = this.zzaEF = "/r?id=" + string;
        this.zzaEI = null;
    }

    @Override
    public void run() {
        if (this.zzaEG == null) {
            throw new IllegalStateException("callback must be set before execute");
        }
        this.zzaEG.zzwB();
        this.zzxp();
    }

    private boolean zzxo() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            zzbg.zzam("...no network connectivity");
            return false;
        }
        return true;
    }

    void zza(zzbf<zzc.zzj> zzbf2) {
        this.zzaEG = zzbf2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void zzxp() {
        block12: {
            if (!this.zzxo()) {
                this.zzaEG.zza(zzbf.zza.zzaDU);
                return;
            }
            zzbg.zzam("Start loading resource from network ...");
            String string = this.zzxq();
            InputStream inputStream = null;
            try (zzmw zzmw2 = this.zzaEE.zzyM();){
                try {
                    inputStream = zzmw2.zzev(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    zzbg.zzan("No data is retrieved from the given url: " + string + ". Make sure container_id: " + this.zzaCk + " is correct.");
                    this.zzaEG.zza(zzbf.zza.zzaDW);
                    zzmw2.close();
                    return;
                }
                catch (IOException iOException) {
                    zzbg.zzd("Error when loading resources from url: " + string + " " + iOException.getMessage(), iOException);
                    this.zzaEG.zza(zzbf.zza.zzaDV);
                    zzmw2.close();
                    return;
                }
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    zzmq.zzc(inputStream, byteArrayOutputStream);
                    zzc.zzj zzj2 = zzc.zzj.zzb(byteArrayOutputStream.toByteArray());
                    zzbg.zzam("Successfully loaded supplemented resource: " + (Object)((Object)zzj2));
                    if (zzj2.zzhh == null && zzj2.zzhg.length == 0) {
                        zzbg.zzam("No change for container: " + this.zzaCk);
                    }
                    this.zzaEG.zzv(zzj2);
                    break block12;
                }
                catch (IOException iOException) {
                    zzbg.zzd("Error when parsing downloaded resources from url: " + string + " " + iOException.getMessage(), iOException);
                    this.zzaEG.zza(zzbf.zza.zzaDW);
                    zzmw2.close();
                    return;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        zzbg.zzam("Load resource from network finished.");
    }

    String zzxq() {
        String string = this.zzaEH.zzwD() + this.zzaCH + "&v=a65833898";
        if (this.zzaEI != null && !this.zzaEI.trim().equals("")) {
            string = string + "&pv=" + this.zzaEI;
        }
        if (zzcb.zzxl().zzxm().equals((Object)zzcb.zza.zzaEw)) {
            string = string + "&gtm_debug=x";
        }
        return string;
    }

    void zzdE(String string) {
        if (string == null) {
            this.zzaCH = this.zzaEF;
        } else {
            zzbg.zzaj("Setting CTFE URL path: " + string);
            this.zzaCH = string;
        }
    }

    void zzdT(String string) {
        zzbg.zzaj("Setting previous container version: " + string);
        this.zzaEI = string;
    }
}

