/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.res.Resources;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzlr;
import com.google.android.gms.internal.zzql;
import com.google.android.gms.internal.zzqp;
import com.google.android.gms.internal.zzqq;
import com.google.android.gms.tagmanager.zzbg;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class zzqr {
    public static final Integer zzaUg = 0;
    public static final Integer zzaUh = 1;
    private final Context mContext;
    private final ExecutorService zzaRv;

    public zzqr(Context context) {
        this(context, Executors.newSingleThreadExecutor());
    }

    zzqr(Context context, ExecutorService executorService) {
        this.mContext = context;
        this.zzaRv = executorService;
    }

    public void zza(final String string, final Integer n, final zzql zzql2, final zzqq zzqq2) {
        this.zzaRv.execute(new Runnable(){

            @Override
            public void run() {
                zzqr.this.zzb(string, n, zzql2, zzqq2);
            }
        });
    }

    void zzb(String string, Integer n, zzql zzql2, zzqq zzqq2) {
        Object object;
        InputStream inputStream;
        zzbg.v("DiskLoader: Starting to load resource from Disk.");
        try {
            inputStream = new FileInputStream(this.zzfq(string));
            object = zzql2.zzt(this.zzm(inputStream));
            if (object != null) {
                zzbg.v("Saved resource loaded: " + this.zzfr(string));
                zzqq2.zza(Status.zzaaD, object, zzaUh, this.zzfp(string));
                return;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            zzbg.e("Saved resource not found: " + this.zzfr(string));
        }
        catch (zzqp.zzg zzg2) {
            zzbg.e("Saved resource is corrupted: " + this.zzfr(string));
        }
        if (n == null) {
            zzqq2.zza(Status.zzaaF, null, null, 0L);
            return;
        }
        try {
            inputStream = this.mContext.getResources().openRawResource(n.intValue());
            if (inputStream != null && (object = zzql2.zzt(this.zzm(inputStream))) != null) {
                zzbg.v("Default resource loaded: " + this.mContext.getResources().getResourceEntryName(n.intValue()));
                zzqq2.zza(Status.zzaaD, object, zzaUg, 0L);
                return;
            }
        }
        catch (Resources.NotFoundException notFoundException) {
            zzbg.e("Default resource not found. ID: " + n);
        }
        catch (zzqp.zzg zzg3) {
            zzbg.e("Default resource resource is corrupted: " + n);
        }
        zzqq2.zza(Status.zzaaF, null, null, 0L);
    }

    public void zze(final String string, final byte[] byArray) {
        this.zzaRv.execute(new Runnable(){

            @Override
            public void run() {
                zzqr.this.zzf(string, byArray);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzf(String string, byte[] byArray) {
        String string2;
        FileOutputStream fileOutputStream;
        File file = this.zzfq(string);
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string3 = "Error opening resource file for writing";
            zzbg.e(string3);
            return;
        }
        try {
            fileOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            string2 = "Error writing resource to disk. Removing resource from disk";
            zzbg.e(string2);
            file.delete();
        }
        finally {
            try {
                fileOutputStream.close();
                zzbg.v("Resource " + string + " saved on Disk.");
            }
            catch (IOException iOException) {
                string2 = "Error closing stream for writing resource to disk";
                zzbg.e(string2);
            }
        }
    }

    public long zzfp(String string) {
        File file = this.zzfq(string);
        return file.exists() ? file.lastModified() : 0L;
    }

    File zzfq(String string) {
        File file = this.mContext.getDir("google_tagmanager", 0);
        return new File(file, this.zzfr(string));
    }

    private String zzfr(String string) {
        return "resource_" + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] zzm(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            zzlr.zza((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            zzbg.zzaE("Failed to read the resource from disk");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                zzbg.zzaE("Error closing stream for reading resource from disk");
                return null;
            }
        }
        return byteArrayOutputStream.toByteArray();
    }
}

