/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import com.google.android.gms.analytics.Logger;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.internal.zzae;
import com.google.android.gms.analytics.internal.zzak;
import com.google.android.gms.analytics.internal.zzal;
import com.google.android.gms.analytics.internal.zzan;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzy;
import com.google.android.gms.common.internal.zzx;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class GoogleAnalytics
extends com.google.android.gms.analytics.zza {
    private static List<Runnable> zzLz = new ArrayList<Runnable>();
    private boolean zzpA;
    private boolean zzLA;
    private Set<zza> zzLB = new HashSet<zza>();
    private boolean zzLC;
    private boolean zzLD;
    private volatile boolean zzLE;
    private boolean zzLF;

    public void zza() {
        this.zzhM();
        this.zzpA = true;
    }

    void zzhM() {
        Logger logger;
        zzan zzan2 = this.zzhQ();
        if (zzan2.zzks()) {
            this.getLogger().setLogLevel(zzan2.getLogLevel());
        }
        if (zzan2.zzkw()) {
            this.setDryRun(zzan2.zzkx());
        }
        if (zzan2.zzks() && (logger = zzae.getLogger()) != null) {
            logger.setLogLevel(zzan2.getLogLevel());
        }
    }

    public boolean isInitialized() {
        return this.zzpA && !this.zzLA;
    }

    public GoogleAnalytics(zzf context) {
        super(context);
    }

    public static GoogleAnalytics getInstance(Context context) {
        return zzf.zzX(context).zziI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzhN() {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            if (zzLz != null) {
                for (Runnable runnable : zzLz) {
                    runnable.run();
                }
                zzLz = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public void setDryRun(boolean dryRun) {
        this.zzLD = dryRun;
    }

    public boolean isDryRunEnabled() {
        return this.zzLD;
    }

    public void enableAutoActivityReports(Application application) {
        if (Build.VERSION.SDK_INT >= 14 && !this.zzLC) {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzb());
            this.zzLC = true;
        }
    }

    public void reportActivityStart(Activity activity) {
        if (!this.zzLC) {
            this.zzl(activity);
        }
    }

    void zzl(Activity activity) {
        for (zza zza2 : this.zzLB) {
            zza2.zzn(activity);
        }
    }

    public void reportActivityStop(Activity activity) {
        if (!this.zzLC) {
            this.zzm(activity);
        }
    }

    void zzm(Activity activity) {
        for (zza zza2 : this.zzLB) {
            zza2.zzo(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker newTracker(String trackingId) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            Tracker tracker = new Tracker(this.zzhF(), trackingId, null);
            tracker.zza();
            return tracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker newTracker(int configResId) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            zzak zzak2;
            zzal zzal2;
            Tracker tracker = new Tracker(this.zzhF(), null, null);
            if (configResId > 0 && (zzal2 = (zzal)(zzak2 = new zzak(this.zzhF())).zzad(configResId)) != null) {
                tracker.zza(zzal2);
            }
            tracker.zza();
            return tracker;
        }
    }

    void zza(zza zza2) {
        this.zzLB.add(zza2);
        Context context = this.zzhF().getContext();
        if (context instanceof Application) {
            this.enableAutoActivityReports((Application)context);
        }
    }

    void zzb(zza zza2) {
        this.zzLB.remove(zza2);
    }

    public void setAppOptOut(boolean optOut) {
        this.zzLE = optOut;
        if (this.zzLE) {
            this.zzhP().zzik();
        }
    }

    public boolean getAppOptOut() {
        return this.zzLE;
    }

    @Deprecated
    public Logger getLogger() {
        return zzae.getLogger();
    }

    @Deprecated
    public void setLogger(Logger logger) {
        zzae.setLogger(logger);
        if (!this.zzLF) {
            Log.i((String)zzy.zzOg.get(), (String)("GoogleAnalytics.setLogger() is deprecated. To enable debug logging, please run:\nadb shell setprop log.tag." + zzy.zzOg.get() + " DEBUG"));
            this.zzLF = true;
        }
    }

    public String getClientId() {
        zzx.zzcj((String)"getClientId can not be called from the main thread");
        return this.zzhF().zziL().zzjt();
    }

    public void setLocalDispatchPeriod(int dispatchPeriodInSeconds) {
        this.zzhP().setLocalDispatchPeriod(dispatchPeriodInSeconds);
    }

    public void dispatchLocalHits() {
        this.zzhP().zzil();
    }

    void zzhO() {
        this.zzhP().zzim();
    }

    private com.google.android.gms.analytics.internal.zzb zzhP() {
        return this.zzhF().zzhP();
    }

    private zzan zzhQ() {
        return this.zzhF().zzhQ();
    }

    class zzb
    implements Application.ActivityLifecycleCallbacks {
        zzb() {
        }

        public void onActivityStarted(Activity activity) {
            GoogleAnalytics.this.zzl(activity);
        }

        public void onActivityStopped(Activity activity) {
            GoogleAnalytics.this.zzm(activity);
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }
    }

    static interface zza {
        public void zzn(Activity var1);

        public void zzo(Activity var1);
    }
}

