/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzad;
import com.google.android.gms.analytics.internal.zzal;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zze;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzh;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzpb;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class Tracker
extends zzd {
    private boolean zzLN;
    private final Map<String, String> zzvS = new HashMap<String, String>();
    private final Map<String, String> zzLO = new HashMap<String, String>();
    private final zzad zzLP;
    private final zza zzLQ;
    private ExceptionReporter zzLR;
    private zzal zzLS;

    Tracker(zzf analytics, String trackingId, zzad rateLimiter) {
        super(analytics);
        if (trackingId != null) {
            this.zzvS.put("&tid", trackingId);
        }
        this.zzvS.put("useSecure", "1");
        this.zzvS.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.zzLP = rateLimiter == null ? new zzad("tracking") : rateLimiter;
        this.zzLQ = new zza(analytics);
    }

    @Override
    protected void zzhR() {
        String string;
        this.zzLQ.zza();
        String string2 = this.zzhQ().zzkp();
        if (string2 != null) {
            this.set("&an", string2);
        }
        if ((string = this.zzhQ().zzkr()) != null) {
            this.set("&av", string);
        }
    }

    void zza(zzal zzal2) {
        String string;
        this.zzba("Loading Tracker config values");
        this.zzLS = zzal2;
        if (this.zzLS.zzlc()) {
            string = this.zzLS.getTrackingId();
            this.set("&tid", string);
            this.zza("trackingId loaded", string);
        }
        if (this.zzLS.zzld()) {
            string = Double.toString(this.zzLS.zzle());
            this.set("&sf", string);
            this.zza("Sample frequency loaded", string);
        }
        if (this.zzLS.zzlf()) {
            int n = this.zzLS.getSessionTimeout();
            this.setSessionTimeout(n);
            this.zza("Session timeout loaded", n);
        }
        if (this.zzLS.zzlg()) {
            boolean bl = this.zzLS.zzlh();
            this.enableAutoActivityTracking(bl);
            this.zza("Auto activity tracking loaded", bl);
        }
        if (this.zzLS.zzli()) {
            boolean bl = this.zzLS.zzlj();
            if (bl) {
                this.set("&aip", "1");
            }
            this.zza("Anonymize ip loaded", bl);
        }
        this.enableExceptionReporting(this.zzLS.zzlk());
    }

    private boolean zzhS() {
        return this.zzLR != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableExceptionReporting(boolean enable) {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.zzhS() == enable) {
                return;
            }
            if (enable) {
                Context context = this.getContext();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                this.zzLR = new ExceptionReporter(this, uncaughtExceptionHandler, context);
                Thread.setDefaultUncaughtExceptionHandler(this.zzLR);
                this.zzba("Uncaught exceptions will be reported to Google Analytics");
            } else {
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = this.zzLR.zzhL();
                Thread.setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler);
                this.zzba("Uncaught exceptions will not be reported to Google Analytics");
            }
        }
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.zzLQ.setSessionTimeout(sessionTimeout * 1000L);
    }

    public void enableAutoActivityTracking(boolean enabled) {
        this.zzLQ.enableAutoActivityTracking(enabled);
    }

    private static boolean zza(Map.Entry<String, String> entry) {
        String string = entry.getKey();
        String string2 = entry.getValue();
        return string.startsWith("&") && string.length() >= 2;
    }

    private static String zzb(Map.Entry<String, String> entry) {
        if (!Tracker.zza(entry)) {
            return null;
        }
        return entry.getKey().substring(1);
    }

    private static void zzb(Map<String, String> map, Map<String, String> map2) {
        zzx.zzw(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zzb(entry);
            if (string == null) continue;
            map2.put(string, entry.getValue());
        }
    }

    private static void zzc(Map<String, String> map, Map<String, String> map2) {
        zzx.zzw(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zzb(entry);
            if (string == null || map2.containsKey(string)) continue;
            map2.put(string, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Map<String, String> params) {
        final long l = this.zzit().currentTimeMillis();
        if (this.zzhK().getAppOptOut()) {
            this.zzbb("AppOptOut is set to true. Not sending Google Analytics hit");
            return;
        }
        final boolean bl = this.zzhK().isDryRunEnabled();
        final HashMap<String, String> hashMap = new HashMap<String, String>();
        Tracker.zzb(this.zzvS, hashMap);
        Tracker.zzb(params, hashMap);
        final boolean bl2 = zzam.zze(this.zzvS.get("useSecure"), true);
        Tracker.zzc(this.zzLO, hashMap);
        this.zzLO.clear();
        final String string = (String)hashMap.get("t");
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zziu().zzh(hashMap, "Missing hit type parameter");
            return;
        }
        final String string2 = (String)hashMap.get("tid");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zziu().zzh(hashMap, "Missing tracking id parameter");
            return;
        }
        final boolean bl3 = this.zzhT();
        Tracker tracker = this;
        synchronized (tracker) {
            if ("screenview".equalsIgnoreCase(string) || "pageview".equalsIgnoreCase(string) || "appview".equalsIgnoreCase(string) || TextUtils.isEmpty((CharSequence)string)) {
                int n = Integer.parseInt(this.zzvS.get("&a"));
                n = ++n >= Integer.MAX_VALUE ? 1 : n;
                this.zzvS.put("&a", Integer.toString(n));
            }
        }
        this.zziw().zzg(new Runnable(){

            @Override
            public void run() {
                boolean bl4;
                double d;
                if (Tracker.this.zzLQ.zzhU()) {
                    hashMap.put("sc", "start");
                }
                zzam.zzd(hashMap, "cid", Tracker.this.zzhK().getClientId());
                String string3 = (String)hashMap.get("sf");
                if (string3 != null && zzam.zza(d = zzam.zza(string3, 100.0), (String)hashMap.get("cid"))) {
                    Tracker.this.zzb("Sampling enabled. Hit sampled out. sample rate", d);
                    return;
                }
                com.google.android.gms.analytics.internal.zza zza2 = Tracker.this.zziA();
                if (bl3) {
                    zzam.zzb(hashMap, "ate", zza2.zzic());
                    zzam.zzc(hashMap, "adid", zza2.zzig());
                } else {
                    hashMap.remove("ate");
                    hashMap.remove("adid");
                }
                zzpb zzpb2 = Tracker.this.zziB().zzjb();
                zzam.zzc(hashMap, "an", zzpb2.zzkp());
                zzam.zzc(hashMap, "av", zzpb2.zzkr());
                zzam.zzc(hashMap, "aid", zzpb2.zzuM());
                zzam.zzc(hashMap, "aiid", zzpb2.zzyt());
                hashMap.put("v", "1");
                hashMap.put("_v", zze.zzMH);
                zzam.zzc(hashMap, "ul", Tracker.this.zziC().zzki().getLanguage());
                zzam.zzc(hashMap, "sr", Tracker.this.zziC().zzkj());
                boolean bl22 = bl4 = string.equals("transaction") || string.equals("item");
                if (!bl4 && !Tracker.this.zzLP.zzkF()) {
                    Tracker.this.zziu().zzh(hashMap, "Too many hits sent too quickly, rate limiting invoked");
                    return;
                }
                long l3 = zzam.zzbq((String)hashMap.get("ht"));
                if (l3 == 0L) {
                    l3 = l;
                }
                if (bl) {
                    zzab zzab2 = new zzab(Tracker.this, hashMap, l3, bl2);
                    Tracker.this.zziu().zzc("Dry run enabled. Would have sent hit", zzab2);
                    return;
                }
                String string22 = (String)hashMap.get("cid");
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                zzam.zza(hashMap2, "uid", hashMap);
                zzam.zza(hashMap2, "an", hashMap);
                zzam.zza(hashMap2, "aid", hashMap);
                zzam.zza(hashMap2, "av", hashMap);
                zzam.zza(hashMap2, "aiid", hashMap);
                zzh zzh2 = new zzh(0L, string22, string2, !TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("adid"))), 0L, hashMap2);
                long l2 = Tracker.this.zzhP().zza(zzh2);
                hashMap.put("_s", String.valueOf(l2));
                zzab zzab3 = new zzab(Tracker.this, hashMap, l3, bl2);
                Tracker.this.zzhP().zza(zzab3);
            }
        });
    }

    public String get(String key) {
        this.zziE();
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        if (this.zzvS.containsKey(key)) {
            return this.zzvS.get(key);
        }
        if (key.equals("&ul")) {
            return zzam.zza(Locale.getDefault());
        }
        if (key.equals("&cid")) {
            return this.zziz().zzjt();
        }
        if (key.equals("&sr")) {
            return this.zziC().zzkj();
        }
        if (key.equals("&aid")) {
            return this.zziB().zzjb().zzuM();
        }
        if (key.equals("&an")) {
            return this.zziB().zzjb().zzkp();
        }
        if (key.equals("&av")) {
            return this.zziB().zzjb().zzkr();
        }
        if (key.equals("&aiid")) {
            return this.zziB().zzjb().zzyt();
        }
        return null;
    }

    public void set(String key, String value) {
        zzx.zzb((Object)key, (Object)"Key should be non-null");
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        this.zzvS.put(key, value);
    }

    public void setSampleRate(double sampleRate) {
        this.set("&sf", Double.toString(sampleRate));
    }

    public void setUseSecure(boolean useSecure) {
        this.set("useSecure", zzam.zzJ(useSecure));
    }

    public void setScreenName(String screenName) {
        this.set("&cd", screenName);
    }

    public void setLocation(String location) {
        this.set("&dl", location);
    }

    public void setReferrer(String referrer) {
        this.set("&dr", referrer);
    }

    public void setPage(String page) {
        this.set("&dp", page);
    }

    public void setHostname(String hostname) {
        this.set("&dh", hostname);
    }

    public void setTitle(String title) {
        this.set("&dt", title);
    }

    public void setLanguage(String language) {
        this.set("&ul", language);
    }

    public void setEncoding(String encoding) {
        this.set("&de", encoding);
    }

    public void setScreenColors(String screenColors) {
        this.set("&sd", screenColors);
    }

    public void setScreenResolution(int width, int height) {
        if (width < 0 && height < 0) {
            this.zzbd("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", width + "x" + height);
    }

    public void setViewportSize(String viewportSize) {
        this.set("&vp", viewportSize);
    }

    public void setClientId(String clientId) {
        this.set("&cid", clientId);
    }

    public void setAppName(String appName) {
        this.set("&an", appName);
    }

    public void setAppId(String appId) {
        this.set("&aid", appId);
    }

    public void setAppInstallerId(String appInstallerId) {
        this.set("&aiid", appInstallerId);
    }

    public void setAppVersion(String appVersion) {
        this.set("&av", appVersion);
    }

    public void setAnonymizeIp(boolean anonymize) {
        this.set("&aip", zzam.zzJ(anonymize));
    }

    public void setCampaignParamsOnNextHit(Uri uri) {
        if (uri == null || uri.isOpaque()) {
            return;
        }
        String string = uri.getQueryParameter("referrer");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        Uri uri2 = Uri.parse((String)("http://hostname/?" + string));
        String string2 = uri2.getQueryParameter("utm_id");
        if (string2 != null) {
            this.zzLO.put("&ci", string2);
        }
        if ((string2 = uri2.getQueryParameter("anid")) != null) {
            this.zzLO.put("&anid", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_campaign")) != null) {
            this.zzLO.put("&cn", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_content")) != null) {
            this.zzLO.put("&cc", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_medium")) != null) {
            this.zzLO.put("&cm", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_source")) != null) {
            this.zzLO.put("&cs", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_term")) != null) {
            this.zzLO.put("&ck", string2);
        }
        if ((string2 = uri2.getQueryParameter("dclid")) != null) {
            this.zzLO.put("&dclid", string2);
        }
        if ((string2 = uri2.getQueryParameter("gclid")) != null) {
            this.zzLO.put("&gclid", string2);
        }
        if ((string2 = uri2.getQueryParameter("aclid")) != null) {
            this.zzLO.put("&aclid", string2);
        }
    }

    public void enableAdvertisingIdCollection(boolean enabled) {
        this.zzLN = enabled;
    }

    boolean zzhT() {
        return this.zzLN;
    }

    static String zzp(Activity activity) {
        zzx.zzw((Object)activity);
        Intent intent = activity.getIntent();
        if (intent == null) {
            return null;
        }
        String string = intent.getStringExtra("android.intent.extra.REFERRER_NAME");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return string;
    }

    private class zza
    extends zzd
    implements GoogleAnalytics.zza {
        private boolean zzMb;
        private int zzMc;
        private long zzMd;
        private boolean zzMe;
        private long zzMf;

        protected zza(zzf zzf2) {
            super(zzf2);
            this.zzMd = -1L;
        }

        @Override
        protected void zzhR() {
        }

        public void setSessionTimeout(long sessionTimeout) {
            this.zzMd = sessionTimeout;
            this.zzhV();
        }

        public void enableAutoActivityTracking(boolean enabled) {
            this.zzMb = enabled;
            this.zzhV();
        }

        public synchronized boolean zzhU() {
            boolean bl = this.zzMe;
            this.zzMe = false;
            return bl;
        }

        private void zzhV() {
            if (this.zzMd >= 0L || this.zzMb) {
                this.zzhK().zza(Tracker.this.zzLQ);
            } else {
                this.zzhK().zzb(Tracker.this.zzLQ);
            }
        }

        @Override
        public void zzn(Activity activity) {
            if (this.zzMc == 0 && this.zzhW()) {
                this.zzMe = true;
            }
            ++this.zzMc;
            if (this.zzMb) {
                String string;
                Intent intent = activity.getIntent();
                if (intent != null) {
                    Tracker.this.setCampaignParamsOnNextHit(intent.getData());
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                Tracker.this.set("&cd", Tracker.this.zzLS != null ? Tracker.this.zzLS.zzq(activity) : activity.getClass().getCanonicalName());
                if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&dr"))) && !TextUtils.isEmpty((CharSequence)(string = Tracker.zzp(activity)))) {
                    hashMap.put("&dr", string);
                }
                Tracker.this.send(hashMap);
            }
        }

        @Override
        public void zzo(Activity activity) {
            --this.zzMc;
            this.zzMc = Math.max(0, this.zzMc);
            if (this.zzMc == 0) {
                this.zzMf = this.zzit().elapsedRealtime();
            }
        }

        boolean zzhW() {
            return this.zzit().elapsedRealtime() >= this.zzMf + Math.max(1000L, this.zzMd);
        }
    }
}

