/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.ProductAction;
import com.google.android.gms.analytics.ecommerce.Promotion;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzc;
import com.google.android.gms.analytics.internal.zze;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzh;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzjl;
import com.google.android.gms.internal.zzjm;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zzjo;
import com.google.android.gms.internal.zzpb;
import com.google.android.gms.internal.zzpc;
import com.google.android.gms.internal.zzpd;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzpf;
import com.google.android.gms.internal.zzpg;
import com.google.android.gms.internal.zzph;
import com.google.android.gms.internal.zzpi;
import com.google.android.gms.internal.zzpj;
import com.google.android.gms.measurement.zzi;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class zzb
extends zzc
implements zzi {
    private static DecimalFormat zzLp;
    private final zzf zzLf;
    private final String zzLq;
    private final Uri zzLr;
    private final boolean zzLs;
    private final boolean zzLt;

    public zzb(zzf zzf2, String string) {
        this(zzf2, string, true, false);
    }

    public zzb(zzf zzf2, String string, boolean bl, boolean bl2) {
        super(zzf2);
        zzx.zzcr((String)string);
        this.zzLf = zzf2;
        this.zzLq = string;
        this.zzLs = bl;
        this.zzLt = bl2;
        this.zzLr = zzb.zzaR(this.zzLq);
    }

    static Uri zzaR(String string) {
        zzx.zzcr((String)string);
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("uri");
        builder.authority("google-analytics.com");
        builder.path(string);
        return builder.build();
    }

    @Override
    public Uri zzhI() {
        return this.zzLr;
    }

    @Override
    public void zzb(com.google.android.gms.measurement.zzc zzc2) {
        zzx.zzw((Object)zzc2);
        zzx.zzb((boolean)zzc2.zzyj(), (Object)"Can't deliver not submitted measurement");
        zzx.zzcj((String)"deliver should be called on worker thread");
        com.google.android.gms.measurement.zzc zzc3 = zzc2.zzye();
        zzjo zzjo2 = zzc3.zze(zzjo.class);
        if (TextUtils.isEmpty((CharSequence)zzjo2.zzia())) {
            this.zziu().zzh(zzb.zzc(zzc3), "Ignoring measurement without type");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)zzjo2.getClientId())) {
            this.zziu().zzh(zzb.zzc(zzc3), "Ignoring measurement without client id");
            return;
        }
        if (this.zzLf.zziI().getAppOptOut()) {
            return;
        }
        double d = zzjo2.zzif();
        if (zzam.zza(d, zzjo2.getClientId())) {
            this.zzb("Sampling enabled. Hit sampled out. sampling rate", d);
            return;
        }
        Map<String, String> map = zzb.zzc(zzc3);
        map.put("v", "1");
        map.put("_v", zze.zzMH);
        map.put("tid", this.zzLq);
        if (this.zzLf.zziI().isDryRunEnabled()) {
            String string = zzb.zzA(map);
            this.zzc("Dry run is enabled. GoogleAnalytics would have sent", string);
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        zzam.zzc(hashMap, "uid", zzjo2.getUserId());
        zzpb zzpb2 = zzc2.zzd(zzpb.class);
        if (zzpb2 != null) {
            zzam.zzc(hashMap, "an", zzpb2.zzkp());
            zzam.zzc(hashMap, "aid", zzpb2.zzuM());
            zzam.zzc(hashMap, "av", zzpb2.zzkr());
            zzam.zzc(hashMap, "aiid", zzpb2.zzyt());
        }
        zzh zzh2 = new zzh(0L, zzjo2.getClientId(), this.zzLq, !TextUtils.isEmpty((CharSequence)zzjo2.zzib()), 0L, hashMap);
        long l = this.zzhP().zza(zzh2);
        map.put("_s", String.valueOf(l));
        zzab zzab2 = new zzab(this.zziu(), map, zzc2.zzyh(), true);
        this.zzhP().zza(zzab2);
    }

    public static Map<String, String> zzc(com.google.android.gms.measurement.zzc zzc2) {
        zzpb zzpb2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        zzjl zzjl2;
        zzpj zzpj2;
        zzpi zzpi2;
        zzpg zzpg2;
        zzpc zzpc2;
        Object object5;
        Object object6;
        Object object7;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        zzjn zzjn2 = zzc2.zzd(zzjn.class);
        if (zzjn2 != null) {
            object7 = zzjn2.zzhZ().entrySet().iterator();
            while (object7.hasNext()) {
                object6 = (Map.Entry)object7.next();
                object5 = zzb.zzh(object6.getValue());
                if (object5 == null) continue;
                hashMap.put((String)object6.getKey(), (String)object5);
            }
        }
        if ((object7 = zzc2.zzd(zzjo.class)) != null) {
            zzb.zzb(hashMap, "t", ((zzjo)object7).zzia());
            zzb.zzb(hashMap, "cid", ((zzjo)object7).getClientId());
            zzb.zzb(hashMap, "uid", ((zzjo)object7).getUserId());
            zzb.zzb(hashMap, "sc", ((zzjo)object7).zzid());
            zzb.zza(hashMap, "sf", ((zzjo)object7).zzif());
            zzb.zza(hashMap, "ni", ((zzjo)object7).zzie());
            zzb.zzb(hashMap, "adid", ((zzjo)object7).zzib());
            zzb.zza(hashMap, "ate", ((zzjo)object7).zzic());
        }
        if ((object6 = zzc2.zzd(zzph.class)) != null) {
            zzb.zzb(hashMap, "cd", ((zzph)object6).zzyM());
            zzb.zza(hashMap, "a", ((zzph)object6).zzyN());
            zzb.zzb(hashMap, "dr", ((zzph)object6).zzyO());
        }
        if ((object5 = zzc2.zzd(zzpf.class)) != null) {
            zzb.zzb(hashMap, "ec", ((zzpf)object5).zzyJ());
            zzb.zzb(hashMap, "ea", ((zzpf)object5).getAction());
            zzb.zzb(hashMap, "el", ((zzpf)object5).getLabel());
            zzb.zza(hashMap, "ev", ((zzpf)object5).getValue());
        }
        if ((zzpc2 = zzc2.zzd(zzpc.class)) != null) {
            zzb.zzb(hashMap, "cn", zzpc2.getName());
            zzb.zzb(hashMap, "cs", zzpc2.getSource());
            zzb.zzb(hashMap, "cm", zzpc2.zzyu());
            zzb.zzb(hashMap, "ck", zzpc2.zzyv());
            zzb.zzb(hashMap, "cc", zzpc2.getContent());
            zzb.zzb(hashMap, "ci", zzpc2.getId());
            zzb.zzb(hashMap, "anid", zzpc2.zzyw());
            zzb.zzb(hashMap, "gclid", zzpc2.zzyx());
            zzb.zzb(hashMap, "dclid", zzpc2.zzyy());
            zzb.zzb(hashMap, "aclid", zzpc2.zzyz());
        }
        if ((zzpg2 = zzc2.zzd(zzpg.class)) != null) {
            zzb.zzb(hashMap, "exd", zzpg2.getDescription());
            zzb.zza(hashMap, "exf", zzpg2.zzyK());
        }
        if ((zzpi2 = zzc2.zzd(zzpi.class)) != null) {
            zzb.zzb(hashMap, "sn", zzpi2.zzyQ());
            zzb.zzb(hashMap, "sa", zzpi2.getAction());
            zzb.zzb(hashMap, "st", zzpi2.getTarget());
        }
        if ((zzpj2 = zzc2.zzd(zzpj.class)) != null) {
            zzb.zzb(hashMap, "utv", zzpj2.zzyR());
            zzb.zza(hashMap, "utt", zzpj2.getTimeInMillis());
            zzb.zzb(hashMap, "utc", zzpj2.zzyJ());
            zzb.zzb(hashMap, "utl", zzpj2.getLabel());
        }
        if ((zzjl2 = zzc2.zzd(zzjl.class)) != null) {
            object4 = zzjl2.zzhX();
            object3 = object4.entrySet().iterator();
            while (object3.hasNext()) {
                object2 = (Map.Entry)object3.next();
                object = com.google.android.gms.analytics.zzc.zzQ((Integer)object2.getKey());
                if (TextUtils.isEmpty((CharSequence)object)) continue;
                hashMap.put((String)object, (String)object2.getValue());
            }
        }
        if ((object4 = zzc2.zzd(zzjm.class)) != null) {
            object3 = ((zzjm)object4).zzhY();
            object2 = object3.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                Map.Entry<String, String> entry = com.google.android.gms.analytics.zzc.zzS((Integer)object.getKey());
                if (TextUtils.isEmpty((CharSequence)((Object)entry))) continue;
                String entry2 = zzb.zzb((Double)object.getValue());
                hashMap.put((String)((Object)entry), entry2);
            }
        }
        if ((object3 = zzc2.zzd(zzpe.class)) != null) {
            object2 = ((zzpe)object3).zzyF();
            if (object2 != null) {
                for (Map.Entry<String, String> entry : ((ProductAction)object2).build().entrySet()) {
                    if (entry.getKey().startsWith("&")) {
                        hashMap.put(((String)entry.getKey()).substring(1), (String)entry.getValue());
                        continue;
                    }
                    hashMap.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            int n = 1;
            for (Promotion promotion : ((zzpe)object3).zzyI()) {
                hashMap.putAll(promotion.zzaX(com.google.android.gms.analytics.zzc.zzW(n)));
                ++n;
            }
            n = 1;
            for (Product product : ((zzpe)object3).zzyG()) {
                hashMap.putAll(product.zzaX(com.google.android.gms.analytics.zzc.zzU(n)));
                ++n;
            }
            n = 1;
            for (Map.Entry<String, List<Product>> entry : ((zzpe)object3).zzyH().entrySet()) {
                List<Product> list = entry.getValue();
                String string = com.google.android.gms.analytics.zzc.zzZ(n);
                int n2 = 1;
                for (Product product : list) {
                    hashMap.putAll(product.zzaX(string + com.google.android.gms.analytics.zzc.zzX(n2)));
                    ++n2;
                }
                if (!TextUtils.isEmpty((CharSequence)entry.getKey())) {
                    hashMap.put(string + "nm", entry.getKey());
                }
                ++n;
            }
        }
        if ((object2 = zzc2.zzd(zzpd.class)) != null) {
            zzb.zzb(hashMap, "ul", ((zzpd)object2).getLanguage());
            zzb.zza(hashMap, "sd", ((zzpd)object2).zzyA());
            zzb.zza(hashMap, "sr", ((zzpd)object2).zzyB(), ((zzpd)object2).zzyC());
            zzb.zza(hashMap, "vp", ((zzpd)object2).zzyD(), ((zzpd)object2).zzyE());
        }
        if ((zzpb2 = zzc2.zzd(zzpb.class)) != null) {
            zzb.zzb(hashMap, "an", zzpb2.zzkp());
            zzb.zzb(hashMap, "aid", zzpb2.zzuM());
            zzb.zzb(hashMap, "aiid", zzpb2.zzyt());
            zzb.zzb(hashMap, "av", zzpb2.zzkr());
        }
        return hashMap;
    }

    private static void zzb(Map<String, String> map, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            map.put(string, string2);
        }
    }

    static String zzb(double d) {
        if (zzLp == null) {
            zzLp = new DecimalFormat("0.######");
        }
        return zzLp.format(d);
    }

    private static void zza(Map<String, String> map, String string, double d) {
        if (d != 0.0) {
            map.put(string, zzb.zzb(d));
        }
    }

    private static void zza(Map<String, String> map, String string, boolean bl) {
        if (bl) {
            map.put(string, "1");
        }
    }

    private static void zza(Map<String, String> map, String string, int n, int n2) {
        if (n > 0 && n2 > 0) {
            map.put(string, n + "x" + n2);
        }
    }

    private static String zzA(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append(entry.getValue());
        }
        return stringBuilder.toString();
    }

    private static String zzh(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (!TextUtils.isEmpty((CharSequence)string)) {
                return string;
            }
            return null;
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            if (d != 0.0) {
                return zzb.zzb(d);
            }
            return null;
        }
        if (object instanceof Boolean) {
            if (object != Boolean.FALSE) {
                return "1";
            }
            return null;
        }
        return String.valueOf(object);
    }
}

