/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.PowerManager;
import android.os.WorkSource;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.stats.zzg;
import com.google.android.gms.common.stats.zzi;
import com.google.android.gms.internal.zzlr;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zznb;
import com.google.android.gms.internal.zznc;

public class zzqy {
    private static String TAG = "WakeLock";
    private static boolean DEBUG = false;
    private final PowerManager.WakeLock zzaVs;
    private WorkSource zzaVt;
    private final int zzaVu;
    private final String zzaia;
    private final String zzaVv;
    private final Context mContext;
    private boolean zzaVw = true;
    private int zzaVx;
    private int zzaVy;

    public zzqy(Context context, int n, String string, String string2, String string3) {
        zzx.zzh((String)string, (Object)"Wake lock name can NOT be empty");
        this.zzaVu = n;
        this.zzaia = string;
        this.zzaVv = string2;
        this.mContext = context.getApplicationContext();
        this.zzaVs = ((PowerManager)context.getSystemService("power")).newWakeLock(n, string);
        if (zznc.zzar((Context)this.mContext)) {
            String string4;
            if (zznb.zzcA((String)string3)) {
                if (zzd.zzaeK && zzlr.isInitialized()) {
                    Log.e((String)TAG, (String)("callingPackage is not supposed to be empty for wakelock " + this.zzaia + "!"), (Throwable)new IllegalArgumentException());
                    string4 = "com.google.android.gms";
                } else {
                    string4 = context.getPackageName();
                }
            } else {
                string4 = string3;
            }
            this.zzaVt = zznc.zzm((Context)context, (String)string4);
            this.zzc(this.zzaVt);
        }
    }

    public zzqy(Context context, int n, String string) {
        this(context, n, string, null, null);
    }

    public void acquire(long timeout) {
        if (!zzmx.zzqx() && this.zzaVw) {
            Log.wtf((String)TAG, (String)("Do not acquire with timeout on reference counted WakeLocks before ICS. wakelock: " + this.zzaia));
        }
        this.zzi(null, timeout);
        this.zzaVs.acquire(timeout);
    }

    public void release() {
        this.zzeu(null);
        this.zzaVs.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzi(String string, long l) {
        boolean bl = this.zzev(string);
        String string2 = this.zzj(string, bl);
        if (DEBUG) {
            Log.d((String)TAG, (String)("Acquire:\n mWakeLockName: " + this.zzaia + "\n mSecondaryName: " + this.zzaVv + "\nmReferenceCounted: " + this.zzaVw + "\nreason: " + string + "\nmOpenEventCount" + this.zzaVy + "\nuseWithReason: " + bl + "\ntrackingName: " + string2 + "\ntimeout: " + l));
        }
        zzqy zzqy2 = this;
        synchronized (zzqy2) {
            if (this.zzaVw && (this.zzaVx++ == 0 || bl) || !this.zzaVw && this.zzaVy == 0) {
                zzi.zzqr().zza(this.mContext, zzg.zza((PowerManager.WakeLock)this.zzaVs, (String)string2), 7, this.zzaia, string2, this.zzaVu, zznc.zzb((WorkSource)this.zzaVt), l);
                ++this.zzaVy;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzeu(String string) {
        boolean bl = this.zzev(string);
        String string2 = this.zzj(string, bl);
        if (DEBUG) {
            Log.d((String)TAG, (String)("Release:\n mWakeLockName: " + this.zzaia + "\n mSecondaryName: " + this.zzaVv + "\nmReferenceCounted: " + this.zzaVw + "\nreason: " + string + "\n mOpenEventCount" + this.zzaVy + "\nuseWithReason: " + bl + "\ntrackingName: " + string2));
        }
        zzqy zzqy2 = this;
        synchronized (zzqy2) {
            if (this.zzaVw && (--this.zzaVx == 0 || bl) || !this.zzaVw && this.zzaVy == 1) {
                zzi.zzqr().zza(this.mContext, zzg.zza((PowerManager.WakeLock)this.zzaVs, (String)string2), 8, this.zzaia, string2, this.zzaVu, zznc.zzb((WorkSource)this.zzaVt));
                --this.zzaVy;
            }
        }
    }

    private boolean zzev(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && !string.equals(this.zzaVv);
    }

    private String zzj(String string, boolean bl) {
        return this.zzaVw ? (bl ? string : this.zzaVv) : this.zzaVv;
    }

    public void setReferenceCounted(boolean value) {
        this.zzaVs.setReferenceCounted(value);
        this.zzaVw = value;
    }

    public boolean isHeld() {
        return this.zzaVs.isHeld();
    }

    public void zzc(WorkSource workSource) {
        if (zznc.zzar((Context)this.mContext) && workSource != null) {
            if (this.zzaVt != null) {
                this.zzaVt.add(workSource);
            } else {
                this.zzaVt = workSource;
            }
            this.zzaVs.setWorkSource(this.zzaVt);
        }
    }
}

