/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.analytics.ExceptionReporter;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzad;
import com.google.android.gms.analytics.internal.zzal;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zze;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzh;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzqh;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class Tracker
extends zzd {
    private boolean zzNY;
    private final Map<String, String> zzxc = new HashMap<String, String>();
    private final Map<String, String> zzNZ = new HashMap<String, String>();
    private final zzad zzOa;
    private final zza zzOb;
    private ExceptionReporter zzOc;
    private zzal zzOd;

    Tracker(zzf analytics, String trackingId, zzad rateLimiter) {
        super(analytics);
        if (trackingId != null) {
            this.zzxc.put("&tid", trackingId);
        }
        this.zzxc.put("useSecure", "1");
        this.zzxc.put("&a", Integer.toString(new Random().nextInt(Integer.MAX_VALUE) + 1));
        this.zzOa = rateLimiter == null ? new zzad("tracking") : rateLimiter;
        this.zzOb = new zza(analytics);
    }

    @Override
    protected void zzir() {
        String string;
        this.zzOb.zza();
        String string2 = this.zziq().zzkP();
        if (string2 != null) {
            this.set("&an", string2);
        }
        if ((string = this.zziq().zzkR()) != null) {
            this.set("&av", string);
        }
    }

    void zza(zzal zzal2) {
        String string;
        this.zzba("Loading Tracker config values");
        this.zzOd = zzal2;
        if (this.zzOd.zzlC()) {
            string = this.zzOd.getTrackingId();
            this.set("&tid", string);
            this.zza("trackingId loaded", string);
        }
        if (this.zzOd.zzlD()) {
            string = Double.toString(this.zzOd.zzlE());
            this.set("&sf", string);
            this.zza("Sample frequency loaded", string);
        }
        if (this.zzOd.zzlF()) {
            int n = this.zzOd.getSessionTimeout();
            this.setSessionTimeout(n);
            this.zza("Session timeout loaded", n);
        }
        if (this.zzOd.zzlG()) {
            boolean bl = this.zzOd.zzlH();
            this.enableAutoActivityTracking(bl);
            this.zza("Auto activity tracking loaded", bl);
        }
        if (this.zzOd.zzlI()) {
            boolean bl = this.zzOd.zzlJ();
            if (bl) {
                this.set("&aip", "1");
            }
            this.zza("Anonymize ip loaded", bl);
        }
        this.enableExceptionReporting(this.zzOd.zzlK());
    }

    private boolean zzis() {
        return this.zzOc != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableExceptionReporting(boolean enable) {
        Tracker tracker = this;
        synchronized (tracker) {
            if (this.zzis() == enable) {
                return;
            }
            if (enable) {
                Context context = this.getContext();
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                this.zzOc = new ExceptionReporter(this, uncaughtExceptionHandler, context);
                Thread.setDefaultUncaughtExceptionHandler(this.zzOc);
                this.zzba("Uncaught exceptions will be reported to Google Analytics");
            } else {
                Thread.UncaughtExceptionHandler uncaughtExceptionHandler = this.zzOc.zzil();
                Thread.setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler);
                this.zzba("Uncaught exceptions will not be reported to Google Analytics");
            }
        }
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.zzOb.setSessionTimeout(sessionTimeout * 1000L);
    }

    public void enableAutoActivityTracking(boolean enabled) {
        this.zzOb.enableAutoActivityTracking(enabled);
    }

    private static boolean zza(Map.Entry<String, String> entry) {
        String string = entry.getKey();
        String string2 = entry.getValue();
        return string.startsWith("&") && string.length() >= 2;
    }

    private static String zzb(Map.Entry<String, String> entry) {
        if (!Tracker.zza(entry)) {
            return null;
        }
        return entry.getKey().substring(1);
    }

    private static void zzb(Map<String, String> map, Map<String, String> map2) {
        zzx.zzy(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zzb(entry);
            if (string == null) continue;
            map2.put(string, entry.getValue());
        }
    }

    private static void zzc(Map<String, String> map, Map<String, String> map2) {
        zzx.zzy(map2);
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = Tracker.zzb(entry);
            if (string == null || map2.containsKey(string)) continue;
            map2.put(string, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Map<String, String> params) {
        final long l = this.zziT().currentTimeMillis();
        if (this.zzik().getAppOptOut()) {
            this.zzbb("AppOptOut is set to true. Not sending Google Analytics hit");
            return;
        }
        final boolean bl = this.zzik().isDryRunEnabled();
        final HashMap<String, String> hashMap = new HashMap<String, String>();
        Tracker.zzb(this.zzxc, hashMap);
        Tracker.zzb(params, hashMap);
        final boolean bl2 = zzam.zze(this.zzxc.get("useSecure"), true);
        Tracker.zzc(this.zzNZ, hashMap);
        this.zzNZ.clear();
        final String string = (String)hashMap.get("t");
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zziU().zzh(hashMap, "Missing hit type parameter");
            return;
        }
        final String string2 = (String)hashMap.get("tid");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zziU().zzh(hashMap, "Missing tracking id parameter");
            return;
        }
        final boolean bl3 = this.zzit();
        Tracker tracker = this;
        synchronized (tracker) {
            if ("screenview".equalsIgnoreCase(string) || "pageview".equalsIgnoreCase(string) || "appview".equalsIgnoreCase(string) || TextUtils.isEmpty((CharSequence)string)) {
                int n = Integer.parseInt(this.zzxc.get("&a"));
                n = ++n >= Integer.MAX_VALUE ? 1 : n;
                this.zzxc.put("&a", Integer.toString(n));
            }
        }
        this.zziW().zzf(new Runnable(){

            @Override
            public void run() {
                boolean bl4;
                double d;
                if (Tracker.this.zzOb.zziu()) {
                    hashMap.put("sc", "start");
                }
                zzam.zzd(hashMap, "cid", Tracker.this.zzik().getClientId());
                String string3 = (String)hashMap.get("sf");
                if (string3 != null && zzam.zza(d = zzam.zza(string3, 100.0), (String)hashMap.get("cid"))) {
                    Tracker.this.zzb("Sampling enabled. Hit sampled out. sample rate", d);
                    return;
                }
                com.google.android.gms.analytics.internal.zza zza2 = Tracker.this.zzja();
                if (bl3) {
                    zzam.zzb(hashMap, "ate", zza2.zziC());
                    zzam.zzc(hashMap, "adid", zza2.zziG());
                } else {
                    hashMap.remove("ate");
                    hashMap.remove("adid");
                }
                zzqh zzqh2 = Tracker.this.zzjb().zzjB();
                zzam.zzc(hashMap, "an", zzqh2.zzkP());
                zzam.zzc(hashMap, "av", zzqh2.zzkR());
                zzam.zzc(hashMap, "aid", zzqh2.zzwg());
                zzam.zzc(hashMap, "aiid", zzqh2.zzzT());
                hashMap.put("v", "1");
                hashMap.put("_v", zze.zzOS);
                zzam.zzc(hashMap, "ul", Tracker.this.zzjc().zzkI().getLanguage());
                zzam.zzc(hashMap, "sr", Tracker.this.zzjc().zzkJ());
                boolean bl22 = bl4 = string.equals("transaction") || string.equals("item");
                if (!bl4 && !Tracker.this.zzOa.zzlf()) {
                    Tracker.this.zziU().zzh(hashMap, "Too many hits sent too quickly, rate limiting invoked");
                    return;
                }
                long l3 = zzam.zzbq((String)hashMap.get("ht"));
                if (l3 == 0L) {
                    l3 = l;
                }
                if (bl) {
                    zzab zzab2 = new zzab(Tracker.this, hashMap, l3, bl2);
                    Tracker.this.zziU().zzc("Dry run enabled. Would have sent hit", zzab2);
                    return;
                }
                String string22 = (String)hashMap.get("cid");
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                zzam.zza(hashMap2, "uid", hashMap);
                zzam.zza(hashMap2, "an", hashMap);
                zzam.zza(hashMap2, "aid", hashMap);
                zzam.zza(hashMap2, "av", hashMap);
                zzam.zza(hashMap2, "aiid", hashMap);
                zzh zzh2 = new zzh(0L, string22, string2, !TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("adid"))), 0L, hashMap2);
                long l2 = Tracker.this.zzip().zza(zzh2);
                hashMap.put("_s", String.valueOf(l2));
                zzab zzab3 = new zzab(Tracker.this, hashMap, l3, bl2);
                Tracker.this.zzip().zza(zzab3);
            }
        });
    }

    public String get(String key) {
        this.zzje();
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        if (this.zzxc.containsKey(key)) {
            return this.zzxc.get(key);
        }
        if (key.equals("&ul")) {
            return zzam.zza(Locale.getDefault());
        }
        if (key.equals("&cid")) {
            return this.zziZ().zzjT();
        }
        if (key.equals("&sr")) {
            return this.zzjc().zzkJ();
        }
        if (key.equals("&aid")) {
            return this.zzjb().zzjB().zzwg();
        }
        if (key.equals("&an")) {
            return this.zzjb().zzjB().zzkP();
        }
        if (key.equals("&av")) {
            return this.zzjb().zzjB().zzkR();
        }
        if (key.equals("&aiid")) {
            return this.zzjb().zzjB().zzzT();
        }
        return null;
    }

    public void set(String key, String value) {
        zzx.zzb((Object)key, (Object)"Key should be non-null");
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        this.zzxc.put(key, value);
    }

    public void setSampleRate(double sampleRate) {
        this.set("&sf", Double.toString(sampleRate));
    }

    public void setUseSecure(boolean useSecure) {
        this.set("useSecure", zzam.zzK(useSecure));
    }

    public void setScreenName(String screenName) {
        this.set("&cd", screenName);
    }

    public void setLocation(String location) {
        this.set("&dl", location);
    }

    public void setReferrer(String referrer) {
        this.set("&dr", referrer);
    }

    public void setPage(String page) {
        this.set("&dp", page);
    }

    public void setHostname(String hostname) {
        this.set("&dh", hostname);
    }

    public void setTitle(String title) {
        this.set("&dt", title);
    }

    public void setLanguage(String language) {
        this.set("&ul", language);
    }

    public void setEncoding(String encoding) {
        this.set("&de", encoding);
    }

    public void setScreenColors(String screenColors) {
        this.set("&sd", screenColors);
    }

    public void setScreenResolution(int width, int height) {
        if (width < 0 && height < 0) {
            this.zzbd("Invalid width or height. The values should be non-negative.");
            return;
        }
        this.set("&sr", width + "x" + height);
    }

    public void setViewportSize(String viewportSize) {
        this.set("&vp", viewportSize);
    }

    public void setClientId(String clientId) {
        this.set("&cid", clientId);
    }

    public void setAppName(String appName) {
        this.set("&an", appName);
    }

    public void setAppId(String appId) {
        this.set("&aid", appId);
    }

    public void setAppInstallerId(String appInstallerId) {
        this.set("&aiid", appInstallerId);
    }

    public void setAppVersion(String appVersion) {
        this.set("&av", appVersion);
    }

    public void setAnonymizeIp(boolean anonymize) {
        this.set("&aip", zzam.zzK(anonymize));
    }

    public void setCampaignParamsOnNextHit(Uri uri) {
        if (uri == null || uri.isOpaque()) {
            return;
        }
        String string = uri.getQueryParameter("referrer");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        Uri uri2 = Uri.parse((String)("http://hostname/?" + string));
        String string2 = uri2.getQueryParameter("utm_id");
        if (string2 != null) {
            this.zzNZ.put("&ci", string2);
        }
        if ((string2 = uri2.getQueryParameter("anid")) != null) {
            this.zzNZ.put("&anid", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_campaign")) != null) {
            this.zzNZ.put("&cn", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_content")) != null) {
            this.zzNZ.put("&cc", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_medium")) != null) {
            this.zzNZ.put("&cm", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_source")) != null) {
            this.zzNZ.put("&cs", string2);
        }
        if ((string2 = uri2.getQueryParameter("utm_term")) != null) {
            this.zzNZ.put("&ck", string2);
        }
        if ((string2 = uri2.getQueryParameter("dclid")) != null) {
            this.zzNZ.put("&dclid", string2);
        }
        if ((string2 = uri2.getQueryParameter("gclid")) != null) {
            this.zzNZ.put("&gclid", string2);
        }
        if ((string2 = uri2.getQueryParameter("aclid")) != null) {
            this.zzNZ.put("&aclid", string2);
        }
    }

    public void enableAdvertisingIdCollection(boolean enabled) {
        this.zzNY = enabled;
    }

    boolean zzit() {
        return this.zzNY;
    }

    static String zzp(Activity activity) {
        zzx.zzy((Object)activity);
        Intent intent = activity.getIntent();
        if (intent == null) {
            return null;
        }
        String string = intent.getStringExtra("android.intent.extra.REFERRER_NAME");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return string;
    }

    private class zza
    extends zzd
    implements GoogleAnalytics.zza {
        private boolean zzOm;
        private int zzOn;
        private long zzOo;
        private boolean zzOp;
        private long zzOq;

        protected zza(zzf zzf2) {
            super(zzf2);
            this.zzOo = -1L;
        }

        @Override
        protected void zzir() {
        }

        public void setSessionTimeout(long sessionTimeout) {
            this.zzOo = sessionTimeout;
            this.zziv();
        }

        public void enableAutoActivityTracking(boolean enabled) {
            this.zzOm = enabled;
            this.zziv();
        }

        public synchronized boolean zziu() {
            boolean bl = this.zzOp;
            this.zzOp = false;
            return bl;
        }

        private void zziv() {
            if (this.zzOo >= 0L || this.zzOm) {
                this.zzik().zza(Tracker.this.zzOb);
            } else {
                this.zzik().zzb(Tracker.this.zzOb);
            }
        }

        @Override
        public void zzn(Activity activity) {
            if (this.zzOn == 0 && this.zziw()) {
                this.zzOp = true;
            }
            ++this.zzOn;
            if (this.zzOm) {
                String string;
                Intent intent = activity.getIntent();
                if (intent != null) {
                    Tracker.this.setCampaignParamsOnNextHit(intent.getData());
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("&t", "screenview");
                Tracker.this.set("&cd", Tracker.this.zzOd != null ? Tracker.this.zzOd.zzq(activity) : activity.getClass().getCanonicalName());
                if (TextUtils.isEmpty((CharSequence)((CharSequence)hashMap.get("&dr"))) && !TextUtils.isEmpty((CharSequence)(string = Tracker.zzp(activity)))) {
                    hashMap.put("&dr", string);
                }
                Tracker.this.send(hashMap);
            }
        }

        @Override
        public void zzo(Activity activity) {
            --this.zzOn;
            this.zzOn = Math.max(0, this.zzOn);
            if (this.zzOn == 0) {
                this.zzOq = this.zziT().elapsedRealtime();
            }
        }

        boolean zziw() {
            return this.zziT().elapsedRealtime() >= this.zzOq + Math.max(1000L, this.zzOo);
        }
    }
}

