/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.android.gms.analytics.internal.zzaf;
import com.google.android.gms.analytics.internal.zzb;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.common.internal.zzx;

class zzag
extends BroadcastReceiver {
    static final String zzRF = zzag.class.getName();
    private final zzf zzOP;
    private boolean zzRG;
    private boolean zzRH;

    zzag(zzf zzf2) {
        zzx.zzy((Object)zzf2);
        this.zzOP = zzf2;
    }

    public void onReceive(Context ctx, Intent intent) {
        this.zzli();
        String string = intent.getAction();
        this.zzOP.zziU().zza("NetworkBroadcastReceiver received action", (Object)string);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            boolean bl = this.zzlk();
            if (this.zzRH != bl) {
                this.zzRH = bl;
                this.zzip().zzJ(bl);
            }
            return;
        }
        if ("com.google.analytics.RADIO_POWERED".equals(string)) {
            if (!intent.hasExtra(zzRF)) {
                this.zzip().zziO();
            }
            return;
        }
        this.zzOP.zziU().zzd("NetworkBroadcastReceiver received unknown action", string);
    }

    public void zzlh() {
        this.zzli();
        if (this.zzRG) {
            return;
        }
        Context context = this.getContext();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        String string = "com.google.analytics.RADIO_POWERED";
        IntentFilter intentFilter2 = new IntentFilter(string);
        intentFilter2.addCategory(context.getPackageName());
        context.registerReceiver((BroadcastReceiver)this, intentFilter2);
        this.zzRH = this.zzlk();
        this.zzOP.zziU().zza("Registering connectivity change receiver. Network connected", this.zzRH);
        this.zzRG = true;
    }

    private void zzli() {
        this.zziU();
        this.zzip();
    }

    public void unregister() {
        if (!this.isRegistered()) {
            return;
        }
        this.zzOP.zziU().zzba("Unregistering connectivity change receiver");
        this.zzRG = false;
        this.zzRH = false;
        Context context = this.getContext();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zziU().zze("Failed to unregister the network broadcast receiver", illegalArgumentException);
        }
    }

    public void zzlj() {
        if (Build.VERSION.SDK_INT <= 10) {
            return;
        }
        Context context = this.getContext();
        Intent intent = new Intent("com.google.analytics.RADIO_POWERED");
        intent.addCategory(context.getPackageName());
        intent.putExtra(zzRF, true);
        context.sendOrderedBroadcast(intent, null);
    }

    public boolean isRegistered() {
        return this.zzRG;
    }

    public boolean isConnected() {
        if (!this.zzRG) {
            this.zzOP.zziU().zzbd("Connectivity unknown. Receiver not registered");
        }
        return this.zzRH;
    }

    protected boolean zzlk() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isConnected();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private Context getContext() {
        return this.zzOP.getContext();
    }

    private zzaf zziU() {
        return this.zzOP.zziU();
    }

    private zzb zzip() {
        return this.zzOP.zzip();
    }
}

