/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.analytics.AnalyticsReceiver;
import com.google.android.gms.analytics.AnalyticsService;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.analytics.CampaignTrackingService;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzag;
import com.google.android.gms.analytics.internal.zzah;
import com.google.android.gms.analytics.internal.zzai;
import com.google.android.gms.analytics.internal.zzaj;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzg;
import com.google.android.gms.analytics.internal.zzh;
import com.google.android.gms.analytics.internal.zzi;
import com.google.android.gms.analytics.internal.zzj;
import com.google.android.gms.analytics.internal.zzt;
import com.google.android.gms.analytics.internal.zzv;
import com.google.android.gms.analytics.internal.zzw;
import com.google.android.gms.analytics.internal.zzy;
import com.google.android.gms.analytics.zza;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzkc;
import com.google.android.gms.internal.zzqh;
import com.google.android.gms.internal.zzqi;
import com.google.android.gms.measurement.zzc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class zzl
extends zzd {
    private boolean mStarted;
    private final zzj zzPE;
    private final zzah zzPF;
    private final zzag zzPG;
    private final zzi zzPH;
    private long zzPI;
    private final zzt zzPJ;
    private final zzt zzPK;
    private final zzaj zzPL;
    private long zzPM;
    private boolean zzPN;

    protected zzl(zzf zzf2, zzg zzg2) {
        super(zzf2);
        zzx.zzy((Object)zzg2);
        this.zzPI = Long.MIN_VALUE;
        this.zzPG = zzg2.zzk(zzf2);
        this.zzPE = zzg2.zzm(zzf2);
        this.zzPF = zzg2.zzn(zzf2);
        this.zzPH = zzg2.zzo(zzf2);
        this.zzPL = new zzaj(this.zziT());
        this.zzPJ = new zzt(zzf2){

            @Override
            public void run() {
                zzl.this.zzjE();
            }
        };
        this.zzPK = new zzt(zzf2){

            @Override
            public void run() {
                zzl.this.zzjF();
            }
        };
    }

    @Override
    protected void zzir() {
        this.zzPE.zza();
        this.zzPF.zza();
        this.zzPH.zza();
    }

    void start() {
        this.zzje();
        zzx.zza((!this.mStarted ? 1 : 0) != 0, (Object)"Analytics backend already started");
        this.mStarted = true;
        if (!this.zziV().zzka()) {
            this.zzjC();
        }
        this.zziW().zzf(new Runnable(){

            @Override
            public void run() {
                zzl.this.zzjD();
            }
        });
    }

    private void zzjC() {
        boolean bl;
        zzf zzf2 = this.zziQ();
        Context context = zzf2.getContext();
        boolean bl2 = AnalyticsReceiver.zzX(context);
        if (!bl2) {
            this.zzbd("AnalyticsReceiver is not registered or is disabled. Register the receiver for reliable dispatching on non-Google Play devices. See http://goo.gl/8Rd3yj for instructions.");
        } else {
            bl = AnalyticsService.zzY(context);
            if (!bl) {
                this.zzbe("AnalyticsService is not registered or is disabled. Analytics service at risk of not starting. See http://goo.gl/8Rd3yj for instructions.");
            }
        }
        bl = CampaignTrackingReceiver.zzX(context);
        if (!bl) {
            this.zzbd("CampaignTrackingReceiver is not registered, not exported or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
        } else {
            boolean bl3 = CampaignTrackingService.zzY(context);
            if (!bl3) {
                this.zzbd("CampaignTrackingService is not registered or is disabled. Installation campaign tracking is not possible. See http://goo.gl/8Rd3yj for instructions.");
            }
        }
    }

    private boolean zzbh(String string) {
        int n = this.getContext().checkCallingOrSelfPermission(string);
        return n == 0;
    }

    protected void zzjD() {
        this.zzje();
        this.zziY().zzlo();
        if (!this.zzbh("android.permission.ACCESS_NETWORK_STATE")) {
            this.zzbe("Missing required android.permission.ACCESS_NETWORK_STATE. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzjS();
        }
        if (!this.zzbh("android.permission.INTERNET")) {
            this.zzbe("Missing required android.permission.INTERNET. Google Analytics disabled. See http://goo.gl/8Rd3yj for instructions");
            this.zzjS();
        }
        if (AnalyticsService.zzY(this.getContext())) {
            this.zzba("AnalyticsService registered in the app manifest and enabled");
        } else if (this.zziV().zzka()) {
            this.zzbe("Device AnalyticsService not registered! Hits will not be delivered reliably.");
        } else {
            this.zzbd("AnalyticsService not registered in the app manifest. Hits might not be delivered reliably. See http://goo.gl/8Rd3yj for instructions.");
        }
        if (!(this.zzPN || this.zziV().zzka() || this.zzPE.isEmpty())) {
            this.zzjG();
        }
        this.zzjK();
    }

    private void zzjE() {
        this.zzb(new zzw(){

            @Override
            public void zzc(Throwable throwable) {
                zzl.this.zzjK();
            }
        });
    }

    void zziP() {
        this.zziS();
        this.zzPM = this.zziT().currentTimeMillis();
    }

    protected void onServiceConnected() {
        this.zziS();
        if (!this.zziV().zzka()) {
            this.zzjH();
        }
    }

    public void zziN() {
        com.google.android.gms.measurement.zzg.zziS();
        this.zzje();
        this.zzba("Service disconnected");
    }

    public void zzJ(boolean bl) {
        this.zzjK();
    }

    private void zzjF() {
        try {
            this.zzPE.zzjw();
            this.zzjK();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Failed to delete stale hits", (Object)sQLiteException);
        }
        this.zzPK.zzt(this.zziV().zzkC());
    }

    protected void zzc(zzh zzh2) {
        this.zziS();
        this.zzb("Sending first hit to property", zzh2.zzjn());
        if (this.zziY().zzlp().zzv(this.zziV().zzkF())) {
            return;
        }
        String string = this.zziY().zzls();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        zzqi zzqi2 = zzam.zza(this.zziU(), string);
        this.zzb("Found relevant installation campaign", zzqi2);
        this.zza(zzh2, zzqi2);
    }

    public void zzs(long l) {
        com.google.android.gms.measurement.zzg.zziS();
        this.zzje();
        if (l < 0L) {
            l = 0L;
        }
        this.zzPI = l;
        this.zzjK();
    }

    protected void zzjG() {
        if (this.zzPN) {
            return;
        }
        if (!this.zziV().zzkc()) {
            return;
        }
        if (this.zzPH.isConnected()) {
            return;
        }
        long l = this.zziV().zzkx();
        if (this.zzPL.zzv(l)) {
            this.zzPL.start();
            this.zzba("Connecting to service");
            if (this.zzPH.connect()) {
                this.zzba("Connected to service");
                this.zzPL.clear();
                this.onServiceConnected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long zza(zzh zzh2, boolean bl) {
        zzx.zzy((Object)zzh2);
        this.zzje();
        this.zziS();
        long l = -1L;
        try {
            this.zzPE.beginTransaction();
            this.zzPE.zza(zzh2.zzjm(), zzh2.getClientId());
            l = this.zzPE.zza(zzh2.zzjm(), zzh2.getClientId(), zzh2.zzjn());
            if (!bl) {
                zzh2.zzn(l);
            } else {
                zzh2.zzn(l + 1L);
            }
            this.zzPE.zzb(zzh2);
            this.zzPE.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to update Analytics property", (Object)sQLiteException);
            long l2 = -1L;
            return l2;
        }
        finally {
            try {
                this.zzPE.endTransaction();
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to end transaction", (Object)sQLiteException);
            }
        }
        return l;
    }

    public void zza(zzab zzab2) {
        zzx.zzy((Object)zzab2);
        com.google.android.gms.measurement.zzg.zziS();
        this.zzje();
        if (this.zzPN) {
            this.zzbb("Hit delivery not possible. Missing network permissions. See http://goo.gl/8Rd3yj for instructions");
        } else {
            this.zza("Delivering hit", zzab2);
        }
        zzab2 = this.zzf(zzab2);
        this.zzjG();
        if (this.zzPH.zzb(zzab2)) {
            this.zzbb("Hit sent to the device AnalyticsService for delivery");
            return;
        }
        if (this.zziV().zzka()) {
            this.zziU().zza(zzab2, "Service unavailable on package side");
            return;
        }
        try {
            this.zzPE.zzc(zzab2);
            this.zzjK();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Delivery failed to save hit to a database", (Object)sQLiteException);
            this.zziU().zza(zzab2, "deliver: failed to insert hit to database");
        }
    }

    public void zziK() {
        com.google.android.gms.measurement.zzg.zziS();
        this.zzje();
        if (!this.zziV().zzka()) {
            this.zzba("Delete all hits from local store");
            try {
                this.zzPE.zzju();
                this.zzPE.zzjv();
                this.zzjK();
            }
            catch (SQLiteException sQLiteException) {
                this.zzd("Failed to delete hits from store", (Object)sQLiteException);
            }
        }
        this.zzjG();
        if (this.zzPH.zzjq()) {
            this.zzba("Device service unavailable. Can't clear hits stored on the device service.");
        }
    }

    zzab zzf(zzab zzab2) {
        if (!TextUtils.isEmpty((CharSequence)zzab2.zzle())) {
            return zzab2;
        }
        zzai.zza zza2 = this.zziY().zzlt();
        Pair<String, Long> pair = zza2.zzlw();
        if (pair == null) {
            return zzab2;
        }
        Long l = (Long)pair.second;
        String string = (String)pair.first;
        String string2 = l + ":" + string;
        HashMap<String, String> hashMap = new HashMap<String, String>(zzab2.zzn());
        hashMap.put("_m", string2);
        return zzab.zza(this, zzab2, hashMap);
    }

    public void zzjH() {
        com.google.android.gms.measurement.zzg.zziS();
        this.zzje();
        this.zziR();
        if (!this.zziV().zzkc()) {
            this.zzbd("Service client disabled. Can't dispatch local hits to device AnalyticsService");
        }
        if (!this.zzPH.isConnected()) {
            this.zzba("Service not connected");
            return;
        }
        if (this.zzPE.isEmpty()) {
            return;
        }
        this.zzba("Dispatching local hits to device AnalyticsService");
        block4: while (true) {
            List<zzab> list;
            try {
                list = this.zzPE.zzp(this.zziV().zzkl());
                if (list.isEmpty()) {
                    this.zzjK();
                    return;
                }
            }
            catch (SQLiteException sQLiteException) {
                this.zze("Failed to read hits from store", (Object)sQLiteException);
                this.zzjO();
                return;
            }
            while (true) {
                if (list.isEmpty()) continue block4;
                zzab zzab2 = list.get(0);
                if (!this.zzPH.zzb(zzab2)) {
                    this.zzjK();
                    return;
                }
                list.remove(zzab2);
                try {
                    this.zzPE.zzq(zzab2.zzkZ());
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                    this.zzjO();
                    return;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean zzjI() {
        boolean bl;
        com.google.android.gms.measurement.zzg.zziS();
        this.zzje();
        this.zzba("Dispatching a batch of local hits");
        boolean bl2 = !this.zzPH.isConnected() && !this.zziV().zzka();
        boolean bl3 = bl = !this.zzPF.zzlk();
        if (bl2 && bl) {
            this.zzba("No network or service available. Will retry later");
            return false;
        }
        long l = Math.max(this.zziV().zzkl(), this.zziV().zzkm());
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l2 = 0L;
        while (true) {
            try {
                Object object;
                List<zzab> list;
                block38: {
                    this.zzPE.beginTransaction();
                    arrayList.clear();
                    try {
                        list = this.zzPE.zzp(l);
                        if (!list.isEmpty()) break block38;
                        this.zzba("Store is empty, nothing to dispatch");
                        this.zzjO();
                        boolean bl4 = false;
                        return bl4;
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zzd("Failed to read hits from persisted store", (Object)sQLiteException);
                        this.zzjO();
                        boolean bl5 = false;
                        try {
                            this.zzPE.setTransactionSuccessful();
                            this.zzPE.endTransaction();
                        }
                        catch (SQLiteException sQLiteException2) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException2);
                            this.zzjO();
                            return false;
                        }
                        return bl5;
                    }
                }
                this.zza("Hits loaded from store. count", (Object)list.size());
                Object object2 = list.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (((zzab)object).zzkZ() != l2) continue;
                    this.zzd("Database contains successfully uploaded hit", l2, list.size());
                    this.zzjO();
                    boolean bl6 = false;
                    return bl6;
                }
                if (this.zzPH.isConnected() && !this.zziV().zzka()) {
                    this.zzba("Service connected, sending hits to the service");
                    while (!list.isEmpty() && this.zzPH.zzb((zzab)(object2 = list.get(0)))) {
                        l2 = Math.max(l2, ((zzab)object2).zzkZ());
                        list.remove(object2);
                        this.zzb("Hit sent do device AnalyticsService for delivery", object2);
                        try {
                            this.zzPE.zzq(((zzab)object2).zzkZ());
                            arrayList.add(((zzab)object2).zzkZ());
                        }
                        catch (SQLiteException sQLiteException) {
                            this.zze("Failed to remove hit that was send for delivery", (Object)sQLiteException);
                            this.zzjO();
                            boolean bl7 = false;
                            try {
                                this.zzPE.setTransactionSuccessful();
                                this.zzPE.endTransaction();
                            }
                            catch (SQLiteException sQLiteException3) {
                                this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException3);
                                this.zzjO();
                                return false;
                            }
                            return bl7;
                        }
                    }
                }
                if (this.zzPF.zzlk()) {
                    object2 = this.zzPF.zzo(list);
                    object = object2.iterator();
                    while (object.hasNext()) {
                        Long l3 = (Long)object.next();
                        l2 = Math.max(l2, l3);
                    }
                    list.removeAll((Collection<?>)object2);
                    try {
                        this.zzPE.zzm((List<Long>)object2);
                        arrayList.addAll((Collection<Long>)object2);
                    }
                    catch (SQLiteException sQLiteException) {
                        this.zze("Failed to remove successfully uploaded hits", (Object)sQLiteException);
                        this.zzjO();
                        boolean bl8 = false;
                        try {
                            this.zzPE.setTransactionSuccessful();
                            this.zzPE.endTransaction();
                        }
                        catch (SQLiteException sQLiteException4) {
                            this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException4);
                            this.zzjO();
                            return false;
                        }
                        return bl8;
                    }
                }
                if (!arrayList.isEmpty()) continue;
                boolean bl9 = false;
                return bl9;
            }
            finally {
                try {
                    this.zzPE.setTransactionSuccessful();
                    this.zzPE.endTransaction();
                }
                catch (SQLiteException sQLiteException) {
                    this.zze("Failed to commit local dispatch transaction", (Object)sQLiteException);
                    this.zzjO();
                    return false;
                }
                continue;
            }
            break;
        }
    }

    public void zzb(zzw zzw2) {
        this.zza(zzw2, this.zzPM);
    }

    public void zza(final zzw zzw2, final long l) {
        block8: {
            com.google.android.gms.measurement.zzg.zziS();
            this.zzje();
            long l2 = -1L;
            long l3 = this.zziY().zzlq();
            if (l3 != 0L) {
                l2 = Math.abs(this.zziT().currentTimeMillis() - l3);
            }
            this.zzb("Dispatching local hits. Elapsed time since last dispatch (ms)", l2);
            if (!this.zziV().zzka()) {
                this.zzjG();
            }
            try {
                boolean bl = this.zzjI();
                if (bl) {
                    this.zziW().zzf(new Runnable(){

                        @Override
                        public void run() {
                            zzl.this.zza(zzw2, l);
                        }
                    });
                } else {
                    this.zziY().zzlr();
                    this.zzjK();
                    if (zzw2 != null) {
                        zzw2.zzc(null);
                    }
                    if (this.zzPM != l) {
                        this.zzPG.zzlj();
                    }
                }
            }
            catch (Throwable throwable) {
                this.zze("Local dispatch failed", throwable);
                this.zziY().zzlr();
                this.zzjK();
                if (zzw2 == null) break block8;
                zzw2.zzc(throwable);
            }
        }
    }

    public void zzjJ() {
        com.google.android.gms.measurement.zzg.zziS();
        this.zzje();
        this.zzbb("Sync dispatching local hits");
        long l = this.zzPM;
        if (!this.zziV().zzka()) {
            this.zzjG();
        }
        try {
            while (this.zzjI()) {
            }
            this.zziY().zzlr();
            this.zzjK();
            if (this.zzPM != l) {
                this.zzPG.zzlj();
            }
        }
        catch (Throwable throwable) {
            this.zze("Sync local dispatch failed", throwable);
            this.zzjK();
        }
    }

    public long zzjx() {
        com.google.android.gms.measurement.zzg.zziS();
        this.zzje();
        try {
            return this.zzPE.zzjx();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Failed to get min/max hit times from local store", (Object)sQLiteException);
            return 0L;
        }
    }

    public void zzjK() {
        boolean bl;
        this.zziQ().zziS();
        this.zzje();
        if (!this.zzjL()) {
            this.zzPG.unregister();
            this.zzjO();
            return;
        }
        if (this.zzPE.isEmpty()) {
            this.zzPG.unregister();
            this.zzjO();
            return;
        }
        if (!zzy.zzQY.get().booleanValue()) {
            this.zzPG.zzlh();
            bl = this.zzPG.isConnected();
        } else {
            bl = true;
        }
        if (bl) {
            this.zzjN();
        } else {
            this.zzjO();
            this.zzjM();
        }
    }

    private boolean zzjL() {
        if (this.zzPN) {
            return false;
        }
        if (this.zziV().zzka() && !this.zziV().zzkb()) {
            return false;
        }
        return this.zzjR() > 0L;
    }

    private void zzjM() {
        long l;
        long l2;
        long l3;
        zzv zzv2 = this.zziX();
        if (!zzv2.zzkK()) {
            return;
        }
        if (!zzv2.zzbr() && (l3 = this.zzjx()) != 0L && (l2 = Math.abs((l = this.zziT().currentTimeMillis()) - l3)) <= this.zziV().zzkk()) {
            long l4 = this.zziV().zzkj();
            this.zza("Dispatch alarm scheduled (ms)", (Object)l4);
            zzv2.zzkL();
        }
    }

    private void zzjN() {
        long l;
        long l2;
        this.zzjM();
        long l3 = this.zzjR();
        long l4 = this.zziY().zzlq();
        long l5 = l4 != 0L ? ((l2 = l3 - (l = Math.abs(this.zziT().currentTimeMillis() - l4))) > 0L ? l2 : Math.min(this.zziV().zzkh(), l3)) : Math.min(this.zziV().zzkh(), l3);
        this.zza("Dispatch scheduled (ms)", (Object)l5);
        if (this.zzPJ.zzbr()) {
            l = Math.max(1L, l5 + this.zzPJ.zzkH());
            this.zzPJ.zzu(l);
        } else {
            this.zzPJ.zzt(l5);
        }
    }

    private void zzjO() {
        this.zzjP();
        this.zzjQ();
    }

    private void zzjP() {
        if (this.zzPJ.zzbr()) {
            this.zzba("All hits dispatched or no network/service. Going to power save mode");
        }
        this.zzPJ.cancel();
    }

    private void zzjQ() {
        zzv zzv2 = this.zziX();
        if (zzv2.zzbr()) {
            zzv2.cancel();
        }
    }

    public long zzjR() {
        if (this.zzPI != Long.MIN_VALUE) {
            return this.zzPI;
        }
        long l = this.zziV().zzki();
        if (this.zziq().zzkU()) {
            l = (long)this.zziq().zzlL() * 1000L;
        }
        return l;
    }

    public void zzbi(String string) {
        zzx.zzcG((String)string);
        this.zziS();
        this.zziR();
        zzqi zzqi2 = zzam.zza(this.zziU(), string);
        if (zzqi2 == null) {
            this.zzd("Parsing failed. Ignoring invalid campaign data", string);
            return;
        }
        String string2 = this.zziY().zzls();
        if (string.equals(string2)) {
            this.zzbd("Ignoring duplicate install campaign");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            this.zzd("Ignoring multiple install campaigns. original, new", string2, string);
            return;
        }
        this.zziY().zzbm(string);
        if (this.zziY().zzlp().zzv(this.zziV().zzkF())) {
            this.zzd("Campaign received too late, ignoring", zzqi2);
            return;
        }
        this.zzb("Received installation campaign", zzqi2);
        List<zzh> list = this.zzPE.zzr(0L);
        for (zzh zzh2 : list) {
            this.zza(zzh2, zzqi2);
        }
    }

    private void zza(zzh zzh2, zzqi zzqi2) {
        zzx.zzy((Object)zzh2);
        zzx.zzy((Object)zzqi2);
        zza zza2 = new zza(this.zziQ());
        zza2.zzaP(zzh2.zzjn());
        zza2.enableAdvertisingIdCollection(zzh2.zzjo());
        zzc zzc2 = zza2.zzig();
        zzkc zzkc2 = zzc2.zze(zzkc.class);
        zzkc2.zzaU("data");
        zzkc2.zzI(true);
        zzc2.zzb(zzqi2);
        zzkb zzkb2 = zzc2.zze(zzkb.class);
        zzqh zzqh2 = zzc2.zze(zzqh.class);
        for (Map.Entry<String, String> entry : zzh2.zzn().entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if ("an".equals(string)) {
                zzqh2.setAppName(string2);
                continue;
            }
            if ("av".equals(string)) {
                zzqh2.setAppVersion(string2);
                continue;
            }
            if ("aid".equals(string)) {
                zzqh2.setAppId(string2);
                continue;
            }
            if ("aiid".equals(string)) {
                zzqh2.setAppInstallerId(string2);
                continue;
            }
            if ("uid".equals(string)) {
                zzkc2.setUserId(string2);
                continue;
            }
            zzkb2.set(string, string2);
        }
        this.zzb("Sending installation campaign to", zzh2.zzjn(), zzqi2);
        zzc2.zzM(this.zziY().zzlo());
        zzc2.zzzI();
    }

    public void zzjS() {
        this.zzje();
        this.zziS();
        this.zzPN = true;
        this.zzPH.disconnect();
        this.zzjK();
    }
}

