/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.PowerManager;
import android.os.WorkSource;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.stats.zzg;
import com.google.android.gms.common.stats.zzi;
import com.google.android.gms.internal.zzmt;
import com.google.android.gms.internal.zznx;
import com.google.android.gms.internal.zzob;
import com.google.android.gms.internal.zzoc;

public class zzse {
    private static String TAG = "WakeLock";
    private static String zzbce = "*gcore*:";
    private static boolean DEBUG = false;
    private final PowerManager.WakeLock zzbcf;
    private WorkSource zzbcg;
    private final int zzbch;
    private final String zzalZ;
    private final String zzbci;
    private final Context mContext;
    private boolean zzbcj = true;
    private int zzbck;
    private int zzbcl;

    public zzse(Context context, int n, String string, String string2, String string3) {
        zzx.zzh((String)string, (Object)"Wake lock name can NOT be empty");
        this.zzbch = n;
        this.zzbci = string2;
        this.mContext = context.getApplicationContext();
        this.zzalZ = !zzob.zzcP((String)string3) && "com.google.android.gms" != string3 ? zzbce + string : string;
        this.zzbcf = ((PowerManager)context.getSystemService("power")).newWakeLock(n, string);
        if (zzoc.zzaz((Context)this.mContext)) {
            String string4;
            if (zzob.zzcP((String)string3)) {
                if (zzd.zzaiU && zzmt.isInitialized()) {
                    Log.e((String)TAG, (String)("callingPackage is not supposed to be empty for wakelock " + this.zzalZ + "!"), (Throwable)new IllegalArgumentException());
                    string4 = "com.google.android.gms";
                } else {
                    string4 = context.getPackageName();
                }
            } else {
                string4 = string3;
            }
            this.zzbcg = zzoc.zzk((Context)context, (String)string4);
            this.zzc(this.zzbcg);
        }
    }

    public zzse(Context context, int n, String string) {
        this(context, n, string, null, null);
    }

    public void acquire(long timeout) {
        if (!zznx.zzrQ() && this.zzbcj) {
            Log.wtf((String)TAG, (String)("Do not acquire with timeout on reference counted WakeLocks before ICS. wakelock: " + this.zzalZ));
        }
        this.zzj(null, timeout);
        this.zzbcf.acquire(timeout);
    }

    public void release() {
        this.zzeV(null);
        this.zzbcf.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzj(String string, long l) {
        boolean bl = this.zzeW(string);
        String string2 = this.zzj(string, bl);
        if (DEBUG) {
            Log.d((String)TAG, (String)("Acquire:\n mWakeLockName: " + this.zzalZ + "\n mSecondaryName: " + this.zzbci + "\nmReferenceCounted: " + this.zzbcj + "\nreason: " + string + "\nmOpenEventCount" + this.zzbcl + "\nuseWithReason: " + bl + "\ntrackingName: " + string2 + "\ntimeout: " + l));
        }
        zzse zzse2 = this;
        synchronized (zzse2) {
            if (this.zzbcj && (this.zzbck++ == 0 || bl) || !this.zzbcj && this.zzbcl == 0) {
                zzi.zzrJ().zza(this.mContext, zzg.zza((PowerManager.WakeLock)this.zzbcf, (String)string2), 7, this.zzalZ, string2, this.zzbch, zzoc.zzb((WorkSource)this.zzbcg), l);
                ++this.zzbcl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzeV(String string) {
        boolean bl = this.zzeW(string);
        String string2 = this.zzj(string, bl);
        if (DEBUG) {
            Log.d((String)TAG, (String)("Release:\n mWakeLockName: " + this.zzalZ + "\n mSecondaryName: " + this.zzbci + "\nmReferenceCounted: " + this.zzbcj + "\nreason: " + string + "\n mOpenEventCount" + this.zzbcl + "\nuseWithReason: " + bl + "\ntrackingName: " + string2));
        }
        zzse zzse2 = this;
        synchronized (zzse2) {
            if (this.zzbcj && (--this.zzbck == 0 || bl) || !this.zzbcj && this.zzbcl == 1) {
                zzi.zzrJ().zza(this.mContext, zzg.zza((PowerManager.WakeLock)this.zzbcf, (String)string2), 8, this.zzalZ, string2, this.zzbch, zzoc.zzb((WorkSource)this.zzbcg));
                --this.zzbcl;
            }
        }
    }

    private boolean zzeW(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && !string.equals(this.zzbci);
    }

    private String zzj(String string, boolean bl) {
        return this.zzbcj ? (bl ? string : this.zzbci) : this.zzbci;
    }

    public void setReferenceCounted(boolean value) {
        this.zzbcf.setReferenceCounted(value);
        this.zzbcj = value;
    }

    public boolean isHeld() {
        return this.zzbcf.isHeld();
    }

    public void zzc(WorkSource workSource) {
        if (zzoc.zzaz((Context)this.mContext) && workSource != null) {
            if (this.zzbcg != null) {
                this.zzbcg.add(workSource);
            } else {
                this.zzbcg = workSource;
            }
            this.zzbcf.setWorkSource(this.zzbcg);
        }
    }
}

