/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Process;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzqh;
import com.google.android.gms.internal.zzqj;
import com.google.android.gms.measurement.zzf;
import com.google.android.gms.measurement.zzh;
import com.google.android.gms.measurement.zzi;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzg {
    private static volatile zzg zzaRx;
    private final Context mContext;
    private final List<zzh> zzaRy;
    private final com.google.android.gms.measurement.zzb zzaRz;
    private final zza zzaRA;
    private volatile zzqh zzPD;
    private Thread.UncaughtExceptionHandler zzaRB;

    zzg(Context context) {
        Context context2 = context.getApplicationContext();
        zzx.zzy((Object)context2);
        this.mContext = context2;
        this.zzaRA = new zza();
        this.zzaRy = new CopyOnWriteArrayList<zzh>();
        this.zzaRz = new com.google.android.gms.measurement.zzb();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzg zzaT(Context context) {
        zzx.zzy((Object)context);
        if (zzaRx != null) return zzaRx;
        Class<zzg> clazz = zzg.class;
        synchronized (zzg.class) {
            if (zzaRx != null) return zzaRx;
            zzaRx = new zzg(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzaRx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzqh zzzR() {
        if (this.zzPD == null) {
            zzg zzg2 = this;
            synchronized (zzg2) {
                if (this.zzPD == null) {
                    zzqh zzqh2 = new zzqh();
                    PackageManager packageManager = this.mContext.getPackageManager();
                    String string = this.mContext.getPackageName();
                    zzqh2.setAppId(string);
                    zzqh2.setAppInstallerId(packageManager.getInstallerPackageName(string));
                    String string2 = string;
                    String string3 = null;
                    try {
                        PackageInfo packageInfo = packageManager.getPackageInfo(this.mContext.getPackageName(), 0);
                        if (packageInfo != null) {
                            CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                                string2 = charSequence.toString();
                            }
                            string3 = packageInfo.versionName;
                        }
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        Log.e((String)"GAv4", (String)("Error retrieving package info: appName set to " + string2));
                    }
                    zzqh2.setAppName(string2);
                    zzqh2.setAppVersion(string3);
                    this.zzPD = zzqh2;
                }
            }
        }
        return this.zzPD;
    }

    public zzqj zzzS() {
        DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
        zzqj zzqj2 = new zzqj();
        zzqj2.setLanguage(zzam.zza(Locale.getDefault()));
        zzqj2.zzip(displayMetrics.widthPixels);
        zzqj2.zziq(displayMetrics.heightPixels);
        return zzqj2;
    }

    void zze(com.google.android.gms.measurement.zzc zzc2) {
        if (zzc2.zzzN()) {
            throw new IllegalStateException("Measurement prototype can't be submitted");
        }
        if (zzc2.zzzJ()) {
            throw new IllegalStateException("Measurement can only be submitted once");
        }
        final com.google.android.gms.measurement.zzc zzc3 = zzc2.zzzE();
        zzc3.zzzK();
        this.zzaRA.execute(new Runnable(){

            @Override
            public void run() {
                zzf zzf2 = zzc3.zzzL();
                zzf2.zza(zzc3);
                for (zzh zzh2 : zzg.this.zzaRy) {
                    zzh2.zza(zzc3);
                }
                zzg.this.zzb(zzc3);
            }
        });
    }

    public Context getContext() {
        return this.mContext;
    }

    public static void zziS() {
        if (!(Thread.currentThread() instanceof zzc)) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    public void zza(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.zzaRB = uncaughtExceptionHandler;
    }

    public <V> Future<V> zzc(Callable<V> callable) {
        zzx.zzy(callable);
        if (Thread.currentThread() instanceof zzc) {
            FutureTask<V> futureTask = new FutureTask<V>(callable);
            futureTask.run();
            return futureTask;
        }
        return this.zzaRA.submit(callable);
    }

    public void zzf(Runnable runnable) {
        zzx.zzy((Object)runnable);
        this.zzaRA.submit(runnable);
    }

    private void zzb(com.google.android.gms.measurement.zzc zzc2) {
        zzx.zzcy((String)"deliver should be called from worker thread");
        zzx.zzb((boolean)zzc2.zzzJ(), (Object)"Measurement must be submitted");
        List<zzi> list = zzc2.zzzG();
        if (list.isEmpty()) {
            return;
        }
        HashSet<Uri> hashSet = new HashSet<Uri>();
        for (zzi zzi2 : list) {
            Uri uri = zzi2.zzii();
            if (hashSet.contains(uri)) continue;
            hashSet.add(uri);
            zzi2.zzb(zzc2);
        }
    }

    private static class zzb
    implements ThreadFactory {
        private static final AtomicInteger zzaRF = new AtomicInteger();

        private zzb() {
        }

        @Override
        public Thread newThread(Runnable target) {
            String string = "measurement-" + zzaRF.incrementAndGet();
            return new zzc(target, string);
        }
    }

    private static class zzc
    extends Thread {
        zzc(Runnable runnable, String string) {
            super(runnable, string);
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            super.run();
        }
    }

    private class zza
    extends ThreadPoolExecutor {
        public zza() {
            super(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            this.setThreadFactory(new zzb());
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
            return new FutureTask<T>(runnable, value){

                @Override
                protected void setException(Throwable error) {
                    Thread.UncaughtExceptionHandler uncaughtExceptionHandler = zzg.this.zzaRB;
                    if (uncaughtExceptionHandler != null) {
                        uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), error);
                    } else if (Log.isLoggable((String)"GAv4", (int)6)) {
                        Log.e((String)"GAv4", (String)("MeasurementExecutor: job failed with " + error));
                    }
                    super.setException(error);
                }
            };
        }
    }
}

