/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import com.google.android.gms.internal.zzaf;
import com.google.android.gms.internal.zzsh;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.zzah;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzbo;
import com.google.android.gms.tagmanager.zzcb;
import com.google.android.gms.tagmanager.zzcp;
import com.google.android.gms.tagmanager.zzdf;
import com.google.android.gms.tagmanager.zzt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Container {
    private final Context mContext;
    private final String zzbcF;
    private final DataLayer zzbcG;
    private zzcp zzbcH;
    private Map<String, FunctionCallMacroCallback> zzbcI = new HashMap<String, FunctionCallMacroCallback>();
    private Map<String, FunctionCallTagCallback> zzbcJ = new HashMap<String, FunctionCallTagCallback>();
    private volatile long zzbcK;
    private volatile String zzbcL = "";

    Container(Context context, DataLayer dataLayer, String containerId, long lastRefreshTime, zzsh.zzc resource) {
        this.mContext = context;
        this.zzbcG = dataLayer;
        this.zzbcF = containerId;
        this.zzbcK = lastRefreshTime;
        this.zza(resource);
    }

    Container(Context context, DataLayer dataLayer, String containerId, long lastRefreshTime, zzaf.zzj resource) {
        this.mContext = context;
        this.zzbcG = dataLayer;
        this.zzbcF = containerId;
        this.zzbcK = lastRefreshTime;
        this.zza(resource.zzjl);
        if (resource.zzjk != null) {
            this.zza(resource.zzjk);
        }
    }

    public String getContainerId() {
        return this.zzbcF;
    }

    public boolean getBoolean(String key) {
        zzcp zzcp2 = this.zzEg();
        if (zzcp2 == null) {
            zzbg.e("getBoolean called for closed container.");
            return zzdf.zzFG();
        }
        try {
            return zzdf.zzk(zzcp2.zzfz(key).getObject());
        }
        catch (Exception exception) {
            zzbg.e("Calling getBoolean() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzdf.zzFG();
        }
    }

    public double getDouble(String key) {
        zzcp zzcp2 = this.zzEg();
        if (zzcp2 == null) {
            zzbg.e("getDouble called for closed container.");
            return zzdf.zzFF();
        }
        try {
            return zzdf.zzj(zzcp2.zzfz(key).getObject());
        }
        catch (Exception exception) {
            zzbg.e("Calling getDouble() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzdf.zzFF();
        }
    }

    public long getLong(String key) {
        zzcp zzcp2 = this.zzEg();
        if (zzcp2 == null) {
            zzbg.e("getLong called for closed container.");
            return zzdf.zzFE();
        }
        try {
            return zzdf.zzi(zzcp2.zzfz(key).getObject());
        }
        catch (Exception exception) {
            zzbg.e("Calling getLong() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzdf.zzFE();
        }
    }

    public String getString(String key) {
        zzcp zzcp2 = this.zzEg();
        if (zzcp2 == null) {
            zzbg.e("getString called for closed container.");
            return zzdf.zzFI();
        }
        try {
            return zzdf.zzg(zzcp2.zzfz(key).getObject());
        }
        catch (Exception exception) {
            zzbg.e("Calling getString() threw an exception: " + exception.getMessage() + " Returning default value.");
            return zzdf.zzFI();
        }
    }

    public long getLastRefreshTime() {
        return this.zzbcK;
    }

    public boolean isDefault() {
        return this.getLastRefreshTime() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallMacroCallback(String customMacroName, FunctionCallMacroCallback customMacroCallback) {
        if (customMacroCallback == null) {
            throw new NullPointerException("Macro handler must be non-null");
        }
        Map<String, FunctionCallMacroCallback> map = this.zzbcI;
        synchronized (map) {
            this.zzbcI.put(customMacroName, customMacroCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallMacroCallback(String customMacroName) {
        Map<String, FunctionCallMacroCallback> map = this.zzbcI;
        synchronized (map) {
            this.zzbcI.remove(customMacroName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionCallMacroCallback zzfb(String string) {
        Map<String, FunctionCallMacroCallback> map = this.zzbcI;
        synchronized (map) {
            return this.zzbcI.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallTagCallback(String customTagName, FunctionCallTagCallback customTagCallback) {
        if (customTagCallback == null) {
            throw new NullPointerException("Tag callback must be non-null");
        }
        Map<String, FunctionCallTagCallback> map = this.zzbcJ;
        synchronized (map) {
            this.zzbcJ.put(customTagName, customTagCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallTagCallback(String customTagName) {
        Map<String, FunctionCallTagCallback> map = this.zzbcJ;
        synchronized (map) {
            this.zzbcJ.remove(customTagName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionCallTagCallback zzfc(String string) {
        Map<String, FunctionCallTagCallback> map = this.zzbcJ;
        synchronized (map) {
            return this.zzbcJ.get(string);
        }
    }

    public void zzfd(String string) {
        this.zzEg().zzfd(string);
    }

    public String zzEf() {
        return this.zzbcL;
    }

    private void zza(zzaf.zzf zzf2) {
        if (zzf2 == null) {
            throw new NullPointerException();
        }
        zzsh.zzc zzc2 = null;
        try {
            zzc2 = zzsh.zzb(zzf2);
        }
        catch (zzsh.zzg zzg2) {
            zzbg.e("Not loading resource: " + (Object)((Object)zzf2) + " because it is invalid: " + zzg2.toString());
            return;
        }
        this.zza(zzc2);
    }

    private void zza(zzaf.zzi[] zziArray) {
        ArrayList<zzaf.zzi> arrayList = new ArrayList<zzaf.zzi>();
        for (zzaf.zzi zzi2 : zziArray) {
            arrayList.add(zzi2);
        }
        this.zzEg().zzC(arrayList);
    }

    private void zza(zzsh.zzc zzc2) {
        this.zzbcL = zzc2.getVersion();
        zzah zzah2 = this.zzfe(this.zzbcL);
        zzcp zzcp2 = new zzcp(this.mContext, zzc2, this.zzbcG, new zza(), new zzb(), zzah2);
        this.zza(zzcp2);
        if (this.getBoolean("_gtm.loadEventEnabled")) {
            this.zzbcG.pushEvent("gtm.load", DataLayer.mapOf("gtm.id", this.zzbcF));
        }
    }

    zzah zzfe(String string) {
        if (zzcb.zzEY().zzEZ().equals((Object)zzcb.zza.zzbeP)) {
            // empty if block
        }
        return new zzbo();
    }

    private synchronized void zza(zzcp zzcp2) {
        this.zzbcH = zzcp2;
    }

    private synchronized zzcp zzEg() {
        return this.zzbcH;
    }

    void release() {
        this.zzbcH = null;
    }

    private class zzb
    implements zzt.zza {
        private zzb() {
        }

        @Override
        public Object zzc(String string, Map<String, Object> map) {
            FunctionCallTagCallback functionCallTagCallback = Container.this.zzfc(string);
            if (functionCallTagCallback != null) {
                functionCallTagCallback.execute(string, map);
            }
            return zzdf.zzFI();
        }
    }

    private class zza
    implements zzt.zza {
        private zza() {
        }

        @Override
        public Object zzc(String string, Map<String, Object> map) {
            FunctionCallMacroCallback functionCallMacroCallback = Container.this.zzfb(string);
            return functionCallMacroCallback == null ? null : functionCallMacroCallback.getValue(string, map);
        }
    }

    public static interface FunctionCallTagCallback {
        public void execute(String var1, Map<String, Object> var2);
    }

    public static interface FunctionCallMacroCallback {
        public Object getValue(String var1, Map<String, Object> var2);
    }
}

