/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import com.google.android.gms.tagmanager.zzbg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataLayer {
    public static final Object OBJECT_NOT_PRESENT = new Object();
    public static final String EVENT_KEY = "event";
    static final String[] zzbdk = "gtm.lifetime".toString().split("\\.");
    private static final Pattern zzbdl = Pattern.compile("(\\d+)\\s*([smhd]?)");
    private final ConcurrentHashMap<zzb, Integer> zzbdm;
    private final Map<String, Object> zzbdn;
    private final ReentrantLock zzbdo;
    private final LinkedList<Map<String, Object>> zzbdp;
    private final zzc zzbdq;
    private final CountDownLatch zzbdr;

    DataLayer() {
        this(new zzc(){

            @Override
            public void zza(List<zza> list, long l) {
            }

            @Override
            public void zza(zzc.zza zza2) {
                zza2.zzy(new ArrayList<zza>());
            }

            @Override
            public void zzfl(String string) {
            }
        });
    }

    DataLayer(zzc persistentStore) {
        this.zzbdq = persistentStore;
        this.zzbdm = new ConcurrentHashMap();
        this.zzbdn = new HashMap<String, Object>();
        this.zzbdo = new ReentrantLock();
        this.zzbdp = new LinkedList();
        this.zzbdr = new CountDownLatch(1);
        this.zzEr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Map<String, Object> map = this.zzbdn;
        synchronized (map) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, Object> entry : this.zzbdn.entrySet()) {
                stringBuilder.append(String.format("{\n\tKey: %s\n\tValue: %s\n}\n", entry.getKey(), entry.getValue()));
            }
            return stringBuilder.toString();
        }
    }

    public void pushEvent(String eventName, Map<String, Object> update) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(update);
        hashMap.put(EVENT_KEY, eventName);
        this.push(hashMap);
    }

    public void push(String key, Object value) {
        Map<String, Object> map = this.zzn(key, value);
        this.push(map);
    }

    public void push(Map<String, Object> update) {
        try {
            this.zzbdr.await();
        }
        catch (InterruptedException interruptedException) {
            zzbg.zzaH("DataLayer.push: unexpected InterruptedException");
        }
        this.zzL(update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzL(Map<String, Object> map) {
        this.zzbdo.lock();
        try {
            this.zzbdp.offer(map);
            if (this.zzbdo.getHoldCount() == 1) {
                this.zzEs();
            }
            this.zzM(map);
        }
        finally {
            this.zzbdo.unlock();
        }
    }

    private void zzEr() {
        this.zzbdq.zza(new zzc.zza(){

            @Override
            public void zzy(List<zza> list) {
                for (zza zza2 : list) {
                    DataLayer.this.zzL(DataLayer.this.zzn(zza2.zzuX, zza2.zzLI));
                }
                DataLayer.this.zzbdr.countDown();
            }
        });
    }

    private void zzM(Map<String, Object> map) {
        Long l = this.zzN(map);
        if (l == null) {
            return;
        }
        List<zza> list = this.zzP(map);
        list.remove("gtm.lifetime");
        this.zzbdq.zza(list, l);
    }

    private Long zzN(Map<String, Object> map) {
        Object object = this.zzO(map);
        if (object == null) {
            return null;
        }
        return DataLayer.zzfk(object.toString());
    }

    private Object zzO(Map<String, Object> map) {
        Object object = map;
        for (String string : zzbdk) {
            if (!(object instanceof Map)) {
                return null;
            }
            Map<String, Object> map2 = object;
            object = map2.get(string);
        }
        return object;
    }

    void zzfj(String string) {
        this.push(string, null);
        this.zzbdq.zzfl(string);
    }

    private List<zza> zzP(Map<String, Object> map) {
        ArrayList<zza> arrayList = new ArrayList<zza>();
        this.zza(map, "", arrayList);
        return arrayList;
    }

    private void zza(Map<String, Object> map, String string, Collection<zza> collection) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string2 = string + (string.length() == 0 ? "" : ".") + entry.getKey();
            if (entry.getValue() instanceof Map) {
                Map map2 = (Map)entry.getValue();
                this.zza(map2, string2, collection);
                continue;
            }
            if (string2.equals("gtm.lifetime")) continue;
            collection.add(new zza(string2, entry.getValue()));
        }
    }

    static Long zzfk(String string) {
        Matcher matcher = zzbdl.matcher(string);
        if (!matcher.matches()) {
            zzbg.zzaG("unknown _lifetime: " + string);
            return null;
        }
        long l = 0L;
        try {
            l = Long.parseLong(matcher.group(1));
        }
        catch (NumberFormatException numberFormatException) {
            zzbg.zzaH("illegal number in _lifetime value: " + string);
        }
        if (l <= 0L) {
            zzbg.zzaG("non-positive _lifetime: " + string);
            return null;
        }
        String string2 = matcher.group(2);
        if (string2.length() == 0) {
            return l;
        }
        switch (string2.charAt(0)) {
            case 's': {
                return l * 1000L;
            }
            case 'm': {
                return l * 1000L * 60L;
            }
            case 'h': {
                return l * 1000L * 60L * 60L;
            }
            case 'd': {
                return l * 1000L * 60L * 60L * 24L;
            }
        }
        zzbg.zzaH("unknown units in _lifetime: " + string);
        return null;
    }

    private void zzEs() {
        Map<String, Object> map;
        int n = 0;
        while ((map = this.zzbdp.poll()) != null) {
            this.zzQ(map);
            if (++n <= 500) continue;
            this.zzbdp.clear();
            throw new RuntimeException("Seems like an infinite loop of pushing to the data layer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzQ(Map<String, Object> map) {
        Map<String, Object> map2 = this.zzbdn;
        synchronized (map2) {
            for (String string : map.keySet()) {
                this.zzd(this.zzn(string, map.get(string)), this.zzbdn);
            }
        }
        this.zzR(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        Map<String, Object> map = this.zzbdn;
        synchronized (map) {
            String[] stringArray;
            Object object = this.zzbdn;
            for (String string : stringArray = key.split("\\.")) {
                if (!(object instanceof Map)) {
                    return null;
                }
                Object object2 = object;
                Object object3 = object2.get(string);
                if (object3 == null) {
                    return null;
                }
                object = object3;
            }
            return object;
        }
    }

    public static Map<String, Object> mapOf(Object ... objects) {
        if (objects.length % 2 != 0) {
            throw new IllegalArgumentException("expected even number of key-value pairs");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < objects.length; i += 2) {
            if (!(objects[i] instanceof String)) {
                throw new IllegalArgumentException("key is not a string: " + objects[i]);
            }
            hashMap.put((String)objects[i], objects[i + 1]);
        }
        return hashMap;
    }

    public static List<Object> listOf(Object ... objects) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objects.length; ++i) {
            arrayList.add(objects[i]);
        }
        return arrayList;
    }

    void zza(zzb zzb2) {
        this.zzbdm.put(zzb2, 0);
    }

    private void zzR(Map<String, Object> map) {
        for (zzb zzb2 : this.zzbdm.keySet()) {
            zzb2.zzJ(map);
        }
    }

    Map<String, Object> zzn(String string, Object object) {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2 = hashMap = new HashMap<String, Object>();
        String[] stringArray = string.toString().split("\\.");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            HashMap hashMap3 = new HashMap();
            hashMap2.put(stringArray[i], hashMap3);
            hashMap2 = hashMap3;
        }
        hashMap2.put(stringArray[stringArray.length - 1], object);
        return hashMap;
    }

    void zzd(Map<String, Object> map, Map<String, Object> map2) {
        for (String string : map.keySet()) {
            Object object;
            Object object2;
            Object object3 = map.get(string);
            if (object3 instanceof List) {
                if (!(map2.get(string) instanceof List)) {
                    map2.put(string, new ArrayList());
                }
                object2 = (List)object3;
                object = (List)map2.get(string);
                this.zzb((List<Object>)object2, (List<Object>)object);
                continue;
            }
            if (object3 instanceof Map) {
                if (!(map2.get(string) instanceof Map)) {
                    map2.put(string, new HashMap());
                }
                object2 = (Map)object3;
                object = (Map)map2.get(string);
                this.zzd((Map<String, Object>)object2, (Map<String, Object>)object);
                continue;
            }
            map2.put(string, object3);
        }
    }

    void zzb(List<Object> list, List<Object> list2) {
        while (list2.size() < list.size()) {
            list2.add(null);
        }
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            Object object2;
            Object object3 = list.get(i);
            if (object3 instanceof List) {
                if (!(list2.get(i) instanceof List)) {
                    list2.set(i, new ArrayList());
                }
                object2 = (List)object3;
                object = (List)list2.get(i);
                this.zzb((List<Object>)object2, (List<Object>)object);
                continue;
            }
            if (object3 instanceof Map) {
                if (!(list2.get(i) instanceof Map)) {
                    list2.set(i, new HashMap());
                }
                object2 = (Map)object3;
                object = (Map)list2.get(i);
                this.zzd((Map<String, Object>)object2, (Map<String, Object>)object);
                continue;
            }
            if (object3 == OBJECT_NOT_PRESENT) continue;
            list2.set(i, object3);
        }
    }

    static interface zzc {
        public void zza(List<com.google.android.gms.tagmanager.DataLayer$zza> var1, long var2);

        public void zza(zza var1);

        public void zzfl(String var1);

        public static interface zza {
            public void zzy(List<com.google.android.gms.tagmanager.DataLayer$zza> var1);
        }
    }

    static final class zza {
        public final String zzuX;
        public final Object zzLI;

        zza(String string, Object object) {
            this.zzuX = string;
            this.zzLI = object;
        }

        public String toString() {
            return "Key: " + this.zzuX + " value: " + this.zzLI.toString();
        }

        public int hashCode() {
            return Arrays.hashCode((Object[])new Integer[]{this.zzuX.hashCode(), this.zzLI.hashCode()});
        }

        public boolean equals(Object o) {
            if (!(o instanceof zza)) {
                return false;
            }
            zza zza2 = (zza)o;
            return this.zzuX.equals(zza2.zzuX) && this.zzLI.equals(zza2.zzLI);
        }
    }

    static interface zzb {
        public void zzJ(Map<String, Object> var1);
    }
}

