/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.tagmanager.ContainerHolder;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzcb;
import com.google.android.gms.tagmanager.zzct;
import com.google.android.gms.tagmanager.zzcu;
import com.google.android.gms.tagmanager.zzd;
import com.google.android.gms.tagmanager.zzo;
import com.google.android.gms.tagmanager.zzp;
import com.google.android.gms.tagmanager.zzs;
import com.google.android.gms.tagmanager.zzw;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TagManager {
    private final zza zzbgd;
    private final Context mContext;
    private final DataLayer zzbcG;
    private final zzct zzbge;
    private final ConcurrentMap<zzo, Boolean> zzbgf;
    private final zzs zzbfa;
    private static TagManager zzbgg;

    TagManager(Context context, zza containerHolderLoaderProvider, DataLayer dataLayer, zzct serviceManager) {
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        this.mContext = context.getApplicationContext();
        this.zzbge = serviceManager;
        this.zzbgd = containerHolderLoaderProvider;
        this.zzbgf = new ConcurrentHashMap<zzo, Boolean>();
        this.zzbcG = dataLayer;
        this.zzbcG.zza(new DataLayer.zzb(){

            @Override
            public void zzJ(Map<String, Object> map) {
                Object object = map.get("event");
                if (object != null) {
                    TagManager.this.zzfB(object.toString());
                }
            }
        });
        this.zzbcG.zza(new zzd(this.mContext));
        this.zzbfa = new zzs();
        this.zzFx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TagManager getInstance(Context context) {
        Class<TagManager> clazz = TagManager.class;
        synchronized (TagManager.class) {
            if (zzbgg == null) {
                if (context == null) {
                    zzbg.e("TagManager.getInstance requires non-null context.");
                    throw new NullPointerException();
                }
                zza zza2 = new zza(){

                    @Override
                    public zzp zza(Context context, TagManager tagManager, Looper looper, String string, int n, zzs zzs2) {
                        return new zzp(context, tagManager, looper, string, n, zzs2);
                    }
                };
                zzw zzw2 = new zzw(context);
                zzbgg = new TagManager(context, zza2, new DataLayer(zzw2), zzcu.zzFs());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzbgg;
        }
    }

    public DataLayer getDataLayer() {
        return this.zzbcG;
    }

    public PendingResult<ContainerHolder> loadContainerDefaultOnly(String containerId, int defaultContainerResourceId) {
        zzp zzp2 = this.zzbgd.zza(this.mContext, this, null, containerId, defaultContainerResourceId, this.zzbfa);
        zzp2.zzEk();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerDefaultOnly(String containerId, int defaultContainerResourceId, Handler handler) {
        zzp zzp2 = this.zzbgd.zza(this.mContext, this, handler.getLooper(), containerId, defaultContainerResourceId, this.zzbfa);
        zzp2.zzEk();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferNonDefault(String containerId, int defaultContainerResourceId) {
        zzp zzp2 = this.zzbgd.zza(this.mContext, this, null, containerId, defaultContainerResourceId, this.zzbfa);
        zzp2.zzEl();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferNonDefault(String containerId, int defaultContainerResourceId, Handler handler) {
        zzp zzp2 = this.zzbgd.zza(this.mContext, this, handler.getLooper(), containerId, defaultContainerResourceId, this.zzbfa);
        zzp2.zzEl();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferFresh(String containerId, int defaultContainerResourceId) {
        zzp zzp2 = this.zzbgd.zza(this.mContext, this, null, containerId, defaultContainerResourceId, this.zzbfa);
        zzp2.zzEm();
        return zzp2;
    }

    public PendingResult<ContainerHolder> loadContainerPreferFresh(String containerId, int defaultContainerResourceId, Handler handler) {
        zzp zzp2 = this.zzbgd.zza(this.mContext, this, handler.getLooper(), containerId, defaultContainerResourceId, this.zzbfa);
        zzp2.zzEm();
        return zzp2;
    }

    public void dispatch() {
        this.zzbge.dispatch();
    }

    public void setVerboseLoggingEnabled(boolean enableVerboseLogging) {
        zzbg.setLogLevel(enableVerboseLogging ? 2 : 5);
    }

    synchronized boolean zzp(Uri uri) {
        zzcb zzcb2 = zzcb.zzEY();
        if (zzcb2.zzp(uri)) {
            String string = zzcb2.getContainerId();
            switch (zzcb2.zzEZ()) {
                case zzbeN: {
                    for (zzo zzo2 : this.zzbgf.keySet()) {
                        if (!zzo2.getContainerId().equals(string)) continue;
                        zzo2.zzff(null);
                        zzo2.refresh();
                    }
                    break;
                }
                case zzbeO: 
                case zzbeP: {
                    for (zzo zzo3 : this.zzbgf.keySet()) {
                        if (zzo3.getContainerId().equals(string)) {
                            zzo3.zzff(zzcb2.zzFa());
                            zzo3.refresh();
                            continue;
                        }
                        if (zzo3.zzEh() == null) continue;
                        zzo3.zzff(null);
                        zzo3.refresh();
                    }
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public void zza(zzo zzo2) {
        this.zzbgf.put(zzo2, true);
    }

    public boolean zzb(zzo zzo2) {
        return this.zzbgf.remove(zzo2) != null;
    }

    private void zzfB(String string) {
        for (zzo zzo2 : this.zzbgf.keySet()) {
            zzo2.zzfd(string);
        }
    }

    private void zzFx() {
        if (Build.VERSION.SDK_INT >= 14) {
            this.mContext.registerComponentCallbacks((ComponentCallbacks)new ComponentCallbacks2(){

                public void onTrimMemory(int i) {
                    if (i == 20) {
                        TagManager.this.dispatch();
                    }
                }

                public void onConfigurationChanged(Configuration configuration) {
                }

                public void onLowMemory() {
                }
            });
        }
    }

    public static interface zza {
        public zzp zza(Context var1, TagManager var2, Looper var3, String var4, int var5, zzs var6);
    }
}

