/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.google.android.gms.internal.zzaf;
import com.google.android.gms.internal.zzsh;
import com.google.android.gms.internal.zzsl;
import com.google.android.gms.internal.zzsm;
import com.google.android.gms.tagmanager.zzbf;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzcb;
import com.google.android.gms.tagmanager.zzs;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

class zzcl
implements Runnable {
    private final Context mContext;
    private final zzsm zzbeX;
    private final String zzbcF;
    private final String zzbeY;
    private zzbf<zzaf.zzj> zzbeZ;
    private volatile zzs zzbfa;
    private volatile String zzbdc;
    private volatile String zzbfb;

    public zzcl(Context context, String string, zzs zzs2) {
        this(context, string, new zzsm(), zzs2);
    }

    zzcl(Context context, String string, zzsm zzsm2, zzs zzs2) {
        this.mContext = context;
        this.zzbeX = zzsm2;
        this.zzbcF = string;
        this.zzbfa = zzs2;
        this.zzbdc = this.zzbeY = "/r?id=" + string;
        this.zzbfb = null;
    }

    @Override
    public void run() {
        if (this.zzbeZ == null) {
            throw new IllegalStateException("callback must be set before execute");
        }
        this.zzbeZ.zzEo();
        this.zzFc();
    }

    private boolean zzFb() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            zzbg.v("...no network connectivity");
            return false;
        }
        return true;
    }

    void zza(zzbf<zzaf.zzj> zzbf2) {
        this.zzbeZ = zzbf2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void zzFc() {
        block12: {
            if (!this.zzFb()) {
                this.zzbeZ.zza(zzbf.zza.zzben);
                return;
            }
            zzbg.v("Start loading resource from network ...");
            String string = this.zzFd();
            InputStream inputStream = null;
            try (zzsl zzsl2 = this.zzbeX.zzGf();){
                try {
                    inputStream = zzsl2.zzfU(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    zzbg.zzaH("No data is retrieved from the given url: " + string + ". Make sure container_id: " + this.zzbcF + " is correct.");
                    this.zzbeZ.zza(zzbf.zza.zzbep);
                    zzsl2.close();
                    return;
                }
                catch (IOException iOException) {
                    zzbg.zzd("Error when loading resources from url: " + string + " " + iOException.getMessage(), iOException);
                    this.zzbeZ.zza(zzbf.zza.zzbeo);
                    zzsl2.close();
                    return;
                }
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    zzsh.zzb(inputStream, byteArrayOutputStream);
                    zzaf.zzj zzj2 = zzaf.zzj.zzd(byteArrayOutputStream.toByteArray());
                    zzbg.v("Successfully loaded supplemented resource: " + (Object)((Object)zzj2));
                    if (zzj2.zzjl == null && zzj2.zzjk.length == 0) {
                        zzbg.v("No change for container: " + this.zzbcF);
                    }
                    this.zzbeZ.zzI(zzj2);
                    break block12;
                }
                catch (IOException iOException) {
                    zzbg.zzd("Error when parsing downloaded resources from url: " + string + " " + iOException.getMessage(), iOException);
                    this.zzbeZ.zza(zzbf.zza.zzbep);
                    zzsl2.close();
                    return;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        zzbg.v("Load resource from network finished.");
    }

    String zzFd() {
        String string = this.zzbfa.zzEq() + this.zzbdc + "&v=a65833898";
        if (this.zzbfb != null && !this.zzbfb.trim().equals("")) {
            string = string + "&pv=" + this.zzbfb;
        }
        if (zzcb.zzEY().zzEZ().equals((Object)zzcb.zza.zzbeP)) {
            string = string + "&gtm_debug=x";
        }
        return string;
    }

    void zzfi(String string) {
        if (string == null) {
            this.zzbdc = this.zzbeY;
        } else {
            zzbg.zzaF("Setting CTFE URL path: " + string);
            this.zzbdc = string;
        }
    }

    void zzfx(String string) {
        zzbg.zzaF("Setting previous container version: " + string);
        this.zzbfb = string;
    }
}

