/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.ecommerce.Product;
import com.google.android.gms.analytics.ecommerce.ProductAction;
import com.google.android.gms.analytics.ecommerce.Promotion;
import com.google.android.gms.internal.zzad;
import com.google.android.gms.internal.zzae;
import com.google.android.gms.internal.zzag;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzdc;
import com.google.android.gms.tagmanager.zzdd;
import com.google.android.gms.tagmanager.zzdf;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class zzdg
extends zzdd {
    private static final String ID = zzad.zzcQ.toString();
    private static final String zzbgH = zzae.zzdx.toString();
    private static final String zzbgI = zzae.zzdH.toString();
    private static final String zzbgJ = zzae.zzfe.toString();
    private static final String zzbgK = zzae.zzeY.toString();
    private static final String zzbgL = zzae.zzeX.toString();
    private static final String zzbgM = zzae.zzdG.toString();
    private static final String zzbgN = zzae.zzhF.toString();
    private static final String zzbgO = zzae.zzhI.toString();
    private static final String zzbgP = zzae.zzhK.toString();
    private static final List<String> zzbgQ = Arrays.asList("detail", "checkout", "checkout_option", "click", "add", "remove", "purchase", "refund");
    private static final Pattern zzbgR = Pattern.compile("dimension(\\d+)");
    private static final Pattern zzbgS = Pattern.compile("metric(\\d+)");
    private static Map<String, String> zzbgT;
    private static Map<String, String> zzbgU;
    private final Set<String> zzbgV;
    private final zzdc zzbgW;
    private final DataLayer zzbcG;

    public zzdg(Context context, DataLayer dataLayer) {
        this(context, dataLayer, new zzdc(context));
    }

    zzdg(Context context, DataLayer dataLayer, zzdc zzdc2) {
        super(ID, new String[0]);
        this.zzbcG = dataLayer;
        this.zzbgW = zzdc2;
        this.zzbgV = new HashSet<String>();
        this.zzbgV.add("");
        this.zzbgV.add("0");
        this.zzbgV.add("false");
    }

    private boolean zzj(Map<String, zzag.zza> map, String string) {
        zzag.zza zza2 = map.get(string);
        return zza2 == null ? false : zzdf.zzk(zza2);
    }

    @Override
    public void zzK(Map<String, zzag.zza> map) {
        Tracker tracker = this.zzbgW.zzfC("_GTM_DEFAULT_TRACKER_");
        tracker.enableAdvertisingIdCollection(this.zzj(map, "collect_adid"));
        if (this.zzj(map, zzbgJ)) {
            this.zzb(tracker, map);
        } else if (this.zzj(map, zzbgI)) {
            tracker.send(this.zzm(map.get(zzbgM)));
        } else if (this.zzj(map, zzbgN)) {
            this.zza(tracker, map);
        } else {
            zzbg.zzaH("Ignoring unknown tag.");
        }
    }

    private String zzfK(String string) {
        Object object = this.zzbcG.get(string);
        return object == null ? null : object.toString();
    }

    private List<Map<String, String>> zzfL(String string) {
        Object object = this.zzbcG.get(string);
        if (object == null) {
            return null;
        }
        if (!(object instanceof List)) {
            throw new IllegalArgumentException("transactionProducts should be of type List.");
        }
        List list = (List)object;
        for (Object e : list) {
            if (e instanceof Map) continue;
            throw new IllegalArgumentException("Each element of transactionProducts should be of type Map.");
        }
        List list2 = (List)object;
        return list2;
    }

    private void zze(Map<String, String> map, String string, String string2) {
        if (string2 != null) {
            map.put(string, string2);
        }
    }

    private void zza(Tracker tracker, Map<String, zzag.zza> map) {
        String string = this.zzfK("transactionId");
        if (string == null) {
            zzbg.e("Cannot find transactionId in data layer.");
            return;
        }
        LinkedList<Map<String, String>> linkedList = new LinkedList<Map<String, String>>();
        try {
            Map<String, String> map2 = this.zzm(map.get(zzbgM));
            map2.put("&t", "transaction");
            Map<String, String> map3 = this.zzU(map);
            for (Map.Entry<String, String> iterator : map3.entrySet()) {
                this.zze(map2, iterator.getValue(), this.zzfK(iterator.getKey()));
            }
            linkedList.add(map2);
            List<Map<String, String>> list = this.zzfL("transactionProducts");
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Map map4 = (Map)iterator.next();
                    if (map4.get("name") == null) {
                        zzbg.e("Unable to send transaction item hit due to missing 'name' field.");
                        return;
                    }
                    Map<String, String> map5 = this.zzm(map.get(zzbgM));
                    map5.put("&t", "item");
                    map5.put("&ti", string);
                    Map<String, String> map6 = this.zzV(map);
                    for (Map.Entry<String, String> entry : map6.entrySet()) {
                        this.zze(map5, entry.getValue(), (String)map4.get(entry.getKey()));
                    }
                    linkedList.add(map5);
                }
            }
            for (Map map7 : linkedList) {
                tracker.send(map7);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            zzbg.zzb("Unable to send transaction", illegalArgumentException);
            return;
        }
    }

    private void zzb(Tracker tracker, Map<String, zzag.zza> map) {
        Object object;
        HitBuilders.ScreenViewBuilder screenViewBuilder = new HitBuilders.ScreenViewBuilder();
        Map<String, String> map2 = this.zzm(map.get(zzbgM));
        screenViewBuilder.setAll(map2);
        Map map3 = null;
        if (this.zzj(map, zzbgK)) {
            object = this.zzbcG.get("ecommerce");
            if (object instanceof Map) {
                map3 = (Map)object;
            }
        } else {
            object = zzdf.zzl(map.get(zzbgL));
            if (object instanceof Map) {
                map3 = (Map)object;
            }
        }
        if (map3 != null) {
            Object object2;
            Object object3;
            List list;
            Object v;
            object = map2.get("&cu");
            if (object == null) {
                object = (String)map3.get("currencyCode");
            }
            if (object != null) {
                screenViewBuilder.set("&cu", (String)object);
            }
            if ((v = map3.get("impressions")) instanceof List) {
                list = (List)v;
                for (Iterator<String> iterator : list) {
                    try {
                        Product runtimeException = this.zzT((Map<String, Object>)((Object)iterator));
                        screenViewBuilder.addImpression(runtimeException, (String)iterator.get("list"));
                    }
                    catch (RuntimeException runtimeException) {
                        zzbg.e("Failed to extract a product from DataLayer. " + runtimeException.getMessage());
                    }
                }
            }
            list = null;
            if (map3.containsKey("promoClick")) {
                object3 = (Map)map3.get("promoClick");
                list = (List)object3.get("promotions");
            } else if (map3.containsKey("promoView")) {
                object3 = (Map)map3.get("promoView");
                list = (List)object3.get("promotions");
            }
            boolean bl = true;
            if (list != null) {
                for (Map map4 : list) {
                    try {
                        object2 = this.zzS(map4);
                        screenViewBuilder.addPromotion((Promotion)object2);
                    }
                    catch (RuntimeException runtimeException) {
                        zzbg.e("Failed to extract a promotion from DataLayer. " + runtimeException.getMessage());
                    }
                }
                if (map3.containsKey("promoClick")) {
                    screenViewBuilder.set("&promoa", "click");
                    bl = false;
                } else {
                    screenViewBuilder.set("&promoa", "view");
                }
            }
            if (bl) {
                for (String string : zzbgQ) {
                    if (!map3.containsKey(string)) continue;
                    object2 = (Map)map3.get(string);
                    List list2 = (List)object2.get("products");
                    if (list2 != null) {
                        for (Map map5 : list2) {
                            try {
                                Product product = this.zzT(map5);
                                screenViewBuilder.addProduct(product);
                            }
                            catch (RuntimeException runtimeException) {
                                zzbg.e("Failed to extract a product from DataLayer. " + runtimeException.getMessage());
                            }
                        }
                    }
                    try {
                        Object object4;
                        if (object2.containsKey("actionField")) {
                            Map map5;
                            map5 = (Map)object2.get("actionField");
                            object4 = this.zzd(string, map5);
                        } else {
                            object4 = new ProductAction(string);
                        }
                        screenViewBuilder.setProductAction((ProductAction)object4);
                    }
                    catch (RuntimeException runtimeException) {
                        zzbg.e("Failed to extract a product action from DataLayer. " + runtimeException.getMessage());
                    }
                    break;
                }
            }
        }
        tracker.send(screenViewBuilder.build());
    }

    private ProductAction zzd(String string, Map<String, Object> map) {
        ProductAction productAction = new ProductAction(string);
        Object object = map.get("id");
        if (object != null) {
            productAction.setTransactionId(String.valueOf(object));
        }
        if ((object = map.get("affiliation")) != null) {
            productAction.setTransactionAffiliation(String.valueOf(object));
        }
        if ((object = map.get("coupon")) != null) {
            productAction.setTransactionCouponCode(String.valueOf(object));
        }
        if ((object = map.get("list")) != null) {
            productAction.setProductActionList(String.valueOf(object));
        }
        if ((object = map.get("option")) != null) {
            productAction.setCheckoutOptions(String.valueOf(object));
        }
        if ((object = map.get("revenue")) != null) {
            productAction.setTransactionRevenue(this.zzV(object));
        }
        if ((object = map.get("tax")) != null) {
            productAction.setTransactionTax(this.zzV(object));
        }
        if ((object = map.get("shipping")) != null) {
            productAction.setTransactionShipping(this.zzV(object));
        }
        if ((object = map.get("step")) != null) {
            productAction.setCheckoutStep(this.zzW(object));
        }
        return productAction;
    }

    private Promotion zzS(Map<String, String> map) {
        Promotion promotion = new Promotion();
        String string = map.get("id");
        if (string != null) {
            promotion.setId(String.valueOf(string));
        }
        if ((string = map.get("name")) != null) {
            promotion.setName(String.valueOf(string));
        }
        if ((string = map.get("creative")) != null) {
            promotion.setCreative(String.valueOf(string));
        }
        if ((string = map.get("position")) != null) {
            promotion.setPosition(String.valueOf(string));
        }
        return promotion;
    }

    private Product zzT(Map<String, Object> map) {
        Product product = new Product();
        Object object = map.get("id");
        if (object != null) {
            product.setId(String.valueOf(object));
        }
        if ((object = map.get("name")) != null) {
            product.setName(String.valueOf(object));
        }
        if ((object = map.get("brand")) != null) {
            product.setBrand(String.valueOf(object));
        }
        if ((object = map.get("category")) != null) {
            product.setCategory(String.valueOf(object));
        }
        if ((object = map.get("variant")) != null) {
            product.setVariant(String.valueOf(object));
        }
        if ((object = map.get("coupon")) != null) {
            product.setCouponCode(String.valueOf(object));
        }
        if ((object = map.get("position")) != null) {
            product.setPosition(this.zzW(object));
        }
        if ((object = map.get("price")) != null) {
            product.setPrice(this.zzV(object));
        }
        if ((object = map.get("quantity")) != null) {
            product.setQuantity(this.zzW(object));
        }
        for (String string : map.keySet()) {
            Matcher matcher = zzbgR.matcher(string);
            if (matcher.matches()) {
                int n = 0;
                try {
                    n = Integer.parseInt(matcher.group(1));
                }
                catch (NumberFormatException numberFormatException) {
                    zzbg.zzaH("illegal number in custom dimension value: " + string);
                    continue;
                }
                product.setCustomDimension(n, String.valueOf(map.get(string)));
                continue;
            }
            Matcher matcher2 = zzbgS.matcher(string);
            if (!matcher2.matches()) continue;
            int n = 0;
            try {
                n = Integer.parseInt(matcher2.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                zzbg.zzaH("illegal number in custom metric value: " + string);
                continue;
            }
            product.setCustomMetric(n, this.zzW(map.get(string)));
        }
        return product;
    }

    private Map<String, String> zzc(zzag.zza zza2) {
        Object object = zzdf.zzl(zza2);
        if (!(object instanceof Map)) {
            return null;
        }
        Map map = (Map)object;
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            linkedHashMap.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return linkedHashMap;
    }

    private Map<String, String> zzm(zzag.zza zza2) {
        if (zza2 == null) {
            return new HashMap<String, String>();
        }
        Map<String, String> map = this.zzc(zza2);
        if (map == null) {
            return new HashMap<String, String>();
        }
        String string = map.get("&aip");
        if (string != null && this.zzbgV.contains(string.toLowerCase())) {
            map.remove("&aip");
        }
        return map;
    }

    private Map<String, String> zzU(Map<String, zzag.zza> map) {
        zzag.zza zza2 = map.get(zzbgO);
        if (zza2 != null) {
            return this.zzc(zza2);
        }
        if (zzbgT == null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("transactionId", "&ti");
            hashMap.put("transactionAffiliation", "&ta");
            hashMap.put("transactionTax", "&tt");
            hashMap.put("transactionShipping", "&ts");
            hashMap.put("transactionTotal", "&tr");
            hashMap.put("transactionCurrency", "&cu");
            zzbgT = hashMap;
        }
        return zzbgT;
    }

    private Map<String, String> zzV(Map<String, zzag.zza> map) {
        zzag.zza zza2 = map.get(zzbgP);
        if (zza2 != null) {
            return this.zzc(zza2);
        }
        if (zzbgU == null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", "&in");
            hashMap.put("sku", "&ic");
            hashMap.put("category", "&iv");
            hashMap.put("price", "&ip");
            hashMap.put("quantity", "&iq");
            hashMap.put("currency", "&cu");
            zzbgU = hashMap;
        }
        return zzbgU;
    }

    private Double zzV(Object object) {
        if (object instanceof String) {
            try {
                return Double.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Cannot convert the object to Double: " + numberFormatException.getMessage());
            }
        }
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return n.doubleValue();
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        throw new RuntimeException("Cannot convert the object to Double: " + object.toString());
    }

    private Integer zzW(Object object) {
        if (object instanceof String) {
            try {
                return Integer.valueOf((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Cannot convert the object to Integer: " + numberFormatException.getMessage());
            }
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            return d.intValue();
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new RuntimeException("Cannot convert the object to Integer: " + object.toString());
    }
}

