/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.text.TextUtils;
import com.google.android.gms.analytics.internal.zzaf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzmz;
import com.google.android.gms.internal.zzpr;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class zzam {
    private static final char[] zzTu = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static Map<String, String> zzbs(String string) {
        String[] stringArray;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : stringArray = string.split("&")) {
            String[] stringArray2 = string2.split("=", 3);
            if (stringArray2.length > 1) {
                hashMap.put(stringArray2[0], TextUtils.isEmpty((CharSequence)stringArray2[1]) ? null : stringArray2[1]);
                if (stringArray2.length != 3 || TextUtils.isEmpty((CharSequence)stringArray2[1]) || hashMap.containsKey(stringArray2[1])) continue;
                hashMap.put(stringArray2[1], TextUtils.isEmpty((CharSequence)stringArray2[2]) ? null : stringArray2[2]);
                continue;
            }
            if (stringArray2.length != 1 || stringArray2[0].length() == 0) continue;
            hashMap.put(stringArray2[0], null);
        }
        return hashMap;
    }

    public static double zza(String string, double d) {
        if (string == null) {
            return d;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public static long zzbt(String string) {
        if (string == null) {
            return 0L;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public static boolean zzh(String string, boolean bl) {
        if (string != null) {
            if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("1")) {
                return true;
            }
            if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no") || string.equalsIgnoreCase("0")) {
                return false;
            }
        }
        return bl;
    }

    public static String zzK(boolean bl) {
        return bl ? "1" : "0";
    }

    public static String zzbu(String string) {
        Object object;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        String string2 = string;
        if (string.contains("?") && ((String[])(object = string.split("[\\?]"))).length > 1) {
            string2 = object[1];
        }
        if (string2.contains("%3D")) {
            try {
                string2 = URLDecoder.decode(string2, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return null;
            }
        } else if (!string2.contains("=")) {
            return null;
        }
        object = zzam.zzbs(string2);
        String[] stringArray = new String[]{"dclid", "utm_source", "gclid", "aclid", "utm_campaign", "utm_medium", "utm_term", "utm_content", "utm_id", "anid", "gmob_t"};
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (TextUtils.isEmpty((CharSequence)((CharSequence)object.get(stringArray[i])))) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(stringArray[i]).append("=").append((String)object.get(stringArray[i]));
        }
        return stringBuilder.toString();
    }

    public static zzpr zza(zzaf zzaf2, String string) {
        zzx.zzz((Object)zzaf2);
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        Map map = new HashMap();
        try {
            map = zzmz.zza((URI)new URI("?" + string), (String)"UTF-8");
        }
        catch (URISyntaxException uRISyntaxException) {
            zzaf2.zzd("No valid campaign data found", uRISyntaxException);
            return null;
        }
        zzpr zzpr2 = new zzpr();
        zzpr2.zzey((String)map.get("utm_content"));
        zzpr2.zzew((String)map.get("utm_medium"));
        zzpr2.setName((String)map.get("utm_campaign"));
        zzpr2.zzev((String)map.get("utm_source"));
        zzpr2.zzex((String)map.get("utm_term"));
        zzpr2.zzez((String)map.get("utm_id"));
        zzpr2.zzeA((String)map.get("anid"));
        zzpr2.zzeB((String)map.get("gclid"));
        zzpr2.zzeC((String)map.get("dclid"));
        zzpr2.zzeD((String)map.get("aclid"));
        return zzpr2;
    }

    public static String zza(Locale locale) {
        if (locale == null) {
            return null;
        }
        String string = locale.getLanguage();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string.toLowerCase());
        if (!TextUtils.isEmpty((CharSequence)locale.getCountry())) {
            stringBuilder.append("-").append(locale.getCountry().toLowerCase());
        }
        return stringBuilder.toString();
    }

    public static void zzc(Map<String, String> map, String string, String string2) {
        if (string2 != null && !map.containsKey(string)) {
            map.put(string, string2);
        }
    }

    public static void zzd(Map<String, String> map, String string, String string2) {
        if (string2 != null && TextUtils.isEmpty((CharSequence)map.get(string))) {
            map.put(string, string2);
        }
    }

    public static void zzb(Map<String, String> map, String string, boolean bl) {
        if (!map.containsKey(string)) {
            map.put(string, bl ? "1" : "0");
        }
    }

    public static void zza(Map<String, String> map, String string, Map<String, String> map2) {
        zzam.zzc(map, string, map2.get(string));
    }

    public static MessageDigest zzbv(String string) {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(string);
                if (messageDigest == null) continue;
                return messageDigest;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return null;
    }

    public static int zzbw(String string) {
        int n = 1;
        int n2 = 0;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            n = 0;
            for (int i = string.length() - 1; i >= 0; --i) {
                char c = string.charAt(i);
                n2 = (n = (n << 6 & 0xFFFFFFF) + c + (c << 14)) & 0xFE00000;
                n = n2 != 0 ? n ^ n2 >> 21 : n;
            }
        }
        return n;
    }

    public static boolean zza(double d, String string) {
        if (d <= 0.0 || d >= 100.0) {
            return false;
        }
        return (double)(zzam.zzbw(string) % 10000) >= d * 100.0;
    }

    public static boolean zzbx(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return true;
        }
        return !string.startsWith("http:");
    }

    public static boolean zza(Context context, Class<? extends BroadcastReceiver> clazz, boolean bl) {
        try {
            ActivityInfo activityInfo = context.getPackageManager().getReceiverInfo(new ComponentName(context, clazz), 2);
            if (activityInfo != null && activityInfo.enabled && (!bl || activityInfo.exported)) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static boolean zza(Context context, Class<? extends Service> clazz) {
        try {
            ServiceInfo serviceInfo = context.getPackageManager().getServiceInfo(new ComponentName(context, clazz), 4);
            if (serviceInfo != null && serviceInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }
}

