/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzaj;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzh;
import com.google.android.gms.analytics.internal.zzx;
import com.google.android.gms.internal.zzmz;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class zzj
extends zzd
implements Closeable {
    private static final String zzQR = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL, '%s' TEXT NOT NULL, '%s' INTEGER);", "hits2", "hit_id", "hit_time", "hit_url", "hit_string", "hit_app_id");
    private static final String zzQS = String.format("SELECT MAX(%s) FROM %s WHERE 1;", "hit_time", "hits2");
    private final zza zzQT;
    private final zzaj zzQU = new zzaj(this.zzjl());
    private final zzaj zzQV = new zzaj(this.zzjl());

    zzj(zzf zzf2) {
        super(zzf2);
        String string = this.zzjQ();
        this.zzQT = new zza(zzf2.getContext(), string);
    }

    @Override
    protected void zziJ() {
    }

    public void beginTransaction() {
        this.zzjv();
        this.getWritableDatabase().beginTransaction();
    }

    public void setTransactionSuccessful() {
        this.zzjv();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    public void endTransaction() {
        this.zzjv();
        this.getWritableDatabase().endTransaction();
    }

    public void zzjL() {
        this.zzjk();
        this.zzjv();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.delete("hits2", null, null);
    }

    public void zzjM() {
        this.zzjk();
        this.zzjv();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.delete("properties", null, null);
    }

    public void zzc(zzab zzab2) {
        com.google.android.gms.common.internal.zzx.zzz((Object)zzab2);
        this.zzjk();
        this.zzjv();
        String string = zzj.zze(zzab2);
        if (string.length() > 8192) {
            this.zzjm().zza(zzab2, "Hit length exceeds the maximum allowed size");
            return;
        }
        this.zzjP();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_string", string);
        contentValues.put("hit_time", Long.valueOf(zzab2.zzlr()));
        contentValues.put("hit_app_id", Integer.valueOf(zzab2.zzlp()));
        contentValues.put("hit_url", this.zzd(zzab2));
        try {
            long l = sQLiteDatabase.insert("hits2", null, contentValues);
            if (l == -1L) {
                this.zzbh("Failed to insert a hit (got -1)");
            } else {
                this.zzb("Hit saved to database. db-id, hit", l, zzab2);
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Error storing a hit", (Object)sQLiteException);
        }
    }

    public long zzjG() {
        this.zzjk();
        this.zzjv();
        long l = this.zzb("SELECT COUNT(*) FROM hits2", null);
        return l;
    }

    boolean isEmpty() {
        return this.zzjG() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> zzo(long l) {
        this.zzjk();
        this.zzjv();
        if (l <= 0L) {
            return Collections.emptyList();
        }
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Long.toString(l));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(cursor.getLong(0));
                } while (cursor.moveToNext());
            }
        }
        return arrayList;
    }

    public List<zzab> zzp(long l) {
        com.google.android.gms.common.internal.zzx.zzac((l >= 0L ? 1 : 0) != 0);
        this.zzjk();
        this.zzjv();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id", "hit_time", "hit_string", "hit_url", "hit_app_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Long.toString(l));
            ArrayList<zzab> arrayList = new ArrayList<zzab>();
            if (cursor.moveToFirst()) {
                do {
                    long l2 = cursor.getLong(0);
                    long l3 = cursor.getLong(1);
                    String string = cursor.getString(2);
                    String string2 = cursor.getString(3);
                    int n = cursor.getInt(4);
                    Map<String, String> map = this.zzbi(string);
                    boolean bl = zzam.zzbx(string2);
                    arrayList.add(new zzab(this, map, l3, bl, l2, n));
                } while (cursor.moveToNext());
            }
            ArrayList<zzab> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    public void zzo(List<Long> list) {
        Long l;
        com.google.android.gms.common.internal.zzx.zzz(list);
        this.zzjk();
        this.zzjv();
        if (list.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("hit_id");
        stringBuilder.append(" in (");
        for (int i = 0; i < list.size(); ++i) {
            l = list.get(i);
            if (l == null || l == 0L) {
                throw new SQLiteException("Invalid hit id");
            }
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(l);
        }
        stringBuilder.append(")");
        String string = stringBuilder.toString();
        try {
            l = this.getWritableDatabase();
            this.zza("Deleting dispatched hits. count", list.size());
            int n = l.delete("hits2", string, null);
            if (n != list.size()) {
                this.zzb("Deleted fewer hits then expected", list.size(), n, string);
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Error deleting hits", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    public void zzq(long l) {
        this.zzjk();
        this.zzjv();
        ArrayList<Long> arrayList = new ArrayList<Long>(1);
        arrayList.add(l);
        this.zza("Deleting hit, id", l);
        this.zzo(arrayList);
    }

    public int zzjN() {
        this.zzjk();
        this.zzjv();
        if (!this.zzQU.zzv(86400000L)) {
            return 0;
        }
        this.zzQU.start();
        this.zzbd("Deleting stale hits (if any)");
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        long l = this.zzjl().currentTimeMillis() - 2592000000L;
        int n = sQLiteDatabase.delete("hits2", "hit_time < ?", new String[]{Long.toString(l)});
        this.zza("Deleted stale hits, count", n);
        return n;
    }

    public long zzjO() {
        this.zzjk();
        this.zzjv();
        return this.zza(zzQS, null, 0L);
    }

    public void zza(long l, String string) {
        com.google.android.gms.common.internal.zzx.zzcM((String)string);
        this.zzjv();
        this.zzjk();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        int n = sQLiteDatabase.delete("properties", "app_uid=? AND cid<>?", new String[]{String.valueOf(l), string});
        if (n > 0) {
            this.zza("Deleted property records", n);
        }
    }

    public void zzb(zzh zzh2) {
        com.google.android.gms.common.internal.zzx.zzz((Object)zzh2);
        this.zzjv();
        this.zzjk();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        String string = zzj.zzI(zzh2.zzn());
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_uid", Long.valueOf(zzh2.zzjD()));
        contentValues.put("cid", zzh2.getClientId());
        contentValues.put("tid", zzh2.zzjE());
        contentValues.put("adid", Integer.valueOf(zzh2.zzjF() ? 1 : 0));
        contentValues.put("hits_count", Long.valueOf(zzh2.zzjG()));
        contentValues.put("params", string);
        try {
            long l = sQLiteDatabase.insertWithOnConflict("properties", null, contentValues, 5);
            if (l == -1L) {
                this.zzbh("Failed to insert/update a property (got -1)");
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Error storing a property", (Object)sQLiteException);
        }
    }

    public long zza(long l, String string, String string2) {
        com.google.android.gms.common.internal.zzx.zzcM((String)string);
        com.google.android.gms.common.internal.zzx.zzcM((String)string2);
        this.zzjv();
        this.zzjk();
        long l2 = this.zza("SELECT hits_count FROM properties WHERE app_uid=? AND cid=? AND tid=?", new String[]{String.valueOf(l), string, string2}, 0L);
        return l2;
    }

    public List<zzh> zzr(long l) {
        this.zzjv();
        this.zzjk();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            Object object;
            String[] stringArray = new String[]{"cid", "tid", "adid", "hits_count", "params"};
            int n = this.zzjn().zzkQ();
            String string = String.valueOf(n);
            String string2 = "app_uid=?";
            String[] stringArray2 = new String[]{String.valueOf(l)};
            cursor = sQLiteDatabase.query("properties", stringArray, string2, stringArray2, null, null, null, string);
            ArrayList<zzh> arrayList = new ArrayList<zzh>();
            if (cursor.moveToFirst()) {
                do {
                    object = cursor.getString(0);
                    String string3 = cursor.getString(1);
                    boolean bl = cursor.getInt(2) != 0;
                    long l2 = cursor.getInt(3);
                    String string4 = cursor.getString(4);
                    Map<String, String> map = this.zzbj(string4);
                    if (TextUtils.isEmpty((CharSequence)object) || TextUtils.isEmpty((CharSequence)string3)) {
                        this.zzc("Read property with empty client id or tracker id", object, string3);
                        continue;
                    }
                    zzh zzh2 = new zzh(l, (String)object, string3, bl, l2, map);
                    arrayList.add(zzh2);
                } while (cursor.moveToNext());
            }
            if (arrayList.size() >= n) {
                this.zzbg("Sending hits to too many properties. Campaign report might be incorrect");
            }
            object = arrayList;
            return object;
        }
    }

    @Override
    public void close() {
        try {
            this.zzQT.close();
        }
        catch (SQLiteException sQLiteException) {
            this.zze("Sql error closing database", (Object)sQLiteException);
        }
        catch (IllegalStateException illegalStateException) {
            this.zze("Error closing database", illegalStateException);
        }
    }

    private String zzd(zzab zzab2) {
        if (zzab2.zzlt()) {
            return this.zzjn().zzkF();
        }
        return this.zzjn().zzkG();
    }

    private long zzb(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzd("Database error", string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    private long zza(String string, String[] stringArray, long l) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l2 = cursor.getLong(0);
                return l2;
            }
            long l3 = l;
            return l3;
        }
    }

    private void zzjP() {
        int n = this.zzjn().zzkP();
        long l = this.zzjG();
        if (l > (long)(n - 1)) {
            long l2 = l - (long)n + 1L;
            List<Long> list = this.zzo(l2);
            this.zzd("Store full, deleting hits to make room, count", list.size());
            this.zzo(list);
        }
    }

    private static String zze(zzab zzab2) {
        com.google.android.gms.common.internal.zzx.zzz((Object)zzab2);
        Uri.Builder builder = new Uri.Builder();
        for (Map.Entry<String, String> object2 : zzab2.zzn().entrySet()) {
            String string = object2.getKey();
            if ("ht".equals(string) || "qt".equals(string) || "AppUID".equals(string)) continue;
            builder.appendQueryParameter(string, object2.getValue());
        }
        Uri uri = builder.build();
        String string = uri.getEncodedQuery();
        if (string == null) {
            return "";
        }
        return string;
    }

    private static String zzI(Map<String, String> map) {
        com.google.android.gms.common.internal.zzx.zzz(map);
        Uri.Builder builder = new Uri.Builder();
        for (Map.Entry<String, String> object2 : map.entrySet()) {
            String string = object2.getKey();
            builder.appendQueryParameter(string, object2.getValue());
        }
        Uri uri = builder.build();
        String string = uri.getEncodedQuery();
        if (string == null) {
            return "";
        }
        return string;
    }

    Map<String, String> zzbi(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return new HashMap<String, String>(0);
        }
        try {
            String string2 = string.startsWith("?") ? string : "?" + string;
            return zzmz.zza((URI)new URI(string2), (String)"UTF-8");
        }
        catch (URISyntaxException uRISyntaxException) {
            this.zze("Error parsing hit parameters", uRISyntaxException);
            return new HashMap<String, String>(0);
        }
    }

    Map<String, String> zzbj(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return new HashMap<String, String>(0);
        }
        try {
            String string2 = "?" + string;
            return zzmz.zza((URI)new URI(string2), (String)"UTF-8");
        }
        catch (URISyntaxException uRISyntaxException) {
            this.zze("Error parsing property parameters", uRISyntaxException);
            return new HashMap<String, String>(0);
        }
    }

    SQLiteDatabase getWritableDatabase() {
        try {
            return this.zzQT.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzd("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    private String zzjQ() {
        if (!this.zzjn().zzkr()) {
            return this.zzjn().zzkR();
        }
        if (this.zzjn().zzks()) {
            return this.zzjn().zzkR();
        }
        return this.zzjn().zzkS();
    }

    class zza
    extends SQLiteOpenHelper {
        zza(Context context, String string) {
            super(context, string, null, 1);
        }

        public SQLiteDatabase getWritableDatabase() {
            if (!zzj.this.zzQV.zzv(3600000L)) {
                throw new SQLiteException("Database open failed");
            }
            try {
                SQLiteDatabase sQLiteDatabase = super.getWritableDatabase();
                return sQLiteDatabase;
            }
            catch (SQLiteException sQLiteException) {
                zzj.this.zzQV.start();
                zzj.this.zzbh("Opening the database failed, dropping the table and recreating it");
                String string = zzj.this.zzjQ();
                zzj.this.getContext().getDatabasePath(string).delete();
                try {
                    SQLiteDatabase sQLiteDatabase = super.getWritableDatabase();
                    zzj.this.zzQV.clear();
                    return sQLiteDatabase;
                }
                catch (SQLiteException sQLiteException2) {
                    zzj.this.zze("Failed to open freshly created database", (Object)sQLiteException2);
                    throw sQLiteException2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(SQLiteDatabase sQLiteDatabase, String string) {
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string}, null, null, null);
                boolean bl = cursor.moveToFirst();
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<String> zzb(SQLiteDatabase sQLiteDatabase, String string) {
            HashSet<String> hashSet = new HashSet<String>();
            String string2 = "SELECT * FROM " + string + " LIMIT 0";
            try (Cursor cursor = sQLiteDatabase.rawQuery(string2, null);){
                String[] stringArray = cursor.getColumnNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    hashSet.add(stringArray[i]);
                }
            }
            return hashSet;
        }

        private void zza(SQLiteDatabase sQLiteDatabase) {
            boolean bl;
            String[] stringArray;
            Set<String> set = this.zzb(sQLiteDatabase, "hits2");
            for (String string : stringArray = new String[]{"hit_id", "hit_string", "hit_time", "hit_url"}) {
                if (set.remove(string)) continue;
                throw new SQLiteException("Database hits2 is missing required column: " + string);
            }
            boolean bl2 = bl = !set.remove("hit_app_id");
            if (!set.isEmpty()) {
                throw new SQLiteException("Database hits2 has extra columns");
            }
            if (bl) {
                String string = "ALTER TABLE hits2 ADD COLUMN hit_app_id INTEGER";
                sQLiteDatabase.execSQL(string);
            }
        }

        private void zzb(SQLiteDatabase sQLiteDatabase) {
            String[] stringArray;
            Set<String> set = this.zzb(sQLiteDatabase, "properties");
            for (String string : stringArray = new String[]{"app_uid", "cid", "tid", "params", "adid", "hits_count"}) {
                if (set.remove(string)) continue;
                throw new SQLiteException("Database properties is missing required column: " + string);
            }
            if (!set.isEmpty()) {
                throw new SQLiteException("Database properties table has extra columns");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpen(SQLiteDatabase database) {
            if (Build.VERSION.SDK_INT < 15) {
                try (Cursor cursor = database.rawQuery("PRAGMA journal_mode=memory", null);){
                    cursor.moveToFirst();
                }
            }
            if (!this.zza(database, "hits2")) {
                database.execSQL(zzQR);
            } else {
                this.zza(database);
            }
            if (!this.zza(database, "properties")) {
                database.execSQL("CREATE TABLE IF NOT EXISTS properties ( app_uid INTEGER NOT NULL, cid TEXT NOT NULL, tid TEXT NOT NULL, params TEXT NOT NULL, adid INTEGER NOT NULL, hits_count INTEGER NOT NULL, PRIMARY KEY (app_uid, cid, tid)) ;");
            } else {
                this.zzb(database);
            }
        }

        public void onCreate(SQLiteDatabase database) {
            zzx.zzbo(database.getPath());
        }

        public void onUpgrade(SQLiteDatabase database, int oldVersion, int newVersion) {
        }
    }
}

