/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Process;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzpq;
import com.google.android.gms.internal.zzps;
import com.google.android.gms.measurement.zzf;
import com.google.android.gms.measurement.zzh;
import com.google.android.gms.measurement.zzi;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzg {
    private static volatile zzg zzaUv;
    private final Context mContext;
    private final List<zzh> zzaUw;
    private final com.google.android.gms.measurement.zzb zzaUx;
    private final zza zzaUy;
    private volatile zzpq zzQX;
    private Thread.UncaughtExceptionHandler zzaUz;

    zzg(Context context) {
        Context context2 = context.getApplicationContext();
        zzx.zzz((Object)context2);
        this.mContext = context2;
        this.zzaUy = new zza();
        this.zzaUw = new CopyOnWriteArrayList<zzh>();
        this.zzaUx = new com.google.android.gms.measurement.zzb();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzg zzaS(Context context) {
        zzx.zzz((Object)context);
        if (zzaUv != null) return zzaUv;
        Class<zzg> clazz = zzg.class;
        synchronized (zzg.class) {
            if (zzaUv != null) return zzaUv;
            zzaUv = new zzg(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzaUv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzpq zzAH() {
        if (this.zzQX == null) {
            zzg zzg2 = this;
            synchronized (zzg2) {
                if (this.zzQX == null) {
                    zzpq zzpq2 = new zzpq();
                    PackageManager packageManager = this.mContext.getPackageManager();
                    String string = this.mContext.getPackageName();
                    zzpq2.setAppId(string);
                    zzpq2.setAppInstallerId(packageManager.getInstallerPackageName(string));
                    String string2 = string;
                    String string3 = null;
                    try {
                        PackageInfo packageInfo = packageManager.getPackageInfo(this.mContext.getPackageName(), 0);
                        if (packageInfo != null) {
                            CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                                string2 = charSequence.toString();
                            }
                            string3 = packageInfo.versionName;
                        }
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        Log.e((String)"GAv4", (String)("Error retrieving package info: appName set to " + string2));
                    }
                    zzpq2.setAppName(string2);
                    zzpq2.setAppVersion(string3);
                    this.zzQX = zzpq2;
                }
            }
        }
        return this.zzQX;
    }

    public zzps zzAI() {
        DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
        zzps zzps2 = new zzps();
        zzps2.setLanguage(zzam.zza(Locale.getDefault()));
        zzps2.zziB(displayMetrics.widthPixels);
        zzps2.zziC(displayMetrics.heightPixels);
        return zzps2;
    }

    void zze(com.google.android.gms.measurement.zzc zzc2) {
        if (zzc2.zzAD()) {
            throw new IllegalStateException("Measurement prototype can't be submitted");
        }
        if (zzc2.zzAz()) {
            throw new IllegalStateException("Measurement can only be submitted once");
        }
        final com.google.android.gms.measurement.zzc zzc3 = zzc2.zzAu();
        zzc3.zzAA();
        this.zzaUy.execute(new Runnable(){

            @Override
            public void run() {
                zzf zzf2 = zzc3.zzAB();
                zzf2.zza(zzc3);
                for (zzh zzh2 : zzg.this.zzaUw) {
                    zzh2.zza(zzc3);
                }
                zzg.this.zzb(zzc3);
            }
        });
    }

    public Context getContext() {
        return this.mContext;
    }

    public static void zzjk() {
        if (!(Thread.currentThread() instanceof zzc)) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    public void zza(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.zzaUz = uncaughtExceptionHandler;
    }

    public <V> Future<V> zzc(Callable<V> callable) {
        zzx.zzz(callable);
        if (Thread.currentThread() instanceof zzc) {
            FutureTask<V> futureTask = new FutureTask<V>(callable);
            futureTask.run();
            return futureTask;
        }
        return this.zzaUy.submit(callable);
    }

    public void zzf(Runnable runnable) {
        zzx.zzz((Object)runnable);
        this.zzaUy.submit(runnable);
    }

    private void zzb(com.google.android.gms.measurement.zzc zzc2) {
        zzx.zzcE((String)"deliver should be called from worker thread");
        zzx.zzb((boolean)zzc2.zzAz(), (Object)"Measurement must be submitted");
        List<zzi> list = zzc2.zzAw();
        if (list.isEmpty()) {
            return;
        }
        HashSet<Uri> hashSet = new HashSet<Uri>();
        for (zzi zzi2 : list) {
            Uri uri = zzi2.zziA();
            if (hashSet.contains(uri)) continue;
            hashSet.add(uri);
            zzi2.zzb(zzc2);
        }
    }

    private static class zzb
    implements ThreadFactory {
        private static final AtomicInteger zzaUD = new AtomicInteger();

        private zzb() {
        }

        @Override
        public Thread newThread(Runnable target) {
            String string = "measurement-" + zzaUD.incrementAndGet();
            return new zzc(target, string);
        }
    }

    private static class zzc
    extends Thread {
        zzc(Runnable runnable, String string) {
            super(runnable, string);
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            super.run();
        }
    }

    private class zza
    extends ThreadPoolExecutor {
        public zza() {
            super(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            this.setThreadFactory(new zzb());
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
            return new FutureTask<T>(runnable, value){

                @Override
                protected void setException(Throwable error) {
                    Thread.UncaughtExceptionHandler uncaughtExceptionHandler = zzg.this.zzaUz;
                    if (uncaughtExceptionHandler != null) {
                        uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), error);
                    } else if (Log.isLoggable((String)"GAv4", (int)6)) {
                        Log.e((String)"GAv4", (String)("MeasurementExecutor: job failed with " + error));
                    }
                    super.setException(error);
                }
            };
        }
    }
}

