/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appdatasearch;

import android.content.ComponentName;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.appdatasearch.DocumentContents;
import com.google.android.gms.appdatasearch.DocumentId;
import com.google.android.gms.appdatasearch.DocumentSection;
import com.google.android.gms.appdatasearch.RegisterSectionInfo;
import com.google.android.gms.appdatasearch.zzj;
import com.google.android.gms.appindexing.AppIndexApi;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzny;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.zip.CRC32;

public class UsageInfo
implements SafeParcelable {
    public static final zzj CREATOR = new zzj();
    final int zzzH;
    final DocumentId zzJL;
    final long zzJM;
    int zzJN;
    public final String zzqX;
    final DocumentContents zzJO;
    final boolean zzJP;
    int zzJQ;
    int zzJR;

    private UsageInfo(DocumentId documentId, long timestampMs, int usageType, String query, DocumentContents document, boolean isDeviceOnly, int taskPosition, int eventStatus) {
        this(1, documentId, timestampMs, usageType, query, document, isDeviceOnly, taskPosition, eventStatus);
    }

    public UsageInfo(String packageName, Intent viewIntent, String title, Uri webUrl, String schemaOrgType, List<AppIndexApi.AppIndexingLink> outLinks, int eventStatus) {
        this(1, UsageInfo.zza(packageName, viewIntent), System.currentTimeMillis(), 0, null, UsageInfo.zza(viewIntent, title, webUrl, schemaOrgType, outLinks).zzjD(), false, -1, eventStatus);
    }

    UsageInfo(int versionCode, DocumentId documentId, long timestamp, int usageType, String query, DocumentContents document, boolean isDeviceOnly, int taskPosition, int eventStatus) {
        this.zzzH = versionCode;
        this.zzJL = documentId;
        this.zzJM = timestamp;
        this.zzJN = usageType;
        this.zzqX = query;
        this.zzJO = document;
        this.zzJP = isDeviceOnly;
        this.zzJQ = taskPosition;
        this.zzJR = eventStatus;
    }

    public static DocumentId zza(String string, Intent intent) {
        return UsageInfo.zzn(string, UsageInfo.zzg(intent));
    }

    private static DocumentId zzn(String string, String string2) {
        return new DocumentId(string, "", string2);
    }

    private static DocumentSection zzbf(String string) {
        return new DocumentSection(string, new RegisterSectionInfo.zza("title").zzaa(1).zzK(true).zzbe("name").zzjG(), "text1");
    }

    private static DocumentSection zzh(Uri uri) {
        return new DocumentSection(uri.toString(), new RegisterSectionInfo.zza("web_url").zzaa(4).zzJ(true).zzbe("url").zzjG());
    }

    private static DocumentSection zzo(String string, String string2) {
        return new DocumentSection(string2, new RegisterSectionInfo.zza(string).zzJ(true).zzjG(), string);
    }

    private static String zzg(Intent intent) {
        String string = intent.toUri(1);
        CRC32 cRC32 = new CRC32();
        try {
            cRC32.update(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
        return Long.toHexString(cRC32.getValue());
    }

    private static DocumentSection zzi(List<AppIndexApi.AppIndexingLink> list) {
        zzkb.zza zza2 = new zzkb.zza();
        zzkb.zza.zza[] zzaArray = new zzkb.zza.zza[list.size()];
        for (int i = 0; i < zzaArray.length; ++i) {
            zzaArray[i] = new zzkb.zza.zza();
            AppIndexApi.AppIndexingLink appIndexingLink = list.get(i);
            zzaArray[i].zzapa = appIndexingLink.appIndexingUrl.toString();
            zzaArray[i].viewId = appIndexingLink.viewId;
            if (appIndexingLink.webUrl == null) continue;
            zzaArray[i].zzapb = appIndexingLink.webUrl.toString();
        }
        zza2.zzaoY = zzaArray;
        return new DocumentSection(zzny.zzf((zzny)zza2), new RegisterSectionInfo.zza("outlinks").zzJ(true).zzbe(".private:outLinks").zzbd("blob").zzjG());
    }

    public static DocumentContents.zza zza(Intent intent, String string, Uri uri, String string2, List<AppIndexApi.AppIndexingLink> list) {
        String string3;
        Bundle bundle;
        ComponentName componentName;
        String string4;
        String string5;
        DocumentContents.zza zza2 = new DocumentContents.zza();
        zza2.zza(UsageInfo.zzbf(string));
        if (uri != null) {
            zza2.zza(UsageInfo.zzh(uri));
        }
        if (list != null) {
            zza2.zza(UsageInfo.zzi(list));
        }
        if ((string5 = intent.getAction()) != null) {
            zza2.zza(UsageInfo.zzo("intent_action", string5));
        }
        if ((string4 = intent.getDataString()) != null) {
            zza2.zza(UsageInfo.zzo("intent_data", string4));
        }
        if ((componentName = intent.getComponent()) != null) {
            zza2.zza(UsageInfo.zzo("intent_activity", componentName.getClassName()));
        }
        if ((bundle = intent.getExtras()) != null && (string3 = bundle.getString("intent_extra_data_key")) != null) {
            zza2.zza(UsageInfo.zzo("intent_extra_data", string3));
        }
        return zza2.zzbb(string2).zzI(true);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzj.zza(this, dest, flags);
    }

    public String toString() {
        return String.format("UsageInfo[documentId=%s, timestamp=%d, usageType=%d, status=%d]", this.zzJL, this.zzJM, this.zzJN, this.zzJR);
    }

    public static final class zza {
        private DocumentId zzJL;
        private long zzJM = -1L;
        private int zzJN = -1;
        private String zzEa;
        private DocumentContents zzJO;
        private boolean zzJP = false;
        private int zzJQ = -1;
        private int zzJR = 0;

        public zza zza(DocumentId documentId) {
            this.zzJL = documentId;
            return this;
        }

        public zza zzu(long l) {
            this.zzJM = l;
            return this;
        }

        public zza zzac(int n) {
            this.zzJN = n;
            return this;
        }

        public zza zza(DocumentContents documentContents) {
            this.zzJO = documentContents;
            return this;
        }

        public zza zzL(boolean bl) {
            this.zzJP = bl;
            return this;
        }

        public zza zzad(int n) {
            this.zzJR = n;
            return this;
        }

        public UsageInfo zzjH() {
            return new UsageInfo(this.zzJL, this.zzJM, this.zzJN, this.zzEa, this.zzJO, this.zzJP, this.zzJQ, this.zzJR);
        }
    }
}

