/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appdatasearch;

import android.content.ComponentName;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.appdatasearch.DocumentContents;
import com.google.android.gms.appdatasearch.DocumentId;
import com.google.android.gms.appdatasearch.DocumentSection;
import com.google.android.gms.appdatasearch.RegisterSectionInfo;
import com.google.android.gms.appdatasearch.zzj;
import com.google.android.gms.appindexing.AppIndexApi;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.zzqd;
import com.google.android.gms.internal.zztk;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.zip.CRC32;

public class UsageInfo
implements SafeParcelable {
    public static final zzj CREATOR = new zzj();
    final int mVersionCode;
    final DocumentId zzSY;
    final long zzSZ;
    int zzTa;
    public final String zzuU;
    final DocumentContents zzTb;
    final boolean zzTc;
    int zzTd;
    int zzTe;

    private UsageInfo(DocumentId documentId, long timestampMs, int usageType, String query, DocumentContents document, boolean isDeviceOnly, int taskPosition, int eventStatus) {
        this(1, documentId, timestampMs, usageType, query, document, isDeviceOnly, taskPosition, eventStatus);
    }

    public UsageInfo(String packageName, Intent viewIntent, String title, Uri webUrl, String schemaOrgType, List<AppIndexApi.AppIndexingLink> outLinks, int eventStatus) {
        this(1, UsageInfo.zza(packageName, viewIntent), System.currentTimeMillis(), 0, null, UsageInfo.zza(viewIntent, title, webUrl, schemaOrgType, outLinks).zzlN(), false, -1, eventStatus);
    }

    UsageInfo(int versionCode, DocumentId documentId, long timestamp, int usageType, String query, DocumentContents document, boolean isDeviceOnly, int taskPosition, int eventStatus) {
        this.mVersionCode = versionCode;
        this.zzSY = documentId;
        this.zzSZ = timestamp;
        this.zzTa = usageType;
        this.zzuU = query;
        this.zzTb = document;
        this.zzTc = isDeviceOnly;
        this.zzTd = taskPosition;
        this.zzTe = eventStatus;
    }

    public static DocumentId zza(String string, Intent intent) {
        return UsageInfo.zzo(string, UsageInfo.zzg(intent));
    }

    private static DocumentId zzo(String string, String string2) {
        return new DocumentId(string, "", string2);
    }

    private static DocumentSection zzbA(String string) {
        return new DocumentSection(string, new RegisterSectionInfo.zza("title").zzap(1).zzN(true).zzbz("name").zzlQ(), "text1");
    }

    private static DocumentSection zzi(Uri uri) {
        return new DocumentSection(uri.toString(), new RegisterSectionInfo.zza("web_url").zzap(4).zzM(true).zzbz("url").zzlQ());
    }

    private static DocumentSection zzp(String string, String string2) {
        return new DocumentSection(string2, new RegisterSectionInfo.zza(string).zzM(true).zzlQ(), string);
    }

    private static String zzg(Intent intent) {
        String string = intent.toUri(1);
        CRC32 cRC32 = new CRC32();
        try {
            cRC32.update(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
        return Long.toHexString(cRC32.getValue());
    }

    private static DocumentSection zzq(List<AppIndexApi.AppIndexingLink> list) {
        zzqd.zza zza2 = new zzqd.zza();
        zzqd.zza.zza[] zzaArray = new zzqd.zza.zza[list.size()];
        for (int i = 0; i < zzaArray.length; ++i) {
            zzaArray[i] = new zzqd.zza.zza();
            AppIndexApi.AppIndexingLink appIndexingLink = list.get(i);
            zzaArray[i].zzaJC = appIndexingLink.appIndexingUrl.toString();
            zzaArray[i].viewId = appIndexingLink.viewId;
            if (appIndexingLink.webUrl == null) continue;
            zzaArray[i].zzaJD = appIndexingLink.webUrl.toString();
        }
        zza2.zzaJA = zzaArray;
        return new DocumentSection(zztk.toByteArray((zztk)zza2), new RegisterSectionInfo.zza("outlinks").zzM(true).zzbz(".private:outLinks").zzby("blob").zzlQ());
    }

    public static DocumentContents.zza zza(Intent intent, String string, Uri uri, String string2, List<AppIndexApi.AppIndexingLink> list) {
        String string3;
        Bundle bundle;
        ComponentName componentName;
        String string4;
        String string5;
        DocumentContents.zza zza2 = new DocumentContents.zza();
        zza2.zza(UsageInfo.zzbA(string));
        if (uri != null) {
            zza2.zza(UsageInfo.zzi(uri));
        }
        if (list != null) {
            zza2.zza(UsageInfo.zzq(list));
        }
        if ((string5 = intent.getAction()) != null) {
            zza2.zza(UsageInfo.zzp("intent_action", string5));
        }
        if ((string4 = intent.getDataString()) != null) {
            zza2.zza(UsageInfo.zzp("intent_data", string4));
        }
        if ((componentName = intent.getComponent()) != null) {
            zza2.zza(UsageInfo.zzp("intent_activity", componentName.getClassName()));
        }
        if ((bundle = intent.getExtras()) != null && (string3 = bundle.getString("intent_extra_data_key")) != null) {
            zza2.zza(UsageInfo.zzp("intent_extra_data", string3));
        }
        return zza2.zzbw(string2).zzL(true);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzj.zza(this, dest, flags);
    }

    public String toString() {
        return String.format("UsageInfo[documentId=%s, timestamp=%d, usageType=%d, status=%d]", this.zzSY, this.zzSZ, this.zzTa, this.zzTe);
    }

    public static final class zza {
        private DocumentId zzSY;
        private long zzSZ = -1L;
        private int zzTa = -1;
        private String zzNp;
        private DocumentContents zzTb;
        private boolean zzTc = false;
        private int zzTd = -1;
        private int zzTe = 0;

        public zza zza(DocumentId documentId) {
            this.zzSY = documentId;
            return this;
        }

        public zza zzw(long l) {
            this.zzSZ = l;
            return this;
        }

        public zza zzar(int n) {
            this.zzTa = n;
            return this;
        }

        public zza zza(DocumentContents documentContents) {
            this.zzTb = documentContents;
            return this;
        }

        public zza zzO(boolean bl) {
            this.zzTc = bl;
            return this;
        }

        public zza zzas(int n) {
            this.zzTe = n;
            return this;
        }

        public UsageInfo zzlR() {
            return new UsageInfo(this.zzSY, this.zzSZ, this.zzTa, this.zzNp, this.zzTb, this.zzTc, this.zzTd, this.zzTe);
        }
    }
}

