/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appindexing;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzx;
import java.util.ArrayList;

public class Thing {
    final Bundle zzUG;

    Thing(Bundle propertyBundle) {
        this.zzUG = propertyBundle;
    }

    public Bundle zzmk() {
        return this.zzUG;
    }

    public static class Builder {
        final Bundle zzUH = new Bundle();

        public Builder setName(String name) {
            zzx.zzz((Object)name);
            this.put("name", name);
            return this;
        }

        public Builder setUrl(Uri url) {
            zzx.zzz((Object)url);
            this.put("url", url.toString());
            return this;
        }

        public Builder setId(String id) {
            if (id != null) {
                this.put("id", id);
            }
            return this;
        }

        public Builder setType(String type) {
            this.put("type", type);
            return this;
        }

        public Builder setDescription(String description) {
            this.put("description", description);
            return this;
        }

        public Builder put(String key, String value) {
            zzx.zzz((Object)key);
            if (value != null) {
                this.zzUH.putString(key, value);
            }
            return this;
        }

        public Builder put(String key, String[] values) {
            zzx.zzz((Object)key);
            if (values != null) {
                this.zzUH.putStringArray(key, values);
            }
            return this;
        }

        public Builder put(String key, Thing value) {
            zzx.zzz((Object)key);
            if (value != null) {
                this.zzUH.putParcelable(key, (Parcelable)value.zzUG);
            }
            return this;
        }

        public Builder put(String key, Thing[] values) {
            zzx.zzz((Object)key);
            if (values != null) {
                ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
                for (Thing thing : values) {
                    if (thing == null) continue;
                    arrayList.add(thing.zzUG);
                }
                this.zzUH.putParcelableArray(key, (Parcelable[])arrayList.toArray(new Bundle[arrayList.size()]));
            }
            return this;
        }

        public Builder put(String key, boolean value) {
            zzx.zzz((Object)key);
            this.zzUH.putBoolean(key, value);
            return this;
        }

        public Thing build() {
            return new Thing(this.zzUH);
        }
    }
}

