/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appdatasearch;

import android.content.ComponentName;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.appdatasearch.DocumentContents;
import com.google.android.gms.appdatasearch.DocumentId;
import com.google.android.gms.appdatasearch.DocumentSection;
import com.google.android.gms.appdatasearch.RegisterSectionInfo;
import com.google.android.gms.appdatasearch.zzj;
import com.google.android.gms.appindexing.AppIndexApi;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.internal.zzamj;
import com.google.android.gms.internal.zzsj;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.zip.CRC32;

public class UsageInfo
extends AbstractSafeParcelable {
    public static final zzj CREATOR = new zzj();
    final int mVersionCode;
    final DocumentId zzaak;
    final long zzaal;
    int zzaam;
    public final String zzwM;
    final DocumentContents zzaan;
    final boolean zzaao;
    int zzaap;
    int zzaaq;

    private UsageInfo(DocumentId documentId, long l, int n, String string, DocumentContents documentContents, boolean bl, int n2, int n3) {
        this(1, documentId, l, n, string, documentContents, bl, n2, n3);
    }

    public UsageInfo(String string, Intent intent, String string2, Uri uri, String string3, List<AppIndexApi.AppIndexingLink> list, int n) {
        this(1, UsageInfo.zza(string, intent), System.currentTimeMillis(), 0, null, UsageInfo.zza(intent, string2, uri, string3, list).zzoH(), false, -1, n);
    }

    UsageInfo(int n, DocumentId documentId, long l, int n2, String string, DocumentContents documentContents, boolean bl, int n3, int n4) {
        this.mVersionCode = n;
        this.zzaak = documentId;
        this.zzaal = l;
        this.zzaam = n2;
        this.zzwM = string;
        this.zzaan = documentContents;
        this.zzaao = bl;
        this.zzaap = n3;
        this.zzaaq = n4;
    }

    public static DocumentId zza(String string, Intent intent) {
        return UsageInfo.zzr(string, UsageInfo.zzg(intent));
    }

    private static DocumentId zzr(String string, String string2) {
        return new DocumentId(string, "", string2);
    }

    private static DocumentSection zzch(String string) {
        return new DocumentSection(string, new RegisterSectionInfo.zza("title").zzaD(1).zzV(true).zzcg("name").zzoK(), "text1");
    }

    private static DocumentSection zzj(Uri uri) {
        return new DocumentSection(uri.toString(), new RegisterSectionInfo.zza("web_url").zzaD(4).zzU(true).zzcg("url").zzoK());
    }

    private static DocumentSection zzs(String string, String string2) {
        return new DocumentSection(string2, new RegisterSectionInfo.zza(string).zzU(true).zzoK(), string);
    }

    private static String zzg(Intent intent) {
        String string = intent.toUri(1);
        CRC32 cRC32 = new CRC32();
        try {
            cRC32.update(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
        return Long.toHexString(cRC32.getValue());
    }

    private static DocumentSection zzu(List<AppIndexApi.AppIndexingLink> list) {
        zzsj.zza zza2 = new zzsj.zza();
        zzsj.zza.zza[] zzaArray = new zzsj.zza.zza[list.size()];
        for (int i = 0; i < zzaArray.length; ++i) {
            zzaArray[i] = new zzsj.zza.zza();
            AppIndexApi.AppIndexingLink appIndexingLink = list.get(i);
            zzaArray[i].zzaTA = appIndexingLink.appIndexingUrl.toString();
            zzaArray[i].viewId = appIndexingLink.viewId;
            if (appIndexingLink.webUrl == null) continue;
            zzaArray[i].zzaTB = appIndexingLink.webUrl.toString();
        }
        zza2.zzaTy = zzaArray;
        return new DocumentSection(zzamj.toByteArray((zzamj)zza2), new RegisterSectionInfo.zza("outlinks").zzU(true).zzcg(".private:outLinks").zzcf("blob").zzoK());
    }

    public static DocumentContents.zza zza(Intent intent, String string, Uri uri, String string2, List<AppIndexApi.AppIndexingLink> list) {
        String string3;
        Bundle bundle;
        ComponentName componentName;
        String string4;
        String string5;
        DocumentContents.zza zza2 = new DocumentContents.zza();
        zza2.zza(UsageInfo.zzch(string));
        if (uri != null) {
            zza2.zza(UsageInfo.zzj(uri));
        }
        if (list != null) {
            zza2.zza(UsageInfo.zzu(list));
        }
        if ((string5 = intent.getAction()) != null) {
            zza2.zza(UsageInfo.zzs("intent_action", string5));
        }
        if ((string4 = intent.getDataString()) != null) {
            zza2.zza(UsageInfo.zzs("intent_data", string4));
        }
        if ((componentName = intent.getComponent()) != null) {
            zza2.zza(UsageInfo.zzs("intent_activity", componentName.getClassName()));
        }
        if ((bundle = intent.getExtras()) != null && (string3 = bundle.getString("intent_extra_data_key")) != null) {
            zza2.zza(UsageInfo.zzs("intent_extra_data", string3));
        }
        return zza2.zzcd(string2).zzT(true);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzj.zza(this, parcel, n);
    }

    public String toString() {
        return String.format("UsageInfo[documentId=%s, timestamp=%d, usageType=%d, status=%d]", new Object[]{this.zzaak, this.zzaal, this.zzaam, this.zzaaq});
    }

    public static final class zza {
        private DocumentId zzaak;
        private long zzaal = -1L;
        private int zzaam = -1;
        private DocumentContents zzaan;
        private boolean zzaao = false;
        private int zzaap = -1;
        private int zzaaq = 0;

        public zza zza(DocumentId documentId) {
            this.zzaak = documentId;
            return this;
        }

        public zza zzy(long l) {
            this.zzaal = l;
            return this;
        }

        public zza zzaF(int n) {
            this.zzaam = n;
            return this;
        }

        public zza zza(DocumentContents documentContents) {
            this.zzaan = documentContents;
            return this;
        }

        public zza zzW(boolean bl) {
            this.zzaao = bl;
            return this;
        }

        public zza zzaG(int n) {
            this.zzaaq = n;
            return this;
        }

        public UsageInfo zzoL() {
            return new UsageInfo(this.zzaak, this.zzaal, this.zzaam, null, this.zzaan, this.zzaao, this.zzaap, this.zzaaq);
        }
    }
}

