/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appdatasearch;

import android.content.ComponentName;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.appdatasearch.DocumentContents;
import com.google.android.gms.appdatasearch.DocumentId;
import com.google.android.gms.appdatasearch.DocumentSection;
import com.google.android.gms.appdatasearch.RegisterSectionInfo;
import com.google.android.gms.appdatasearch.zzj;
import com.google.android.gms.appindexing.AppIndexApi;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.internal.zzapc;
import com.google.android.gms.internal.zzuj;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.zip.CRC32;

public class UsageInfo
extends AbstractSafeParcelable {
    public static final zzj CREATOR = new zzj();
    final int mVersionCode;
    final DocumentId by;
    final long bz;
    int bA;
    public final String zzaxj;
    final DocumentContents bB;
    final boolean bC;
    int bD;
    int bE;

    private UsageInfo(DocumentId documentId, long l, int n, String string, DocumentContents documentContents, boolean bl, int n2, int n3) {
        this(1, documentId, l, n, string, documentContents, bl, n2, n3);
    }

    public UsageInfo(String string, Intent intent, String string2, Uri uri, String string3, List<AppIndexApi.AppIndexingLink> list, int n) {
        this(1, UsageInfo.zza(string, intent), System.currentTimeMillis(), 0, null, UsageInfo.zza(intent, string2, uri, string3, list).zzaen(), false, -1, n);
    }

    UsageInfo(int n, DocumentId documentId, long l, int n2, String string, DocumentContents documentContents, boolean bl, int n3, int n4) {
        this.mVersionCode = n;
        this.by = documentId;
        this.bz = l;
        this.bA = n2;
        this.zzaxj = string;
        this.bB = documentContents;
        this.bC = bl;
        this.bD = n3;
        this.bE = n4;
    }

    public static DocumentId zza(String string, Intent intent) {
        return UsageInfo.zzt(string, UsageInfo.zzg(intent));
    }

    private static DocumentId zzt(String string, String string2) {
        return new DocumentId(string, "", string2);
    }

    private static DocumentSection zzfj(String string) {
        return new DocumentSection(string, new RegisterSectionInfo.zza("title").zzcf(1).zzaw(true).zzfi("name").zzaeq(), "text1");
    }

    private static DocumentSection zzj(Uri uri) {
        return new DocumentSection(uri.toString(), new RegisterSectionInfo.zza("web_url").zzcf(4).zzav(true).zzfi("url").zzaeq());
    }

    private static DocumentSection zzu(String string, String string2) {
        return new DocumentSection(string2, new RegisterSectionInfo.zza(string).zzav(true).zzaeq(), string);
    }

    private static String zzg(Intent intent) {
        String string = intent.toUri(1);
        CRC32 cRC32 = new CRC32();
        try {
            cRC32.update(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
        return Long.toHexString(cRC32.getValue());
    }

    private static DocumentSection zzu(List<AppIndexApi.AppIndexingLink> list) {
        zzuj.zza zza2 = new zzuj.zza();
        zzuj.zza.zza[] zzaArray = new zzuj.zza.zza[list.size()];
        for (int i = 0; i < zzaArray.length; ++i) {
            zzaArray[i] = new zzuj.zza.zza();
            AppIndexApi.AppIndexingLink appIndexingLink = list.get(i);
            zzaArray[i].abp = appIndexingLink.appIndexingUrl.toString();
            zzaArray[i].viewId = appIndexingLink.viewId;
            if (appIndexingLink.webUrl == null) continue;
            zzaArray[i].abq = appIndexingLink.webUrl.toString();
        }
        zza2.abn = zzaArray;
        return new DocumentSection(zzapc.zzf((zzapc)zza2), new RegisterSectionInfo.zza("outlinks").zzav(true).zzfi(".private:outLinks").zzfh("blob").zzaeq());
    }

    public static DocumentContents.zza zza(Intent intent, String string, Uri uri, String string2, List<AppIndexApi.AppIndexingLink> list) {
        String string3;
        Bundle bundle;
        ComponentName componentName;
        String string4;
        String string5;
        DocumentContents.zza zza2 = new DocumentContents.zza();
        zza2.zza(UsageInfo.zzfj(string));
        if (uri != null) {
            zza2.zza(UsageInfo.zzj(uri));
        }
        if (list != null) {
            zza2.zza(UsageInfo.zzu(list));
        }
        if ((string5 = intent.getAction()) != null) {
            zza2.zza(UsageInfo.zzu("intent_action", string5));
        }
        if ((string4 = intent.getDataString()) != null) {
            zza2.zza(UsageInfo.zzu("intent_data", string4));
        }
        if ((componentName = intent.getComponent()) != null) {
            zza2.zza(UsageInfo.zzu("intent_activity", componentName.getClassName()));
        }
        if ((bundle = intent.getExtras()) != null && (string3 = bundle.getString("intent_extra_data_key")) != null) {
            zza2.zza(UsageInfo.zzu("intent_extra_data", string3));
        }
        return zza2.zzff(string2).zzau(true);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzj.zza(this, parcel, n);
    }

    public String toString() {
        return String.format("UsageInfo[documentId=%s, timestamp=%d, usageType=%d, status=%d]", new Object[]{this.by, this.bz, this.bA, this.bE});
    }

    public static final class zza {
        private DocumentId by;
        private long bz = -1L;
        private int bA = -1;
        private DocumentContents bB;
        private boolean bC = false;
        private int bD = -1;
        private int bE = 0;

        public zza zza(DocumentId documentId) {
            this.by = documentId;
            return this;
        }

        public zza zzy(long l) {
            this.bz = l;
            return this;
        }

        public zza zzch(int n) {
            this.bA = n;
            return this;
        }

        public zza zza(DocumentContents documentContents) {
            this.bB = documentContents;
            return this;
        }

        public zza zzax(boolean bl) {
            this.bC = bl;
            return this;
        }

        public zza zzci(int n) {
            this.bE = n;
            return this;
        }

        public UsageInfo zzaer() {
            return new UsageInfo(this.by, this.bz, this.bA, null, this.bB, this.bC, this.bD, this.bE);
        }
    }
}

