/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appdatasearch;

import android.content.ComponentName;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.appdatasearch.DocumentContents;
import com.google.android.gms.appdatasearch.DocumentId;
import com.google.android.gms.appdatasearch.DocumentSection;
import com.google.android.gms.appdatasearch.RegisterSectionInfo;
import com.google.android.gms.appdatasearch.zzj;
import com.google.android.gms.appindexing.AppIndexApi;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.internal.zzasa;
import com.google.android.gms.internal.zzvw;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Locale;
import java.util.zip.CRC32;

public class UsageInfo
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<UsageInfo> CREATOR = new zzj();
    final int mVersionCode;
    final DocumentId gR;
    final long gS;
    int gT;
    public final String zzbcj;
    final DocumentContents gU;
    final boolean gV;
    int gW;
    int gX;

    private UsageInfo(DocumentId documentId, long l, int n, String string, DocumentContents documentContents, boolean bl, int n2, int n3) {
        this(1, documentId, l, n, string, documentContents, bl, n2, n3);
    }

    public UsageInfo(String string, Intent intent, String string2, Uri uri, String string3, List<AppIndexApi.AppIndexingLink> list, int n) {
        this(1, UsageInfo.zza(string, intent), System.currentTimeMillis(), 0, null, UsageInfo.zza(intent, string2, uri, string3, list).zzaho(), false, -1, n);
    }

    UsageInfo(int n, DocumentId documentId, long l, int n2, String string, DocumentContents documentContents, boolean bl, int n3, int n4) {
        this.mVersionCode = n;
        this.gR = documentId;
        this.gS = l;
        this.gT = n2;
        this.zzbcj = string;
        this.gU = documentContents;
        this.gV = bl;
        this.gW = n3;
        this.gX = n4;
    }

    public static DocumentId zza(String string, Intent intent) {
        return UsageInfo.zzs(string, UsageInfo.zzg(intent));
    }

    private static DocumentId zzs(String string, String string2) {
        return new DocumentId(string, "", string2);
    }

    private static DocumentSection zzft(String string) {
        return new DocumentSection(string, new RegisterSectionInfo.zza("title").zzco(1).zzba(true).zzfs("name").zzahr(), "text1");
    }

    private static DocumentSection zzk(Uri uri) {
        return new DocumentSection(uri.toString(), new RegisterSectionInfo.zza("web_url").zzco(4).zzaz(true).zzfs("url").zzahr());
    }

    private static DocumentSection zzt(String string, String string2) {
        return new DocumentSection(string2, new RegisterSectionInfo.zza(string).zzaz(true).zzahr(), string);
    }

    private static String zzg(Intent intent) {
        String string = intent.toUri(1);
        CRC32 cRC32 = new CRC32();
        try {
            cRC32.update(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
        return Long.toHexString(cRC32.getValue());
    }

    private static DocumentSection zzv(List<AppIndexApi.AppIndexingLink> list) {
        zzvw.zza zza2 = new zzvw.zza();
        zzvw.zza.zza[] zzaArray = new zzvw.zza.zza[list.size()];
        for (int i = 0; i < zzaArray.length; ++i) {
            zzaArray[i] = new zzvw.zza.zza();
            AppIndexApi.AppIndexingLink appIndexingLink = list.get(i);
            zzaArray[i].ahD = appIndexingLink.appIndexingUrl.toString();
            zzaArray[i].viewId = appIndexingLink.viewId;
            if (appIndexingLink.webUrl == null) continue;
            zzaArray[i].ahE = appIndexingLink.webUrl.toString();
        }
        zza2.ahB = zzaArray;
        return new DocumentSection(zzasa.zzf((zzasa)zza2), new RegisterSectionInfo.zza("outlinks").zzaz(true).zzfs(".private:outLinks").zzfr("blob").zzahr());
    }

    public static DocumentContents.zza zza(Intent intent, String string, Uri uri, String string2, List<AppIndexApi.AppIndexingLink> list) {
        String string3;
        Bundle bundle;
        ComponentName componentName;
        String string4;
        String string5;
        DocumentContents.zza zza2 = new DocumentContents.zza();
        zza2.zza(UsageInfo.zzft(string));
        if (uri != null) {
            zza2.zza(UsageInfo.zzk(uri));
        }
        if (list != null) {
            zza2.zza(UsageInfo.zzv(list));
        }
        if ((string5 = intent.getAction()) != null) {
            zza2.zza(UsageInfo.zzt("intent_action", string5));
        }
        if ((string4 = intent.getDataString()) != null) {
            zza2.zza(UsageInfo.zzt("intent_data", string4));
        }
        if ((componentName = intent.getComponent()) != null) {
            zza2.zza(UsageInfo.zzt("intent_activity", componentName.getClassName()));
        }
        if ((bundle = intent.getExtras()) != null && (string3 = bundle.getString("intent_extra_data_key")) != null) {
            zza2.zza(UsageInfo.zzt("intent_extra_data", string3));
        }
        return zza2.zzfp(string2).zzay(true);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzj.zza(this, parcel, n);
    }

    public String toString() {
        return String.format(Locale.US, "UsageInfo[documentId=%s, timestamp=%d, usageType=%d, status=%d]", new Object[]{this.gR, this.gS, this.gT, this.gX});
    }

    public static final class zza {
        private DocumentId gR;
        private long gS = -1L;
        private int gT = -1;
        private DocumentContents gU;
        private boolean gV = false;
        private int gW = -1;
        private int gX = 0;

        public zza zza(DocumentId documentId) {
            this.gR = documentId;
            return this;
        }

        public zza zzaa(long l) {
            this.gS = l;
            return this;
        }

        public zza zzcq(int n) {
            this.gT = n;
            return this;
        }

        public zza zza(DocumentContents documentContents) {
            this.gU = documentContents;
            return this;
        }

        public zza zzbb(boolean bl) {
            this.gV = bl;
            return this;
        }

        public zza zzcr(int n) {
            this.gX = n;
            return this;
        }

        public UsageInfo zzahs() {
            return new UsageInfo(this.gR, this.gS, this.gT, null, this.gU, this.gV, this.gW, this.gX);
        }
    }
}

