/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appindexing;

import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.common.internal.zzz;
import java.util.List;

public final class AndroidAppUri {
    private final Uri mUri;

    private AndroidAppUri(Uri uri) {
        this.mUri = uri;
    }

    public static AndroidAppUri newAndroidAppUri(Uri uri) {
        AndroidAppUri androidAppUri = new AndroidAppUri(uri);
        if (AndroidAppUri.zza(androidAppUri)) {
            return androidAppUri;
        }
        throw new IllegalArgumentException("AndroidAppUri validation failed.");
    }

    public static AndroidAppUri newAndroidAppUri(String string, Uri uri) {
        Uri.Builder builder = new Uri.Builder().scheme("android-app").authority(string);
        if (uri != null) {
            builder.appendPath(uri.getScheme());
            if (uri.getAuthority() != null) {
                builder.appendPath(uri.getAuthority());
            }
            for (String string2 : uri.getPathSegments()) {
                builder.appendPath(string2);
            }
            builder.encodedQuery(uri.getEncodedQuery()).encodedFragment(uri.getEncodedFragment());
        }
        return new AndroidAppUri(builder.build());
    }

    public Uri toUri() {
        return this.mUri;
    }

    public String getPackageName() {
        return this.mUri.getAuthority();
    }

    public Uri getDeepLinkUri() {
        List list = this.mUri.getPathSegments();
        if (list.size() > 0) {
            String string = (String)list.get(0);
            Uri.Builder builder = new Uri.Builder();
            builder.scheme(string);
            if (list.size() > 1) {
                builder.authority((String)list.get(1));
                for (int i = 2; i < list.size(); ++i) {
                    builder.appendPath((String)list.get(i));
                }
            }
            builder.encodedQuery(this.mUri.getEncodedQuery());
            builder.encodedFragment(this.mUri.getEncodedFragment());
            return builder.build();
        }
        return null;
    }

    public String toString() {
        return this.mUri.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof AndroidAppUri) {
            return this.mUri.equals((Object)((AndroidAppUri)object).mUri);
        }
        return false;
    }

    public int hashCode() {
        return zzz.hashCode((Object[])new Object[]{this.mUri});
    }

    private static boolean zza(AndroidAppUri androidAppUri) {
        if (!"android-app".equals(androidAppUri.mUri.getScheme())) {
            throw new IllegalArgumentException("android-app scheme is required.");
        }
        if (TextUtils.isEmpty((CharSequence)androidAppUri.getPackageName())) {
            throw new IllegalArgumentException("Package name is empty.");
        }
        Uri uri = AndroidAppUri.newAndroidAppUri(androidAppUri.getPackageName(), androidAppUri.getDeepLinkUri()).toUri();
        if (!androidAppUri.mUri.equals((Object)uri)) {
            throw new IllegalArgumentException("URI is not canonical.");
        }
        return true;
    }
}

