/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.appdatasearch.UsageInfo;
import com.google.android.gms.appdatasearch.zzk;
import com.google.android.gms.appindexing.Action;
import com.google.android.gms.appindexing.AppIndexApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zznf;
import com.google.android.gms.internal.zzng;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.internal.zzni;
import com.google.android.gms.internal.zznj;
import com.google.android.gms.internal.zzqo;
import java.util.List;

public final class zznk
implements zzk,
AppIndexApi {
    private static final String TAG = zznk.class.getSimpleName();

    public PendingResult<Status> zza(GoogleApiClient googleApiClient, final UsageInfo ... usageInfoArray) {
        return googleApiClient.zza((zzqo.zza)new zzc<Status>(googleApiClient){

            @Override
            protected void zza(zznf zznf2) throws RemoteException {
                zznf2.zza((zzng)new zzd((zzqo.zzb<Status>)this), null, usageInfoArray);
            }
        });
    }

    @Override
    public PendingResult<Status> view(GoogleApiClient googleApiClient, Activity activity, Intent intent, String string, Uri uri, List<AppIndexApi.AppIndexingLink> list) {
        String string2 = googleApiClient.getContext().getPackageName();
        zznk.zzw(list);
        return this.zza(googleApiClient, new UsageInfo(string2, intent, string, uri, null, list, 1));
    }

    @Override
    public PendingResult<Status> viewEnd(GoogleApiClient googleApiClient, Activity activity, Intent intent) {
        String string = googleApiClient.getContext().getPackageName();
        UsageInfo usageInfo = new UsageInfo.zza().zza(UsageInfo.zza(string, intent)).zzaa(System.currentTimeMillis()).zzcq(0).zzcr(2).zzahs();
        return this.zza(googleApiClient, usageInfo);
    }

    public static Intent zza(String string, Uri uri) {
        zznk.zzb(string, uri);
        if (zznk.zzm(uri)) {
            return new Intent("android.intent.action.VIEW", uri);
        }
        if (zznk.zzn(uri)) {
            return new Intent("android.intent.action.VIEW", zznk.zzl(uri));
        }
        String string2 = String.valueOf(uri);
        throw new RuntimeException(new StringBuilder(70 + String.valueOf(string2).length()).append("appIndexingUri is neither an HTTP(S) URL nor an \"android-app://\" URL: ").append(string2).toString());
    }

    private static Uri zzl(Uri uri) {
        List list = uri.getPathSegments();
        String string = (String)list.get(0);
        Uri.Builder builder = new Uri.Builder();
        builder.scheme(string);
        if (list.size() > 1) {
            builder.authority((String)list.get(1));
            for (int i = 2; i < list.size(); ++i) {
                builder.appendPath((String)list.get(i));
            }
        } else {
            String string2 = String.valueOf(uri);
            Log.e((String)TAG, (String)new StringBuilder(88 + String.valueOf(string2).length()).append("The app URI must have the format: android-app://<package_name>/<scheme>/<path>. But got ").append(string2).toString());
        }
        builder.encodedQuery(uri.getEncodedQuery());
        builder.encodedFragment(uri.getEncodedFragment());
        return builder.build();
    }

    private static void zzb(String string, Uri uri) {
        if (zznk.zzm(uri)) {
            if (uri.getHost().isEmpty()) {
                String string2 = String.valueOf(uri);
                throw new IllegalArgumentException(new StringBuilder(98 + String.valueOf(string2).length()).append("AppIndex: The web URL must have a host (follow the format http(s)://<host>/<path>). Provided URI: ").append(string2).toString());
            }
            return;
        }
        if (zznk.zzn(uri)) {
            if (string != null && !string.equals(uri.getHost())) {
                String string3 = String.valueOf(uri);
                throw new IllegalArgumentException(new StringBuilder(150 + String.valueOf(string3).length()).append("AppIndex: The android-app URI host must match the package name and follow the format android-app://<package_name>/<scheme>/<host_path>. Provided URI: ").append(string3).toString());
            }
            List list = uri.getPathSegments();
            if (list.isEmpty() || ((String)list.get(0)).isEmpty()) {
                String string4 = String.valueOf(uri);
                throw new IllegalArgumentException(new StringBuilder(128 + String.valueOf(string4).length()).append("AppIndex: The app URI scheme must exist and follow the format android-app://<package_name>/<scheme>/<host_path>). Provided URI: ").append(string4).toString());
            }
            return;
        }
        String string5 = String.valueOf(uri);
        throw new IllegalArgumentException(new StringBuilder(176 + String.valueOf(string5).length()).append("AppIndex: The URI scheme must either be 'http(s)' or 'android-app'. If the latter, it must follow the format 'android-app://<package_name>/<scheme>/<host_path>'. Provided URI: ").append(string5).toString());
    }

    private static boolean zzm(Uri uri) {
        String string = uri.getScheme();
        return "http".equals(string) || "https".equals(string);
    }

    private static boolean zzn(Uri uri) {
        String string = uri.getScheme();
        return "android-app".equals(string);
    }

    public static void zzw(List<AppIndexApi.AppIndexingLink> list) {
        if (list == null) {
            return;
        }
        for (AppIndexApi.AppIndexingLink appIndexingLink : list) {
            zznk.zzb(null, appIndexingLink.appIndexingUrl);
        }
    }

    @Override
    public PendingResult<Status> view(GoogleApiClient googleApiClient, Activity activity, Uri uri, String string, Uri uri2, List<AppIndexApi.AppIndexingLink> list) {
        String string2 = googleApiClient.getContext().getPackageName();
        zznk.zzb(string2, uri);
        Intent intent = zznk.zza(string2, uri);
        return this.view(googleApiClient, activity, intent, string, uri2, list);
    }

    @Override
    public PendingResult<Status> viewEnd(GoogleApiClient googleApiClient, Activity activity, Uri uri) {
        String string = googleApiClient.getContext().getPackageName();
        Intent intent = zznk.zza(string, uri);
        return this.viewEnd(googleApiClient, activity, intent);
    }

    @Override
    public AppIndexApi.ActionResult action(GoogleApiClient googleApiClient, Action action) {
        PendingResult<Status> pendingResult = this.zza(googleApiClient, action, 1);
        return new zza(this, pendingResult, action);
    }

    @Override
    public PendingResult<Status> start(GoogleApiClient googleApiClient, Action action) {
        return this.zza(googleApiClient, action, 1);
    }

    @Override
    public PendingResult<Status> end(GoogleApiClient googleApiClient, Action action) {
        return this.zza(googleApiClient, action, 2);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, Action action, int n) {
        String string = googleApiClient.getContext().getPackageName();
        long l = System.currentTimeMillis();
        UsageInfo usageInfo = zznj.zza(action, l, string, n);
        return this.zza(googleApiClient, usageInfo);
    }

    @Deprecated
    private static final class zza
    implements AppIndexApi.ActionResult {
        private zznk hb;
        private PendingResult<Status> hc;
        private Action hd;

        zza(zznk zznk2, PendingResult<Status> pendingResult, Action action) {
            this.hb = zznk2;
            this.hc = pendingResult;
            this.hd = action;
        }

        @Override
        public PendingResult<Status> end(GoogleApiClient googleApiClient) {
            String string = googleApiClient.getContext().getPackageName();
            long l = System.currentTimeMillis();
            UsageInfo usageInfo = zznj.zza(this.hd, l, string, 2);
            return this.hb.zza(googleApiClient, usageInfo);
        }

        @Override
        public PendingResult<Status> getPendingResult() {
            return this.hc;
        }
    }

    public static final class zzd
    extends zznh<Status> {
        public zzd(zzqo.zzb<Status> zzb2) {
            super(zzb2);
        }

        @Override
        public void zza(Status status) {
            this.gY.setResult((Object)status);
        }
    }

    public static abstract class zzc<T extends Result>
    extends zzb<Status> {
        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected Status zzb(Status status) {
            return status;
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzb(status);
        }
    }

    private static abstract class zzb<T extends Result>
    extends zzqo.zza<T, zzni> {
        public zzb(GoogleApiClient googleApiClient) {
            super(com.google.android.gms.appdatasearch.zza.gb, googleApiClient);
        }

        protected final void zza(zzni zzni2) throws RemoteException {
            this.zza(zzni2.zzaht());
        }

        protected abstract void zza(zznf var1) throws RemoteException;
    }
}

