/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appindexing.internal;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.internal.zzrl;
import com.google.android.gms.internal.zzsb;
import com.google.android.gms.internal.zzse;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.appindexing.FirebaseAppIndex;
import com.google.firebase.appindexing.FirebaseAppIndexingInvalidArgumentException;
import com.google.firebase.appindexing.Indexable;
import com.google.firebase.appindexing.internal.Thing;
import com.google.firebase.appindexing.internal.zzd;
import com.google.firebase.appindexing.internal.zzf;
import com.google.firebase.appindexing.internal.zzg;
import com.google.firebase.appindexing.internal.zzl;
import java.util.concurrent.Executor;

public final class zzc
extends FirebaseAppIndex {
    private zzc aWC;

    public zzc(@NonNull Context context) {
        this(context, new zza(context));
    }

    zzc(@NonNull Context context, @NonNull com.google.android.gms.common.api.zzc<Api.ApiOptions.NoOptions> zzc2) {
        this.aWC = new zzc(zzc2);
    }

    @Override
    public Task<Void> update(Indexable ... indexableArray) {
        if (indexableArray == null) {
            return Tasks.forException((Exception)new NullPointerException("Indexables cannot be null."));
        }
        final Thing[] thingArray = new Thing[indexableArray.length];
        try {
            System.arraycopy(indexableArray, 0, thingArray, 0, indexableArray.length);
        }
        catch (ArrayStoreException arrayStoreException) {
            return Tasks.forException((Exception)((Object)new FirebaseAppIndexingInvalidArgumentException("Custom Indexable-objects are not allowed. Please use the 'Indexables'-class for creating the objects.")));
        }
        return this.aWC.zzb(new zzb(){

            @Override
            protected void zza(zzf zzf2) throws RemoteException {
                zzf2.zza(this.zzcom(), thingArray);
            }
        });
    }

    @Override
    public Task<Void> remove(final String ... stringArray) {
        return this.aWC.zzb(new zzb(){

            @Override
            protected void zza(zzf zzf2) throws RemoteException {
                zzf2.zza(this.zzcom(), stringArray);
            }
        });
    }

    @Override
    public Task<Void> removeAll() {
        return this.aWC.zzb(new zzb(){

            @Override
            protected void zza(zzf zzf2) throws RemoteException {
                zzf2.zze(this.zzcom());
            }
        });
    }

    static class zzc
    implements OnCompleteListener<Void>,
    Executor {
        public static int MAX_RETRIES = 10;
        public static long aWH = 250L;
        public static double aWI = 1.5;
        public static double aWJ = 0.25;
        @NonNull
        private final com.google.android.gms.common.api.zzc<?> Bs;
        @NonNull
        private final Handler mHandler;
        @Nullable
        private Task<Void> aWK = null;

        public zzc(@NonNull com.google.android.gms.common.api.zzc<?> zzc2) {
            this.Bs = zzc2;
            this.mHandler = new Handler(zzc2.getLooper());
        }

        static long zzafa(int n) {
            double d = (double)aWH * Math.pow(aWI, n) * ((Math.random() * 2.0 - 1.0) * aWJ + 1.0);
            return (long)d;
        }

        private static boolean zzc(@NonNull Task<Status> task) {
            if (task.isSuccessful()) {
                Status status = (Status)task.getResult();
                return zzd.zzafb(status.getStatusCode());
            }
            return false;
        }

        private void zza(final @NonNull zzb zzb2, final @NonNull TaskCompletionSource<Void> taskCompletionSource, final int n) {
            this.Bs.doWrite((zzse)zzb2).addOnCompleteListener((Executor)this, (OnCompleteListener)new OnCompleteListener<Status>(){

                public void onComplete(@NonNull Task<Status> task) {
                    Object object;
                    if (n < MAX_RETRIES && zzc.zzc((Task<Status>)task)) {
                        object = new Runnable(){

                            @Override
                            public void run() {
                                zzc.this.zza(zzb2, (TaskCompletionSource<Void>)taskCompletionSource, n + 1);
                            }
                        };
                        long l = zzc.zzafa(n);
                        if (zzc.this.mHandler.postDelayed((Runnable)object, l)) {
                            zzg.zzrr(new StringBuilder(47).append("Task will be retried in ").append(l).append(" ms").toString());
                            return;
                        }
                        zzg.zzrr("Failed to schedule retry -- failing immediately!");
                    }
                    if (task.isSuccessful()) {
                        object = (Status)task.getResult();
                        if (object.isSuccess()) {
                            taskCompletionSource.setResult(null);
                        } else {
                            taskCompletionSource.setException((Exception)((Object)zzl.zzb(object, "Indexing error, please try again.")));
                        }
                    } else {
                        taskCompletionSource.setException(task.getException());
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Task<Void> zzb(final @NonNull zzb zzb2) {
            Task<Void> task;
            final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
            Task task2 = taskCompletionSource.getTask();
            zzc zzc2 = this;
            synchronized (zzc2) {
                task = this.aWK;
                this.aWK = task2;
            }
            task2.addOnCompleteListener((Executor)this, (OnCompleteListener)this);
            if (task == null) {
                this.zza(zzb2, (TaskCompletionSource<Void>)taskCompletionSource, 0);
            } else {
                task.addOnCompleteListener((Executor)this, (OnCompleteListener)new OnCompleteListener<Void>(){

                    public void onComplete(@NonNull Task<Void> task) {
                        zzc.this.zza(zzb2, (TaskCompletionSource<Void>)taskCompletionSource, 0);
                    }
                });
            }
            return task2;
        }

        public synchronized void onComplete(@NonNull Task<Void> task) {
            if (task == this.aWK) {
                this.aWK = null;
            }
        }

        @Override
        public void execute(Runnable runnable) {
            this.mHandler.post(runnable);
        }
    }

    private static abstract class zzb
    extends zzse<com.google.firebase.appindexing.internal.zzb, Status> {
        private TaskCompletionSource<Status> yg;

        private zzb() {
        }

        protected final void zza(com.google.firebase.appindexing.internal.zzb zzb2, TaskCompletionSource<Status> taskCompletionSource) throws RemoteException {
            this.yg = taskCompletionSource;
            this.zza((zzf)zzb2.zzavg());
        }

        protected abstract void zza(zzf var1) throws RemoteException;

        protected zzrl zzcom() {
            return new zzrl.zza(){

                public void zzp(Status status) throws RemoteException {
                    zzb.this.yg.setResult((Object)status);
                }
            };
        }

        protected /* synthetic */ void zzb(Api.zzb zzb2, TaskCompletionSource taskCompletionSource) throws RemoteException {
            this.zza((com.google.firebase.appindexing.internal.zzb)zzb2, (TaskCompletionSource<Status>)taskCompletionSource);
        }
    }

    private static class zza
    extends com.google.android.gms.common.api.zzc<Api.ApiOptions.NoOptions> {
        public zza(Context context) {
            super(context, com.google.firebase.appindexing.internal.zzb.API, null, Looper.getMainLooper(), (zzsb)new com.google.firebase.zza());
        }
    }
}

