/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appinvite;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class AppInviteReferral {
    private AppInviteReferral() {
    }

    public static boolean hasReferral(Intent intent) {
        return intent != null && intent.getBundleExtra("com.google.android.gms.appinvite.REFERRAL_BUNDLE") != null;
    }

    public static boolean isOpenedFromPlayStore(Intent intent) {
        return AppInviteReferral.hasReferral(intent) && intent.getBundleExtra("com.google.android.gms.appinvite.REFERRAL_BUNDLE").getBoolean("com.google.android.gms.appinvite.OPENED_FROM_PLAY_STORE", false);
    }

    public static String getInvitationId(Intent intent) {
        Bundle bundle;
        if (intent != null && (bundle = intent.getBundleExtra("com.google.android.gms.appinvite.REFERRAL_BUNDLE")) != null) {
            return bundle.getString("com.google.android.gms.appinvite.INVITATION_ID");
        }
        return null;
    }

    public static String getDeepLink(Intent intent) {
        Bundle bundle;
        if (intent != null && (bundle = intent.getBundleExtra("com.google.android.gms.appinvite.REFERRAL_BUNDLE")) != null) {
            return bundle.getString("com.google.android.gms.appinvite.DEEP_LINK");
        }
        return null;
    }

    @Deprecated
    public static Intent addPlayStoreReferrerToIntent(Intent intent, Intent intent2) {
        Bundle bundle = AppInviteReferral.zzh(intent);
        if (bundle != null && intent2 != null) {
            intent2.putExtra("com.google.android.gms.appinvite.REFERRAL_BUNDLE", bundle);
        }
        return intent2;
    }

    @Deprecated
    public static Intent addReferralDataToIntent(String string, String string2, Intent intent) {
        if (intent == null) {
            return null;
        }
        return intent.putExtra("com.google.android.gms.appinvite.REFERRAL_BUNDLE", AppInviteReferral.zzd(string, string2, false));
    }

    private static Bundle zzd(String string, String string2, boolean bl) {
        Bundle bundle = new Bundle();
        bundle.putString("com.google.android.gms.appinvite.INVITATION_ID", string);
        bundle.putString("com.google.android.gms.appinvite.DEEP_LINK", string2);
        bundle.putBoolean("com.google.android.gms.appinvite.OPENED_FROM_PLAY_STORE", bl);
        return bundle;
    }

    private static Bundle zzh(Intent intent) {
        if (intent == null || !intent.getAction().equals("com.android.vending.INSTALL_REFERRER") || intent.getStringExtra("referrer") == null) {
            return null;
        }
        String string = intent.getStringExtra("referrer");
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = String.valueOf(string);
            Log.e((String)"AppInviteRef", (String)(string2.length() != 0 ? "Error parsing Play Store referrer URL: ".concat(string2) : new String("Error parsing Play Store referrer URL: ")));
            return null;
        }
        String string3 = String.valueOf(string);
        Uri uri = Uri.parse((String)(string3.length() != 0 ? "s://a.b.c?".concat(string3) : new String("s://a.b.c?")));
        String string4 = uri.getQueryParameter("invitation_id");
        String string5 = uri.getQueryParameter("deep_link_id");
        if (string4 == null && string5 == null) {
            String string6 = String.valueOf(string);
            Log.w((String)"AppInviteRef", (String)(string6.length() != 0 ? "Missing  Referrer query params: ".concat(string6) : new String("Missing  Referrer query params: ")));
            return null;
        }
        return AppInviteReferral.zzd(string4, string5, true);
    }
}

