/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.support.annotation.RequiresPermission;
import android.text.TextUtils;
import com.google.android.gms.auth.AccountChangeEvent;
import com.google.android.gms.auth.AccountChangeEventsRequest;
import com.google.android.gms.auth.AccountChangeEventsResponse;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GooglePlayServicesAvailabilityException;
import com.google.android.gms.auth.TokenData;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.auth.zzd;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzn;
import com.google.android.gms.common.zzg;
import com.google.android.gms.internal.zzacm;
import com.google.android.gms.internal.zzcb;
import com.google.android.gms.internal.zzvv;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;

public class zze {
    public static final String GOOGLE_ACCOUNT_TYPE = "com.google";
    public static final String WORK_ACCOUNT_TYPE = "com.google.work";
    private static final String[] zzaiy = new String[]{"com.google", "com.google.work", "cn.google"};
    public static final String KEY_SUPPRESS_PROGRESS_SCREEN = "suppressProgressScreen";
    @SuppressLint(value={"InlinedApi"})
    public static final String KEY_CALLER_UID = "callerUid";
    @SuppressLint(value={"InlinedApi"})
    public static final String KEY_ANDROID_PACKAGE_NAME = "androidPackageName";
    public static final int CHANGE_TYPE_ACCOUNT_ADDED = 1;
    public static final int CHANGE_TYPE_ACCOUNT_REMOVED = 2;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_FROM = 3;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_TO = 4;
    private static final ComponentName zzaiz = new ComponentName("com.google.android.gms", "com.google.android.gms.auth.GetToken");
    private static final zzacm zzaiA = zzd.zzb("GoogleAuthUtil");

    @Deprecated
    public static String getToken(Context context, String string, String string2) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        Account account = new Account(string, GOOGLE_ACCOUNT_TYPE);
        return zze.getToken(context, account, string2);
    }

    @Deprecated
    public static String getToken(Context context, String string, String string2, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        Account account = new Account(string, GOOGLE_ACCOUNT_TYPE);
        return zze.getToken(context, account, string2, bundle);
    }

    public static String getToken(Context context, Account account, String string) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return zze.getToken(context, account, string, new Bundle());
    }

    public static String getToken(Context context, Account account, String string, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        zze.zzc(account);
        TokenData tokenData = zze.zzc(context, account, string, bundle);
        return tokenData.getToken();
    }

    public static TokenData zzc(Context context, final Account account, final String string, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        zzac.zzdk((String)"Calling this from your main thread can lead to deadlock");
        zzac.zzh((String)string, (Object)"Scope cannot be empty or null.");
        zze.zzc(account);
        zze.zzaq(context);
        final Bundle bundle2 = bundle == null ? new Bundle() : new Bundle(bundle);
        String string2 = context.getApplicationInfo().packageName;
        bundle2.putString("clientPackageName", string2);
        if (TextUtils.isEmpty((CharSequence)bundle2.getString(KEY_ANDROID_PACKAGE_NAME))) {
            bundle2.putString(KEY_ANDROID_PACKAGE_NAME, string2);
        }
        bundle2.putLong("service_connection_start_time_millis", SystemClock.elapsedRealtime());
        zza<TokenData> zza2 = new zza<TokenData>(){

            public TokenData zzat(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                zzcb zzcb2 = zzcb.zza.zza(iBinder);
                Bundle bundle = (Bundle)zze.zzn(zzcb2.zza(account, string, bundle2));
                TokenData tokenData = TokenData.zzd(bundle, "tokenDetails");
                if (tokenData != null) {
                    return tokenData;
                }
                String string3 = bundle.getString("Error");
                Intent intent = (Intent)bundle.getParcelable("userRecoveryIntent");
                zzvv zzvv2 = zzvv.zzcE(string3);
                if (zzvv.zza(zzvv2)) {
                    Object[] objectArray = new Object[1];
                    String string2 = String.valueOf((Object)zzvv2);
                    objectArray[0] = new StringBuilder(31 + String.valueOf(string2).length()).append("isUserRecoverableError status: ").append(string2).toString();
                    zzaiA.zzf("GoogleAuthUtil", objectArray);
                    throw new UserRecoverableAuthException(string3, intent);
                }
                if (zzvv.zzb(zzvv2)) {
                    throw new IOException(string3);
                }
                throw new GoogleAuthException(string3);
            }

            @Override
            public /* synthetic */ Object zzau(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                return this.zzat(iBinder);
            }
        };
        return zze.zza(context, zzaiz, zza2);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.MANAGE_ACCOUNTS")
    public static void invalidateToken(Context context, String string) {
        AccountManager.get((Context)context).invalidateAuthToken(GOOGLE_ACCOUNT_TYPE, string);
    }

    public static void clearToken(Context context, final String string) throws GooglePlayServicesAvailabilityException, GoogleAuthException, IOException {
        zzac.zzdk((String)"Calling this from your main thread can lead to deadlock");
        zze.zzaq(context);
        final Bundle bundle = new Bundle();
        String string2 = context.getApplicationInfo().packageName;
        bundle.putString("clientPackageName", string2);
        if (!bundle.containsKey(KEY_ANDROID_PACKAGE_NAME)) {
            bundle.putString(KEY_ANDROID_PACKAGE_NAME, string2);
        }
        zza<Void> zza2 = new zza<Void>(){

            public Void zzav(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                zzcb zzcb2 = zzcb.zza.zza(iBinder);
                Bundle bundle2 = (Bundle)zze.zzn(zzcb2.zza(string, bundle));
                String string2 = bundle2.getString("Error");
                if (!bundle2.getBoolean("booleanResult")) {
                    throw new GoogleAuthException(string2);
                }
                return null;
            }

            @Override
            public /* synthetic */ Object zzau(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                return this.zzav(iBinder);
            }
        };
        zze.zza(context, zzaiz, zza2);
    }

    public static List<AccountChangeEvent> getAccountChangeEvents(Context context, final int n, final String string) throws GoogleAuthException, IOException {
        zzac.zzh((String)string, (Object)"accountName must be provided");
        zzac.zzdk((String)"Calling this from your main thread can lead to deadlock");
        zze.zzaq(context);
        zza<List<AccountChangeEvent>> zza2 = new zza<List<AccountChangeEvent>>(){

            public List<AccountChangeEvent> zzaw(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                zzcb zzcb2 = zzcb.zza.zza(iBinder);
                AccountChangeEventsRequest accountChangeEventsRequest = new AccountChangeEventsRequest().setAccountName(string).setEventIndex(n);
                AccountChangeEventsResponse accountChangeEventsResponse = (AccountChangeEventsResponse)((Object)zze.zzn((Object)zzcb2.zza(accountChangeEventsRequest)));
                return accountChangeEventsResponse.getEvents();
            }

            @Override
            public /* synthetic */ Object zzau(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                return this.zzaw(iBinder);
            }
        };
        return zze.zza(context, zzaiz, zza2);
    }

    public static String getAccountId(Context context, String string) throws GoogleAuthException, IOException {
        zzac.zzh((String)string, (Object)"accountName must be provided");
        zzac.zzdk((String)"Calling this from your main thread can lead to deadlock");
        zze.zzaq(context);
        return zze.getToken(context, string, "^^_account_id_^^", new Bundle());
    }

    @TargetApi(value=23)
    public static Bundle removeAccount(Context context, final Account account) throws GoogleAuthException, IOException {
        zzac.zzw((Object)context);
        zze.zzc(account);
        zze.zzaq(context);
        zza<Bundle> zza2 = new zza<Bundle>(){

            public Bundle zzax(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                zzcb zzcb2 = zzcb.zza.zza(iBinder);
                return (Bundle)zze.zzn(zzcb2.zza(account));
            }

            @Override
            public /* synthetic */ Object zzau(IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
                return this.zzax(iBinder);
            }
        };
        return zze.zza(context, zzaiz, zza2);
    }

    static void zzi(Intent intent) {
        if (intent == null) {
            throw new IllegalArgumentException("Callback cannot be null.");
        }
        String string = intent.toUri(1);
        try {
            Intent.parseUri((String)string, (int)1);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Parameter callback contains invalid data. It must be serializable using toUri() and parseUri().");
        }
    }

    private static void zzc(Account account) {
        if (account == null) {
            throw new IllegalArgumentException("Account cannot be null");
        }
        if (TextUtils.isEmpty((CharSequence)account.name)) {
            throw new IllegalArgumentException("Account name cannot be empty!");
        }
        for (String string : zzaiy) {
            if (!string.equals(account.type)) continue;
            return;
        }
        throw new IllegalArgumentException("Account type not supported");
    }

    private static void zzaq(Context context) throws GoogleAuthException {
        try {
            zzg.zzaq((Context)context.getApplicationContext());
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            throw new GooglePlayServicesAvailabilityException(googlePlayServicesRepairableException.getConnectionStatusCode(), googlePlayServicesRepairableException.getMessage(), googlePlayServicesRepairableException.getIntent());
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            throw new GoogleAuthException(googlePlayServicesNotAvailableException.getMessage());
        }
    }

    private static <T> T zzn(T t) throws IOException {
        if (t == null) {
            zzaiA.zzf("GoogleAuthUtil", new Object[]{"Binder call returned null."});
            throw new IOException("Service unavailable.");
        }
        return t;
    }

    private static <T> T zza(Context context, ComponentName componentName, zza<T> zza2) throws IOException, GoogleAuthException {
        com.google.android.gms.common.zza zza3 = new com.google.android.gms.common.zza();
        zzn zzn2 = zzn.zzaU((Context)context);
        if (zzn2.zza(componentName, (ServiceConnection)zza3, "GoogleAuthUtil")) {
            try {
                T t = zza2.zzau(zza3.zzuX());
                return t;
            }
            catch (RemoteException | InterruptedException throwable) {
                zzaiA.zze("GoogleAuthUtil", new Object[]{"Error on service connection.", throwable});
                throw new IOException("Error on service connection.", throwable);
            }
            finally {
                zzn2.zzb(componentName, (ServiceConnection)zza3, "GoogleAuthUtil");
            }
        }
        throw new IOException("Could not bind to service.");
    }

    zze() {
    }

    private static interface zza<T> {
        public T zzau(IBinder var1) throws RemoteException, IOException, GoogleAuthException;
    }
}

