/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.support.annotation.RequiresPermission;
import android.text.TextUtils;
import com.google.android.gms.auth.AccountChangeEvent;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GooglePlayServicesAvailabilityException;
import com.google.android.gms.auth.TokenData;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.auth.zze;
import com.google.android.gms.auth.zzf;
import com.google.android.gms.auth.zzg;
import com.google.android.gms.auth.zzh;
import com.google.android.gms.auth.zzi;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.internal.zzae;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.zza;
import com.google.android.gms.common.zzo;
import com.google.android.gms.internal.zzbga;
import java.io.IOException;
import java.util.List;

public class zzd {
    public static final String GOOGLE_ACCOUNT_TYPE = "com.google";
    public static final String WORK_ACCOUNT_TYPE = "com.google.work";
    private static final String[] zzakl = new String[]{"com.google", "com.google.work", "cn.google"};
    public static final String KEY_SUPPRESS_PROGRESS_SCREEN = "suppressProgressScreen";
    @SuppressLint(value={"InlinedApi"})
    public static final String KEY_CALLER_UID = "callerUid";
    @SuppressLint(value={"InlinedApi"})
    public static final String KEY_ANDROID_PACKAGE_NAME = "androidPackageName";
    public static final int CHANGE_TYPE_ACCOUNT_ADDED = 1;
    public static final int CHANGE_TYPE_ACCOUNT_REMOVED = 2;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_FROM = 3;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_TO = 4;
    private static final ComponentName zzakm = new ComponentName("com.google.android.gms", "com.google.android.gms.auth.GetToken");
    private static final zzbga zzakn;

    @Deprecated
    public static String getToken(Context context, String string, String string2) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        Account account = new Account(string, GOOGLE_ACCOUNT_TYPE);
        return zzd.getToken(context, account, string2);
    }

    @Deprecated
    public static String getToken(Context context, String string, String string2, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        Account account = new Account(string, GOOGLE_ACCOUNT_TYPE);
        return zzd.getToken(context, account, string2, bundle);
    }

    public static String getToken(Context context, Account account, String string) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return zzd.getToken(context, account, string, new Bundle());
    }

    public static String getToken(Context context, Account account, String string, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        zzd.zzc(account);
        return zzd.zzb(context, account, string, bundle).getToken();
    }

    public static TokenData zzb(Context context, Account account, String string, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        zzbo.zzcG((String)"Calling this from your main thread can lead to deadlock");
        zzbo.zzh((String)string, (Object)"Scope cannot be empty or null.");
        zzd.zzc(account);
        zzd.zzah(context);
        Bundle bundle2 = bundle == null ? new Bundle() : new Bundle(bundle);
        String string2 = context.getApplicationInfo().packageName;
        bundle2.putString("clientPackageName", string2);
        if (TextUtils.isEmpty((CharSequence)bundle2.getString(KEY_ANDROID_PACKAGE_NAME))) {
            bundle2.putString(KEY_ANDROID_PACKAGE_NAME, string2);
        }
        bundle2.putLong("service_connection_start_time_millis", SystemClock.elapsedRealtime());
        zze zze2 = new zze(account, string, bundle2);
        return zzd.zza(context, zzakm, zze2);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.MANAGE_ACCOUNTS")
    public static void invalidateToken(Context context, String string) {
        AccountManager.get((Context)context).invalidateAuthToken(GOOGLE_ACCOUNT_TYPE, string);
    }

    public static void clearToken(Context context, String string) throws GooglePlayServicesAvailabilityException, GoogleAuthException, IOException {
        zzbo.zzcG((String)"Calling this from your main thread can lead to deadlock");
        zzd.zzah(context);
        Bundle bundle = new Bundle();
        String string2 = context.getApplicationInfo().packageName;
        bundle.putString("clientPackageName", string2);
        if (!bundle.containsKey(KEY_ANDROID_PACKAGE_NAME)) {
            bundle.putString(KEY_ANDROID_PACKAGE_NAME, string2);
        }
        zzf zzf2 = new zzf(string, bundle);
        zzd.zza(context, zzakm, zzf2);
    }

    public static List<AccountChangeEvent> getAccountChangeEvents(Context context, int n, String string) throws GoogleAuthException, IOException {
        zzbo.zzh((String)string, (Object)"accountName must be provided");
        zzbo.zzcG((String)"Calling this from your main thread can lead to deadlock");
        zzd.zzah(context);
        zzg zzg2 = new zzg(string, n);
        return zzd.zza(context, zzakm, zzg2);
    }

    public static String getAccountId(Context context, String string) throws GoogleAuthException, IOException {
        zzbo.zzh((String)string, (Object)"accountName must be provided");
        zzbo.zzcG((String)"Calling this from your main thread can lead to deadlock");
        zzd.zzah(context);
        return zzd.getToken(context, string, "^^_account_id_^^", new Bundle());
    }

    @TargetApi(value=23)
    public static Bundle removeAccount(Context context, Account account) throws GoogleAuthException, IOException {
        zzbo.zzu((Object)context);
        zzd.zzc(account);
        zzd.zzah(context);
        zzh zzh2 = new zzh(account);
        return zzd.zza(context, zzakm, zzh2);
    }

    private static void zzc(Account account) {
        if (account == null) {
            throw new IllegalArgumentException("Account cannot be null");
        }
        if (TextUtils.isEmpty((CharSequence)account.name)) {
            throw new IllegalArgumentException("Account name cannot be empty!");
        }
        String[] stringArray = zzakl;
        int n = zzakl.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(account.type)) continue;
            return;
        }
        throw new IllegalArgumentException("Account type not supported");
    }

    private static void zzah(Context context) throws GoogleAuthException {
        try {
            zzo.zzah((Context)context.getApplicationContext());
            return;
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            throw new GooglePlayServicesAvailabilityException(googlePlayServicesRepairableException.getConnectionStatusCode(), googlePlayServicesRepairableException.getMessage(), googlePlayServicesRepairableException.getIntent());
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            throw new GoogleAuthException(googlePlayServicesNotAvailableException.getMessage());
        }
    }

    private static <T> T zzl(T t) throws IOException {
        if (t == null) {
            zzakn.zzf("GoogleAuthUtil", new Object[]{"Binder call returned null."});
            throw new IOException("Service unavailable.");
        }
        return t;
    }

    private static <T> T zza(Context context, ComponentName componentName, zzi<T> zzi2) throws IOException, GoogleAuthException {
        zza zza2 = new zza();
        zzae zzae2 = zzae.zzaC((Context)context);
        if (zzae2.zza(componentName, (ServiceConnection)zza2, "GoogleAuthUtil")) {
            try {
                T t = zzi2.zzy(zza2.zzoV());
                return t;
            }
            catch (RemoteException | InterruptedException throwable) {
                zzakn.zze("GoogleAuthUtil", new Object[]{"Error on service connection.", throwable});
                throw new IOException("Error on service connection.", throwable);
            }
            finally {
                zzae2.zzb(componentName, (ServiceConnection)zza2, "GoogleAuthUtil");
            }
        }
        throw new IOException("Could not bind to service.");
    }

    zzd() {
    }

    static /* synthetic */ Object zzm(Object object) throws IOException {
        return zzd.zzl(object);
    }

    static /* synthetic */ zzbga zzmp() {
        return zzakn;
    }

    static {
        String[] stringArray = new String[]{"GoogleAuthUtil"};
        zzakn = new zzbga("Auth", stringArray);
    }
}

