/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.support.annotation.RequiresPermission;
import android.text.TextUtils;
import com.google.android.gms.auth.AccountChangeEvent;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GooglePlayServicesAvailabilityException;
import com.google.android.gms.auth.TokenData;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.auth.zze;
import com.google.android.gms.auth.zzf;
import com.google.android.gms.auth.zzg;
import com.google.android.gms.auth.zzh;
import com.google.android.gms.auth.zzi;
import com.google.android.gms.auth.zzj;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzag;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.zza;
import com.google.android.gms.common.zzs;
import com.google.android.gms.internal.zzbhf;
import java.io.IOException;
import java.util.List;

@Hide
public class zzd {
    public static final String GOOGLE_ACCOUNT_TYPE = "com.google";
    @Hide
    public static final String WORK_ACCOUNT_TYPE = "com.google.work";
    @Hide
    private static String[] zzc = new String[]{"com.google", "com.google.work", "cn.google"};
    public static final String KEY_SUPPRESS_PROGRESS_SCREEN = "suppressProgressScreen";
    @Hide
    @SuppressLint(value={"InlinedApi"})
    public static final String zza = "callerUid";
    @Hide
    @SuppressLint(value={"InlinedApi"})
    public static final String zzb = "androidPackageName";
    public static final int CHANGE_TYPE_ACCOUNT_ADDED = 1;
    public static final int CHANGE_TYPE_ACCOUNT_REMOVED = 2;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_FROM = 3;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_TO = 4;
    private static final ComponentName zzd = new ComponentName("com.google.android.gms", "com.google.android.gms.auth.GetToken");
    private static final zzbhf zze;

    @Deprecated
    public static String getToken(Context context, String string, String string2) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        Account account = new Account(string, GOOGLE_ACCOUNT_TYPE);
        return com.google.android.gms.auth.zzd.getToken(context, account, string2);
    }

    @Deprecated
    public static String getToken(Context context, String string, String string2, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        Account account = new Account(string, GOOGLE_ACCOUNT_TYPE);
        return com.google.android.gms.auth.zzd.getToken(context, account, string2, bundle);
    }

    public static String getToken(Context context, Account account, String string) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return com.google.android.gms.auth.zzd.getToken(context, account, string, new Bundle());
    }

    public static String getToken(Context context, Account account, String string, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        com.google.android.gms.auth.zzd.zza(account);
        return com.google.android.gms.auth.zzd.zza(context, account, string, bundle).zza();
    }

    @Hide
    public static TokenData zza(Context context, Account account, String string, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        zzbq.zzc((String)"Calling this from your main thread can lead to deadlock");
        zzbq.zza((String)string, (Object)"Scope cannot be empty or null.");
        com.google.android.gms.auth.zzd.zza(account);
        com.google.android.gms.auth.zzd.zza(context);
        Bundle bundle2 = bundle == null ? new Bundle() : new Bundle(bundle);
        String string2 = context.getApplicationInfo().packageName;
        bundle2.putString("clientPackageName", string2);
        if (TextUtils.isEmpty((CharSequence)bundle2.getString(zzb))) {
            bundle2.putString(zzb, string2);
        }
        bundle2.putLong("service_connection_start_time_millis", SystemClock.elapsedRealtime());
        zze zze2 = new zze(account, string, bundle2);
        return com.google.android.gms.auth.zzd.zza(context, zzd, zze2);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.MANAGE_ACCOUNTS")
    public static void invalidateToken(Context context, String string) {
        AccountManager.get((Context)context).invalidateAuthToken(GOOGLE_ACCOUNT_TYPE, string);
    }

    public static void clearToken(Context context, String string) throws GooglePlayServicesAvailabilityException, GoogleAuthException, IOException {
        zzbq.zzc((String)"Calling this from your main thread can lead to deadlock");
        com.google.android.gms.auth.zzd.zza(context);
        Bundle bundle = new Bundle();
        String string2 = context.getApplicationInfo().packageName;
        bundle.putString("clientPackageName", string2);
        if (!bundle.containsKey(zzb)) {
            bundle.putString(zzb, string2);
        }
        zzf zzf2 = new zzf(string, bundle);
        com.google.android.gms.auth.zzd.zza(context, zzd, zzf2);
    }

    public static List<AccountChangeEvent> getAccountChangeEvents(Context context, int n, String string) throws GoogleAuthException, IOException {
        zzbq.zza((String)string, (Object)"accountName must be provided");
        zzbq.zzc((String)"Calling this from your main thread can lead to deadlock");
        com.google.android.gms.auth.zzd.zza(context);
        zzg zzg2 = new zzg(string, n);
        return com.google.android.gms.auth.zzd.zza(context, zzd, zzg2);
    }

    public static String getAccountId(Context context, String string) throws GoogleAuthException, IOException {
        zzbq.zza((String)string, (Object)"accountName must be provided");
        zzbq.zzc((String)"Calling this from your main thread can lead to deadlock");
        com.google.android.gms.auth.zzd.zza(context);
        return com.google.android.gms.auth.zzd.getToken(context, string, "^^_account_id_^^", new Bundle());
    }

    @Hide
    @TargetApi(value=23)
    public static Bundle removeAccount(Context context, Account account) throws GoogleAuthException, IOException {
        zzbq.zza((Object)context);
        com.google.android.gms.auth.zzd.zza(account);
        com.google.android.gms.auth.zzd.zza(context);
        zzh zzh2 = new zzh(account);
        return com.google.android.gms.auth.zzd.zza(context, zzd, zzh2);
    }

    @TargetApi(value=26)
    public static Boolean requestGoogleAccountsAccess(Context context) throws GoogleAuthException, IOException {
        zzbq.zza((Object)context);
        com.google.android.gms.auth.zzd.zza(context);
        String string = context.getApplicationInfo().packageName;
        zzi zzi2 = new zzi(string);
        return com.google.android.gms.auth.zzd.zza(context, zzd, zzi2);
    }

    private static void zza(Account account) {
        if (account == null) {
            throw new IllegalArgumentException("Account cannot be null");
        }
        if (TextUtils.isEmpty((CharSequence)account.name)) {
            throw new IllegalArgumentException("Account name cannot be empty!");
        }
        String[] stringArray = zzc;
        int n = zzc.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(account.type)) continue;
            return;
        }
        throw new IllegalArgumentException("Account type not supported");
    }

    private static void zza(Context context) throws GoogleAuthException {
        try {
            zzs.zza((Context)context.getApplicationContext());
            return;
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            throw new GooglePlayServicesAvailabilityException(googlePlayServicesRepairableException.getConnectionStatusCode(), googlePlayServicesRepairableException.getMessage(), googlePlayServicesRepairableException.getIntent());
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            throw new GoogleAuthException(googlePlayServicesNotAvailableException.getMessage());
        }
    }

    private static <T> T zzb(T t) throws IOException {
        if (t == null) {
            zze.zzd("GoogleAuthUtil", new Object[]{"Binder call returned null."});
            throw new IOException("Service unavailable.");
        }
        return t;
    }

    private static <T> T zza(Context context, ComponentName componentName, zzj<T> zzj2) throws IOException, GoogleAuthException {
        zza zza2 = new zza();
        zzag zzag2 = zzag.zza((Context)context);
        if (zzag2.zza(componentName, (ServiceConnection)zza2, "GoogleAuthUtil")) {
            try {
                T t = zzj2.zza(zza2.zza());
                return t;
            }
            catch (RemoteException | InterruptedException throwable) {
                zze.zzc("GoogleAuthUtil", new Object[]{"Error on service connection.", throwable});
                throw new IOException("Error on service connection.", throwable);
            }
            finally {
                zzag2.zzb(componentName, (ServiceConnection)zza2, "GoogleAuthUtil");
            }
        }
        throw new IOException("Could not bind to service.");
    }

    zzd() {
    }

    static /* synthetic */ Object zza(Object object) throws IOException {
        return com.google.android.gms.auth.zzd.zzb(object);
    }

    static /* synthetic */ zzbhf zza() {
        return zze;
    }

    static {
        String[] stringArray = new String[]{"GoogleAuthUtil"};
        zze = new zzbhf("Auth", stringArray);
    }
}

