/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.zzn;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.List;

@SafeParcelable.Class(creator="TokenDataCreator")
public class TokenData
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<TokenData> CREATOR = new zzn();
    @SafeParcelable.VersionField(id=1)
    private final int zzy;
    @SafeParcelable.Field(id=2, getter="getToken")
    private final String zzz;
    @SafeParcelable.Field(id=3, getter="getExpirationTimeSecs")
    private final Long zzaa;
    @SafeParcelable.Field(id=4, getter="isCached")
    private final boolean zzab;
    @SafeParcelable.Field(id=5, getter="isSnowballed")
    private final boolean zzac;
    @SafeParcelable.Field(id=6, getter="getGrantedScopes")
    private final List<String> zzad;

    @Nullable
    public static TokenData zzd(Bundle bundle, String string) {
        bundle.setClassLoader(TokenData.class.getClassLoader());
        Bundle bundle2 = bundle.getBundle(string);
        if (bundle2 == null) {
            return null;
        }
        bundle2.setClassLoader(TokenData.class.getClassLoader());
        return (TokenData)bundle2.getParcelable("TokenData");
    }

    @SafeParcelable.Constructor
    TokenData(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) Long l, @SafeParcelable.Param(id=4) boolean bl, @SafeParcelable.Param(id=5) boolean bl2, @SafeParcelable.Param(id=6) List<String> list) {
        this.zzy = n;
        this.zzz = Preconditions.checkNotEmpty((String)string);
        this.zzaa = l;
        this.zzab = bl;
        this.zzac = bl2;
        this.zzad = list;
    }

    public final String zze() {
        return this.zzz;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TokenData)) {
            return false;
        }
        TokenData tokenData = (TokenData)((Object)object);
        return TextUtils.equals((CharSequence)this.zzz, (CharSequence)tokenData.zzz) && Objects.equal((Object)this.zzaa, (Object)tokenData.zzaa) && this.zzab == tokenData.zzab && this.zzac == tokenData.zzac && Objects.equal(this.zzad, tokenData.zzad);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzz, this.zzaa, this.zzab, this.zzac, this.zzad});
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        TokenData tokenData = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)tokenData.zzy);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)tokenData.zzz, (boolean)false);
        SafeParcelWriter.writeLongObject((Parcel)parcel2, (int)3, (Long)tokenData.zzaa, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)4, (boolean)tokenData.zzab);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)5, (boolean)tokenData.zzac);
        SafeParcelWriter.writeStringList((Parcel)parcel2, (int)6, tokenData.zzad, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

