/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.accounttransfer;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.auth.api.accounttransfer.AccountTransferException;
import com.google.android.gms.auth.api.accounttransfer.DeviceMetaData;
import com.google.android.gms.auth.api.accounttransfer.zzg;
import com.google.android.gms.auth.api.accounttransfer.zzh;
import com.google.android.gms.auth.api.accounttransfer.zzj;
import com.google.android.gms.auth.api.accounttransfer.zzl;
import com.google.android.gms.auth.api.accounttransfer.zzm;
import com.google.android.gms.auth.api.accounttransfer.zzn;
import com.google.android.gms.auth.api.accounttransfer.zzq;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.ApiExceptionMapper;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.auth.zzab;
import com.google.android.gms.internal.auth.zzac;
import com.google.android.gms.internal.auth.zzae;
import com.google.android.gms.internal.auth.zzag;
import com.google.android.gms.internal.auth.zzai;
import com.google.android.gms.internal.auth.zzak;
import com.google.android.gms.internal.auth.zzv;
import com.google.android.gms.internal.auth.zzx;
import com.google.android.gms.internal.auth.zzy;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;

public class AccountTransferClient
extends GoogleApi<zzq> {
    private static final Api.ClientKey<zzx> zzau = new Api.ClientKey();
    private static final Api.AbstractClientBuilder<zzx, zzq> zzav = new com.google.android.gms.auth.api.accounttransfer.zzf();
    private static final Api<zzq> zzaw = new Api("AccountTransfer.ACCOUNT_TRANSFER_API", zzav, zzau);

    AccountTransferClient(@NonNull Context context) {
        super(context, zzaw, null, new GoogleApi.Settings.Builder().setMapper((StatusExceptionMapper)new ApiExceptionMapper()).build());
    }

    AccountTransferClient(@NonNull Activity activity) {
        super(activity, zzaw, null, new GoogleApi.Settings.Builder().setMapper((StatusExceptionMapper)new ApiExceptionMapper()).build());
    }

    public Task<Void> sendData(String string, byte[] byArray) {
        Preconditions.checkNotNull((Object)string);
        Preconditions.checkNotNull((Object)byArray);
        zzai zzai2 = new zzai(string, byArray);
        return this.doWrite(new zzg(this, zzai2));
    }

    public Task<byte[]> retrieveData(String string) {
        Preconditions.checkNotNull((Object)string);
        zzag zzag2 = new zzag(string);
        return this.doRead(new zzh(this, zzag2));
    }

    public Task<DeviceMetaData> getDeviceMetaData(String string) {
        Preconditions.checkNotNull((Object)string);
        zzy zzy2 = new zzy(string);
        return this.doRead(new zzj(this, zzy2));
    }

    public Task<Void> showUserChallenge(String string, PendingIntent pendingIntent) {
        Preconditions.checkNotNull((Object)string);
        Preconditions.checkNotNull((Object)pendingIntent);
        zzak zzak2 = new zzak(string, pendingIntent);
        return this.doWrite(new zzl(this, zzak2));
    }

    public Task<Void> notifyCompletion(String string, int n) {
        Preconditions.checkNotNull((Object)string);
        zzae zzae2 = new zzae(string, n);
        return this.doWrite(new zzm(this, zzae2));
    }

    private static void zzd(TaskCompletionSource taskCompletionSource, Status status) {
        taskCompletionSource.setException((Exception)((Object)new AccountTransferException(status)));
    }

    private static abstract class zze<T>
    extends TaskApiCall<zzx, T> {
        private TaskCompletionSource<T> zzbh;

        private zze() {
        }

        protected final void setResult(T t) {
            this.zzbh.setResult(t);
        }

        protected final void zzd(Status status) {
            AccountTransferClient.zzd(this.zzbh, status);
        }

        protected abstract void zzd(zzac var1) throws RemoteException;

        protected /* synthetic */ void doExecute(Api.AnyClient anyClient, TaskCompletionSource taskCompletionSource) throws RemoteException {
            TaskCompletionSource taskCompletionSource2 = taskCompletionSource;
            zzx zzx2 = (zzx)anyClient;
            zze zze2 = this;
            this.zzbh = taskCompletionSource2;
            zze2.zzd((zzac)zzx2.getService());
        }

        /* synthetic */ zze(com.google.android.gms.auth.api.accounttransfer.zzf zzf2) {
            this();
        }
    }

    private static abstract class zzf
    extends zze<Void> {
        zzab zzbi = new zzn(this);

        private zzf() {
            super(null);
        }

        /* synthetic */ zzf(com.google.android.gms.auth.api.accounttransfer.zzf zzf2) {
            this();
        }
    }

    private static class zzd<T>
    extends zzv {
        private zze<T> zzbg;

        public zzd(zze<T> zze2) {
            this.zzbg = zze2;
        }

        @Override
        public final void onFailure(Status status) {
            this.zzbg.zzd(status);
        }
    }
}

