/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.zzk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.List;

@SafeParcelable.Class(creator="TokenDataCreator")
public class TokenData
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<TokenData> CREATOR = new zzk();
    @SafeParcelable.VersionField(id=1)
    private final int zzv;
    @SafeParcelable.Field(id=2, getter="getToken")
    private final String zzw;
    @SafeParcelable.Field(id=3, getter="getExpirationTimeSecs")
    private final Long zzx;
    @SafeParcelable.Field(id=4, getter="isCached")
    private final boolean zzy;
    @SafeParcelable.Field(id=5, getter="isSnowballed")
    private final boolean zzz;
    @SafeParcelable.Field(id=6, getter="getGrantedScopes")
    private final List<String> zzaa;
    @SafeParcelable.Field(id=7, getter="getScopeData")
    private final String zzab;

    @Nullable
    public static TokenData zza(Bundle bundle, String string) {
        bundle.setClassLoader(TokenData.class.getClassLoader());
        Bundle bundle2 = bundle.getBundle(string);
        if (bundle2 == null) {
            return null;
        }
        bundle2.setClassLoader(TokenData.class.getClassLoader());
        return (TokenData)bundle2.getParcelable("TokenData");
    }

    @SafeParcelable.Constructor
    TokenData(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) Long l, @SafeParcelable.Param(id=4) boolean bl, @SafeParcelable.Param(id=5) boolean bl2, @SafeParcelable.Param(id=6) List<String> list, @SafeParcelable.Param(id=7) String string2) {
        this.zzv = n;
        this.zzw = Preconditions.checkNotEmpty((String)string);
        this.zzx = l;
        this.zzy = bl;
        this.zzz = bl2;
        this.zzaa = list;
        this.zzab = string2;
    }

    public final String zzb() {
        return this.zzw;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TokenData)) {
            return false;
        }
        TokenData tokenData = (TokenData)((Object)object);
        return TextUtils.equals((CharSequence)this.zzw, (CharSequence)tokenData.zzw) && Objects.equal((Object)this.zzx, (Object)tokenData.zzx) && this.zzy == tokenData.zzy && this.zzz == tokenData.zzz && Objects.equal(this.zzaa, tokenData.zzaa) && Objects.equal((Object)this.zzab, (Object)tokenData.zzab);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzw, this.zzx, this.zzy, this.zzz, this.zzaa, this.zzab});
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        TokenData tokenData = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1, (int)tokenData.zzv);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)tokenData.zzw, (boolean)false);
        SafeParcelWriter.writeLongObject((Parcel)parcel2, (int)3, (Long)tokenData.zzx, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)4, (boolean)tokenData.zzy);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)5, (boolean)tokenData.zzz);
        SafeParcelWriter.writeStringList((Parcel)parcel2, (int)6, tokenData.zzaa, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)tokenData.zzab, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

