/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.proxy;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Patterns;
import androidx.annotation.NonNull;
import com.google.android.gms.auth.api.proxy.zza;
import com.google.android.gms.common.annotation.KeepForSdkWithMembers;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@ShowFirstParty
@SafeParcelable.Class(creator="ProxyRequestCreator")
@KeepForSdkWithMembers
public class ProxyRequest
extends AbstractSafeParcelable {
    public static final int VERSION_CODE = 2;
    @NonNull
    public static final Parcelable.Creator<ProxyRequest> CREATOR;
    public static final int HTTP_METHOD_GET;
    public static final int HTTP_METHOD_POST;
    public static final int HTTP_METHOD_PUT;
    public static final int HTTP_METHOD_DELETE;
    public static final int HTTP_METHOD_HEAD;
    public static final int HTTP_METHOD_OPTIONS;
    public static final int HTTP_METHOD_TRACE;
    public static final int HTTP_METHOD_PATCH;
    public static final int LAST_CODE;
    @SafeParcelable.Field(id=1)
    @NonNull
    public final String url;
    @SafeParcelable.Field(id=2)
    public final int httpMethod;
    @SafeParcelable.Field(id=3)
    public final long timeoutMillis;
    @SafeParcelable.Field(id=4)
    @NonNull
    public final byte[] body;
    @SafeParcelable.VersionField(id=1000)
    final int zza;
    @SafeParcelable.Field(id=5)
    Bundle zzb;

    @NonNull
    public String toString() {
        String string = this.url;
        int n = this.httpMethod;
        String string2 = String.valueOf(string);
        int n2 = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n2 + 42);
        stringBuilder.append("ProxyRequest[ url: ");
        stringBuilder.append(string);
        stringBuilder.append(", method: ");
        stringBuilder.append(n);
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }

    @NonNull
    public Map<String, String> getHeaderMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(this.zzb.size());
        for (String string : this.zzb.keySet()) {
            String string2 = this.zzb.getString(string);
            if (string2 == null) {
                string2 = "";
            }
            linkedHashMap.put(string, string2);
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    static {
        zza zza2;
        CREATOR = zza2 = new zza();
        HTTP_METHOD_GET = 0;
        HTTP_METHOD_POST = 1;
        HTTP_METHOD_PUT = 2;
        HTTP_METHOD_DELETE = 3;
        HTTP_METHOD_HEAD = 4;
        HTTP_METHOD_OPTIONS = 5;
        HTTP_METHOD_TRACE = 6;
        HTTP_METHOD_PATCH = 7;
        LAST_CODE = 7;
    }

    @SafeParcelable.Constructor
    ProxyRequest(@SafeParcelable.Param(id=1000) int n, @SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=2) int n2, @SafeParcelable.Param(id=3) long l, @SafeParcelable.Param(id=4) byte[] byArray, @SafeParcelable.Param(id=5) Bundle bundle) {
        this.zza = n;
        this.url = string;
        this.httpMethod = n2;
        this.timeoutMillis = l;
        this.body = byArray;
        this.zzb = bundle;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel parcel, int n) {
        void var1_1;
        n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)1, (String)this.url, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.httpMethod);
        SafeParcelWriter.writeLong((Parcel)var1_1, (int)3, (long)this.timeoutMillis);
        SafeParcelWriter.writeByteArray((Parcel)var1_1, (int)4, (byte[])this.body, (boolean)false);
        SafeParcelWriter.writeBundle((Parcel)var1_1, (int)5, (Bundle)this.zzb, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)1000, (int)this.zza);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    @ShowFirstParty
    @KeepForSdkWithMembers
    public static class Builder {
        private final String zza;
        private int zzb = HTTP_METHOD_GET;
        private long zzc = 3000L;
        private byte[] zzd = new byte[0];
        private final Bundle zze;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder putHeader(@NonNull String name, @NonNull String value) {
            void var1_1;
            String string;
            Preconditions.checkNotEmpty((String)name, (Object)"Header name cannot be null or empty!");
            Bundle bundle = this.zze;
            if (string == null) {
                string = "";
            }
            bundle.putString((String)var1_1, string);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setBody(@NonNull byte[] body) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setHttpMethod(int method) {
            void var1_1;
            boolean bl = method >= 0 ? var1_1 <= LAST_CODE : false;
            Preconditions.checkArgument((boolean)bl, (Object)"Unrecognized http method code.");
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder setTimeoutMillis(long timeoutMillis) {
            void var1_1;
            boolean bl = timeoutMillis >= 0L;
            Preconditions.checkArgument((boolean)bl, (Object)"The specified timeout must be non-negative.");
            this.zzc = var1_1;
            return this;
        }

        @NonNull
        public ProxyRequest build() {
            if (this.zzd == null) {
                this.zzd = new byte[0];
            }
            ProxyRequest proxyRequest = new ProxyRequest(2, this.zza, this.zzb, this.zzc, this.zzd, this.zze);
            return proxyRequest;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NonNull String url) {
            void var1_1;
            Object object = new Bundle();
            ((Builder)this_).zze = object;
            Preconditions.checkNotEmpty((String)var1_1);
            if (!Patterns.WEB_URL.matcher((CharSequence)var1_1).matches()) {
                object = String.valueOf(var1_1);
                int n = ((String)object).length();
                StringBuilder stringBuilder = new StringBuilder(n + 51);
                stringBuilder.append("The supplied url [ ");
                stringBuilder.append((String)var1_1);
                stringBuilder.append("] is not match Patterns.WEB_URL!");
                Object this_ = new IllegalArgumentException(stringBuilder.toString());
                throw this_;
            }
            ((Builder)this_).zza = var1_1;
        }
    }
}

