/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.auth.AccountChangeEvent;
import com.google.android.gms.auth.AccountChangeEventsRequest;
import com.google.android.gms.auth.AccountChangeEventsResponse;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GooglePlayServicesAvailabilityException;
import com.google.android.gms.auth.TokenData;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.auth.zzd;
import com.google.android.gms.auth.zzf;
import com.google.android.gms.auth.zzg;
import com.google.android.gms.auth.zzi;
import com.google.android.gms.auth.zzj;
import com.google.android.gms.auth.zzk;
import com.google.android.gms.common.BlockingServiceConnection;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesIncorrectManifestValueException;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.logging.Logger;
import com.google.android.gms.internal.auth.zzbw;
import com.google.android.gms.internal.auth.zzby;
import com.google.android.gms.internal.auth.zzcz;
import com.google.android.gms.internal.auth.zze;
import com.google.android.gms.internal.auth.zzh;
import com.google.android.gms.internal.auth.zzhj;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;

@ShowFirstParty
public class zzl {
    public static final String GOOGLE_ACCOUNT_TYPE = "com.google";
    @ShowFirstParty
    public static final String WORK_ACCOUNT_TYPE = "com.google.work";
    @ShowFirstParty
    public static final String[] zza;
    public static final String KEY_SUPPRESS_PROGRESS_SCREEN = "suppressProgressScreen";
    @SuppressLint(value={"InlinedApi"})
    @ShowFirstParty
    public static final String zzb;
    public static final int CHANGE_TYPE_ACCOUNT_ADDED = 1;
    public static final int CHANGE_TYPE_ACCOUNT_REMOVED = 2;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_FROM = 3;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_TO = 4;
    private static final ComponentName zzc;
    private static final Logger zzd;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=23)
    @ShowFirstParty
    public static Bundle removeAccount(Context context, Account account) throws GoogleAuthException, IOException {
        Context context2;
        void var1_1;
        Preconditions.checkNotNull((Object)context);
        zzl.zzl((Account)var1_1);
        zzl.zzj(context2, 8400000);
        zzcz.zze(context2);
        if (zzhj.zze() && zzl.zzm(context2)) {
            Bundle bundle = zzh.zza(context2).zzd((Account)var1_1);
            String string = "account removal";
            try {
                bundle = zzl.zzh(bundle, string);
                zzl.zzi(bundle);
                return bundle;
            }
            catch (ApiException apiException) {
                zzl.zzk(apiException, string);
            }
        }
        zzf zzf2 = new zzf((Account)var1_1);
        return (Bundle)zzl.zzg(context2, zzc, zzf2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static TokenData zzf(Bundle object) throws GoogleAuthException, IOException {
        void var1_6;
        Bundle bundle;
        ClassLoader classLoader = TokenData.class.getClassLoader();
        if (classLoader != null) {
            object.setClassLoader(classLoader);
        }
        if ((bundle = object.getBundle("tokenDetails")) == null) {
            Object var1_5 = null;
        } else {
            if (classLoader != null) {
                bundle.setClassLoader(classLoader);
            }
            TokenData tokenData = (TokenData)bundle.getParcelable("TokenData");
        }
        if (var1_6 != null) {
            return var1_6;
        }
        String string = object.getString("Error");
        Intent intent = (Intent)object.getParcelable("userRecoveryIntent");
        zzby zzby2 = zzby.zza(string);
        if (zzby.zzb(zzby2)) {
            Logger logger = zzd;
            Object[] objectArray = new Object[1];
            String string2 = String.valueOf((Object)zzby2);
            String string3 = String.valueOf(string2);
            int n = string3.length();
            StringBuilder stringBuilder = new StringBuilder(n + 31);
            stringBuilder.append("isUserRecoverableError status: ");
            stringBuilder.append(string2);
            objectArray[0] = stringBuilder.toString();
            logger.w("GoogleAuthUtil", objectArray);
            UserRecoverableAuthException userRecoverableAuthException = new UserRecoverableAuthException(string, intent);
            throw userRecoverableAuthException;
        }
        if (!(zzby.zze.equals((Object)zzby2) || zzby.zzf.equals((Object)zzby2) || zzby.zzg.equals((Object)zzby2) || zzby.zzae.equals((Object)zzby2))) {
            GoogleAuthException googleAuthException = new GoogleAuthException(string);
            throw googleAuthException;
        }
        IOException iOException = new IOException(string);
        throw iOException;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TokenData zza(Context context, Account account, String string, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        Bundle bundle2;
        Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
        Preconditions.checkNotEmpty((String)string, (Object)"Scope cannot be empty or null.");
        zzl.zzl(account);
        zzl.zzj(context, 8400000);
        bundle = bundle == null ? new Bundle() : (bundle2 = new Bundle(bundle));
        String string2 = context.getApplicationInfo().packageName;
        bundle.putString("clientPackageName", string2);
        if (TextUtils.isEmpty((CharSequence)bundle.getString(zzb))) {
            bundle.putString(zzb, string2);
        }
        bundle.putLong("service_connection_start_time_millis", SystemClock.elapsedRealtime());
        zzcz.zze(context);
        if (zzhj.zze() && zzl.zzm(context)) {
            Task<Bundle> task = zzh.zza(context).zzc(account, string, bundle);
            String string3 = "token retrieval";
            try {
                Bundle bundle3 = zzl.zzh(task, string3);
                zzl.zzi(bundle3);
                return zzl.zzf(bundle3);
            }
            catch (ApiException apiException) {
                zzl.zzk(apiException, string3);
            }
        }
        zzg zzg2 = new zzg(account, string, bundle);
        return (TokenData)((Object)zzl.zzg(context, zzc, zzg2));
    }

    static /* synthetic */ TokenData zzb(Account object, String string, Bundle bundle, IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
        object = zze.zzb(iBinder).zze((Account)object, string, bundle);
        if (object == null) {
            object = new IOException("Service call returned null");
            throw object;
        }
        return zzl.zzf((Bundle)object);
    }

    static /* synthetic */ Logger zzc() {
        return zzd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=26)
    public static Boolean requestGoogleAccountsAccess(Context context) throws GoogleAuthException, IOException {
        String string;
        Object object;
        block7: {
            Context context2;
            Preconditions.checkNotNull((Object)context);
            zzl.zzj(context2, 11400000);
            String string2 = context2.getApplicationInfo().packageName;
            zzcz.zze(context2);
            if (zzhj.zze() && zzl.zzm(context2)) {
                object = zzh.zza(context2).zze(string2);
                String string3 = "google accounts access request";
                try {
                    object = zzl.zzh(object, string3);
                    string = object.getString("Error");
                    object = (Intent)object.getParcelable("userRecoveryIntent");
                    Object object2 = zzby.zza(string);
                    boolean bl = zzby.zzc.equals(object2);
                    if (bl) {
                        return true;
                    }
                    bl = zzby.zzb(object2);
                    if (bl) {
                        Logger logger = zzd;
                        String string4 = "GoogleAuthUtil";
                        Object[] objectArray = new Object[1];
                        object2 = String.valueOf(object2);
                        int n = String.valueOf(object2).length();
                        StringBuilder stringBuilder = new StringBuilder(n += 31);
                        stringBuilder.append("isUserRecoverableError status: ");
                        stringBuilder.append((String)object2);
                        objectArray[0] = stringBuilder.toString();
                        logger.w(string4, objectArray);
                        object2 = new UserRecoverableAuthException(string, (Intent)object);
                        throw object2;
                    }
                    break block7;
                }
                catch (ApiException apiException) {
                    zzl.zzk(apiException, string3);
                }
            }
            zzj zzj2 = new zzj(string2);
            return zzl.zzg(context2, zzc, zzj2);
        }
        object = new GoogleAuthException(string);
        throw object;
    }

    static /* synthetic */ Object zzd(Object object) throws IOException {
        zzl.zzi(object);
        return object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T zzg(Context var0, ComponentName var1_2, zzk<T> var2_3) throws IOException, GoogleAuthException {
        block6: {
            block7: {
                var3_6 = new BlockingServiceConnection();
                var0 /* !! */  = GmsClientSupervisor.getInstance((Context)var0 /* !! */ );
                try {
                    var4_7 = var0 /* !! */ .bindService((ComponentName)var1_2 /* !! */ , (ServiceConnection)var3_6, "GoogleAuthUtil");
                    if (!var4_7) break block6;
                }
                catch (SecurityException var0_1) {
                    var1_2 /* !! */  = new Object[]{var0_1.getMessage()};
                    Log.w((String)"GoogleAuthUtil", (String)String.format("SecurityException while bind to auth service: %s", var1_2 /* !! */ ));
                    var1_2 /* !! */  = new IOException("SecurityException while binding to Auth service.", var0_1);
                    throw var1_2 /* !! */ ;
                }
                ** try [egrp 1[TRYBLOCK] [3, 1, 2 : 28->39)] { 
lbl13:
                // 1 sources

                break block7;
lbl14:
                // 1 sources

                catch (Throwable var2_4) {
                    var0 /* !! */ .unbindService((ComponentName)var1_2 /* !! */ , (ServiceConnection)var3_6, "GoogleAuthUtil");
                    throw var2_4;
                }
lbl17:
                // 2 sources

                catch (RemoteException | InterruptedException var2_5) {
                    ** GOTO lbl-1000
                }
            }
            var2_3 /* !! */  = var2_3 /* !! */ .zza(var3_6.getService());
            var0 /* !! */ .unbindService((ComponentName)var1_2 /* !! */ , (ServiceConnection)var3_6, "GoogleAuthUtil");
            return (T)var2_3 /* !! */ ;
        }
        var0 /* !! */  = new IOException("Could not bind to service.");
        throw var0 /* !! */ ;
lbl-1000:
        // 1 sources

        {
            Log.i((String)"GoogleAuthUtil", (String)"Error on service connection.", (Throwable)var2_5);
            var4_8 = new IOException("Error on service connection.", var2_5);
            throw var4_8;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <ResultT> ResultT zzh(Task<ResultT> object, String string) throws IOException, ApiException {
        String string2;
        try {
            Object object2 = Tasks.await(object);
            return (ResultT)object2;
        }
        catch (InterruptedException interruptedException) {
            Object[] objectArray = new Object[]{string2};
            string2 = String.format("Interrupted while waiting for the task of %s to finish.", objectArray);
            zzd.w(string2, new Object[0]);
            IOException iOException = new IOException(string2, interruptedException);
            throw iOException;
        }
        catch (CancellationException cancellationException) {
            Object[] objectArray = new Object[]{string2};
            string2 = String.format("Canceled while waiting for the task of %s to finish.", objectArray);
            zzd.w(string2, new Object[0]);
            IOException iOException = new IOException(string2, cancellationException);
            throw iOException;
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof ApiException) {
                throw (ApiException)throwable;
            }
        }
        Object[] objectArray = new Object[]{string2};
        string2 = String.format("Unable to get a result for %s due to ExecutionException.", objectArray);
        zzd.w(string2, new Object[0]);
        IOException iOException = new IOException(string2, executionException);
        throw iOException;
    }

    private static <T> T zzi(T object) throws IOException {
        if (object == null) {
            zzd.w("Service call returned null.", new Object[0]);
            object = new Object("Service unavailable.");
            throw object;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static String getAccountId(Context ctx, String accountName) throws GoogleAuthException, IOException {
        void var1_1;
        Context context;
        Preconditions.checkNotEmpty((String)accountName, (Object)"accountName must be provided");
        Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
        zzl.zzj(context, 8400000);
        Bundle bundle = new Bundle();
        return zzl.getToken(context, (String)var1_1, "^^_account_id_^^", bundle);
    }

    /*
     * WARNING - void declaration
     */
    public static String getToken(Context context, Account account, String scope) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        void var2_2;
        void var1_1;
        Context context2;
        Bundle bundle = new Bundle();
        return zzl.getToken(context2, (Account)var1_1, (String)var2_2, bundle);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String getToken(Context context, String accountName, String scope) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        void var2_2;
        Context context2;
        void var1_1;
        Account account = new Account((String)var1_1, GOOGLE_ACCOUNT_TYPE);
        return zzl.getToken(context2, account, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String getToken(Context context, Account account, String scope, Bundle extras) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        void var3_3;
        void var2_2;
        void var1_1;
        Context context2;
        zzl.zzl(account);
        return zzl.zza(context2, (Account)var1_1, (String)var2_2, (Bundle)var3_3).zza();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String getToken(Context context, String accountName, String scope, Bundle extras) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        void var3_3;
        void var2_2;
        Context context2;
        void var1_1;
        Account account = new Account((String)var1_1, GOOGLE_ACCOUNT_TYPE);
        return zzl.getToken(context2, account, (String)var2_2, (Bundle)var3_3);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<AccountChangeEvent> getAccountChangeEvents(Context context, int eventIndex, String accountName) throws GoogleAuthException, IOException {
        void var1_1;
        String string;
        Context context2;
        Preconditions.checkNotEmpty((String)accountName, (Object)"accountName must be provided");
        Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
        zzl.zzj(context2, 8400000);
        AccountChangeEventsRequest accountChangeEventsRequest = new AccountChangeEventsRequest();
        accountChangeEventsRequest.setAccountName(string);
        accountChangeEventsRequest.setEventIndex((int)var1_1);
        zzcz.zze(context2);
        if (zzhj.zzd() && zzl.zzm(context2)) {
            Object object = zzh.zza(context2).zzb(accountChangeEventsRequest);
            string = "account change events retrieval";
            try {
                object = zzl.zzh(object, string);
                zzl.zzi(object);
                return ((AccountChangeEventsResponse)((Object)object)).getEvents();
            }
            catch (ApiException apiException) {
                zzl.zzk(apiException, string);
            }
        }
        zzi zzi2 = new zzi(accountChangeEventsRequest);
        return zzl.zzg(context2, zzc, zzi2);
    }

    static {
        String[] stringArray = new String[]{GOOGLE_ACCOUNT_TYPE, WORK_ACCOUNT_TYPE, "cn.google"};
        zza = stringArray;
        zzb = "androidPackageName";
        stringArray = new ComponentName("com.google.android.gms", "com.google.android.gms.auth.GetToken");
        zzc = stringArray;
        stringArray = new String[]{"GoogleAuthUtil"};
        zzd = com.google.android.gms.auth.zzd.zza(stringArray);
    }

    zzl() {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void clearToken(Context context, String token) throws GooglePlayServicesAvailabilityException, GoogleAuthException, IOException {
        void var1_1;
        Context context2;
        Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
        zzl.zzj(context2, 8400000);
        Bundle bundle = new Bundle();
        Task<Void> task = context2.getApplicationInfo().packageName;
        bundle.putString("clientPackageName", (String)task);
        if (!bundle.containsKey(zzb)) {
            bundle.putString(zzb, (String)task);
        }
        zzcz.zze(context2);
        if (zzhj.zze() && zzl.zzm(context2)) {
            task = zzh.zza(context2);
            zzbw zzbw2 = new zzbw();
            zzbw2.zza((String)var1_1);
            task = task.zza(zzbw2);
            String string = "clear token";
            try {
                zzl.zzh(task, string);
                return;
            }
            catch (ApiException apiException) {
                zzl.zzk(apiException, string);
            }
        }
        task = new Task<Void>((String)var1_1, bundle);
        zzl.zzg(context2, zzc, task);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void zzj(Context context, int n) throws GoogleAuthException {
        try {
            GooglePlayServicesUtilLight.ensurePlayServicesAvailable((Context)context.getApplicationContext(), (int)n);
            return;
        }
        catch (GooglePlayServicesIncorrectManifestValueException | GooglePlayServicesNotAvailableException throwable) {
            GoogleAuthException googleAuthException = new GoogleAuthException(throwable.getMessage(), throwable);
            throw googleAuthException;
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            GooglePlayServicesAvailabilityException googlePlayServicesAvailabilityException = new GooglePlayServicesAvailabilityException(googlePlayServicesRepairableException.getConnectionStatusCode(), googlePlayServicesRepairableException.getMessage(), googlePlayServicesRepairableException.getIntent());
            throw googlePlayServicesAvailabilityException;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @RequiresPermission(value="android.permission.MANAGE_ACCOUNTS")
    public static void invalidateToken(Context context, String token) {
        void var1_1;
        AccountManager.get((Context)context).invalidateAuthToken(GOOGLE_ACCOUNT_TYPE, (String)var1_1);
    }

    private static void zzk(ApiException apiException, String string) {
        Logger logger = zzd;
        Object[] objectArray = new Object[]{string, Log.getStackTraceString((Throwable)apiException)};
        logger.w("%s failed via GoogleAuthServiceClient, falling back to previous approach:\n%s", objectArray);
    }

    private static void zzl(Account object) {
        if (object == null) {
            object = new IllegalArgumentException("Account cannot be null");
            throw object;
        }
        if (TextUtils.isEmpty((CharSequence)object.name)) {
            object = new IllegalArgumentException("Account name cannot be empty!");
            throw object;
        }
        String[] stringArray = zza;
        int n = 0;
        while (true) {
            if (n < 3) {
                if (stringArray[n].equals(object.type)) {
                    return;
                }
            } else {
                object = new IllegalArgumentException("Account type not supported");
                throw object;
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void zze(Intent object) {
        if (object == null) {
            object = new IllegalArgumentException("Callback cannot be null.");
            throw object;
        }
        object = object.toUri(1);
        try {
            Intent.parseUri((String)object, (int)1);
            return;
        }
        catch (URISyntaxException uRISyntaxException) {
            object = new IllegalArgumentException("Parameter callback contains invalid data. It must be serializable using toUri() and parseUri().");
            throw object;
        }
    }

    private static boolean zzm(Context object) {
        if (GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(object, 17895000) != 0) {
            return false;
        }
        object = object.getApplicationInfo().packageName;
        Iterator<String> iterator = zzhj.zzb().zzm().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(object)) continue;
            return false;
        }
        return true;
    }
}

