/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.auth.AccountChangeEvent;
import com.google.android.gms.auth.AccountChangeEventsRequest;
import com.google.android.gms.auth.AccountChangeEventsResponse;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GooglePlayServicesAvailabilityException;
import com.google.android.gms.auth.TokenData;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.auth.zzd;
import com.google.android.gms.auth.zzf;
import com.google.android.gms.auth.zzg;
import com.google.android.gms.auth.zzh;
import com.google.android.gms.auth.zzi;
import com.google.android.gms.auth.zzj;
import com.google.android.gms.auth.zzk;
import com.google.android.gms.common.BlockingServiceConnection;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesIncorrectManifestValueException;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.logging.Logger;
import com.google.android.gms.internal.auth.zzbw;
import com.google.android.gms.internal.auth.zzby;
import com.google.android.gms.internal.auth.zzdc;
import com.google.android.gms.internal.auth.zze;
import com.google.android.gms.internal.auth.zzht;
import com.google.android.gms.internal.auth.zzhw;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;

@ShowFirstParty
public class zzl {
    public static final String GOOGLE_ACCOUNT_TYPE = "com.google";
    @ShowFirstParty
    public static final String WORK_ACCOUNT_TYPE = "com.google.work";
    @ShowFirstParty
    public static final String[] zza;
    public static final String KEY_SUPPRESS_PROGRESS_SCREEN = "suppressProgressScreen";
    @SuppressLint(value={"InlinedApi"})
    @ShowFirstParty
    public static final String zzb;
    public static final int CHANGE_TYPE_ACCOUNT_ADDED = 1;
    public static final int CHANGE_TYPE_ACCOUNT_REMOVED = 2;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_FROM = 3;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_TO = 4;
    private static final ComponentName zzc;
    private static final Logger zzd;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=23)
    @ShowFirstParty
    public static Bundle removeAccount(Context context, Account account) throws GoogleAuthException, IOException {
        zzf zzf2;
        Context context2;
        void var1_1;
        Preconditions.checkNotNull((Object)context);
        zzl.zzo((Account)var1_1);
        zzl.zzk(context2, 8400000);
        zzdc.zzd(context2);
        if (zzhw.zze() && zzl.zzp(context2)) {
            zzf2 = com.google.android.gms.internal.auth.zzh.zza(context2).zzd((Account)var1_1);
            String string = "account removal";
            try {
                zzf2 = (Bundle)zzl.zzi((Task)zzf2, string);
                zzl.zzj(zzf2);
                return zzf2;
            }
            catch (ApiException apiException) {
                zzl.zzl(apiException, string);
            }
        }
        zzf2 = new zzf((Account)var1_1);
        return (Bundle)zzl.zzh(context2, zzc, zzf2, 0L, null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static TokenData zzg(Context context, String object, Bundle bundle) throws GoogleAuthException, IOException {
        void var1_4;
        Bundle bundle2;
        PendingIntent pendingIntent;
        ClassLoader classLoader = TokenData.class.getClassLoader();
        if (classLoader != null) {
            pendingIntent.setClassLoader(classLoader);
        }
        if ((bundle2 = pendingIntent.getBundle("tokenDetails")) == null) {
            Object var1_3 = null;
        } else {
            if (classLoader != null) {
                bundle2.setClassLoader(classLoader);
            }
            TokenData tokenData = (TokenData)bundle2.getParcelable("TokenData");
        }
        if (var1_4 != null) {
            return var1_4;
        }
        String string = pendingIntent.getString("Error");
        bundle2 = (Intent)pendingIntent.getParcelable("userRecoveryIntent");
        pendingIntent = (PendingIntent)pendingIntent.getParcelable("userRecoveryPendingIntent");
        zzl.zzn(context, "getTokenWithDetails", string, (Intent)bundle2, pendingIntent);
        throw new GoogleAuthException("Invalid state. Shouldn't happen");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ShowFirstParty
    public static TokenData zza(Context object, Account account, String string, Bundle bundle, long l, @Nullable Executor object2) throws IOException, GoogleAuthException {
        zzg zzg2;
        Bundle bundle2;
        void var1_2;
        void var2_3;
        Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
        Preconditions.checkNotEmpty((String)var2_3, (Object)"Scope cannot be empty or null.");
        zzl.zzo((Account)var1_2);
        zzl.zzk(object, 8400000);
        bundle2 = bundle2 == null ? new Bundle() : new Bundle(bundle2);
        zzl.zzm(object, bundle2);
        zzdc.zzd(object);
        if (zzhw.zze() && zzl.zzp(object)) {
            zzg2 = com.google.android.gms.internal.auth.zzh.zza(object).zzc((Account)var1_2, (String)var2_3, bundle2);
            String string2 = "token retrieval";
            try {
                zzg2 = (Bundle)zzl.zzi((Task)zzg2, string2);
                zzl.zzj(zzg2);
                return zzl.zzg(object, "getTokenWithDetails", (Bundle)zzg2);
            }
            catch (ApiException apiException) {
                zzl.zzl(apiException, string2);
            }
        }
        zzg2 = new zzg((Account)var1_2, (String)var2_3, bundle2, (Context)object);
        return (TokenData)((Object)zzl.zzh(object, zzc, zzg2, 0L, null));
    }

    static /* synthetic */ TokenData zzb(Account account, String string, Bundle bundle, Context context, IBinder iBinder) throws RemoteException, IOException, GoogleAuthException {
        account = zze.zzb(iBinder).zze(account, string, bundle);
        if (account == null) {
            throw new IOException("Service call returned null");
        }
        return zzl.zzg(context, "getTokenWithDetails", (Bundle)account);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TargetApi(value=26)
    public static Boolean requestGoogleAccountsAccess(Context context) throws GoogleAuthException, IOException {
        Object object;
        Object object2;
        Preconditions.checkNotNull((Object)context);
        zzl.zzk(object2, 11400000);
        String string = object2.getApplicationInfo().packageName;
        zzdc.zzd(object2);
        if (zzhw.zze() && zzl.zzp(object2)) {
            object = com.google.android.gms.internal.auth.zzh.zza(object2).zze(string);
            String string2 = "google accounts access request";
            try {
                Bundle bundle = (Bundle)zzl.zzi((Task)object, string2);
                object = bundle.getString("Error");
                Intent intent = (Intent)bundle.getParcelable("userRecoveryIntent");
                PendingIntent pendingIntent = (PendingIntent)bundle.getParcelable("userRecoveryPendingIntent");
                zzby zzby2 = zzby.zza((String)object);
                boolean bl = zzby.zzc.equals((Object)zzby2);
                if (bl) {
                    return true;
                }
                zzl.zzn(object2, "requestGoogleAccountsAccess", (String)object, intent, pendingIntent);
                throw new GoogleAuthException("Invalid state. Shouldn't happen");
            }
            catch (ApiException apiException) {
                zzl.zzl(apiException, string2);
            }
        }
        object = new zzj(string, (Context)object2);
        return (Boolean)zzl.zzh(object2, zzc, (zzk)object, 0L, null);
    }

    static /* bridge */ /* synthetic */ Object zzc(Object object) {
        zzl.zzj(object);
        return object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object zzh(Context context, ComponentName object, zzk object2, long l, @Nullable Executor executor) throws IOException, GoogleAuthException {
        executor = new BlockingServiceConnection();
        context = GmsClientSupervisor.getInstance((Context)context);
        try {
            boolean bl = context.bindService((ComponentName)object, (ServiceConnection)executor, "GoogleAuthUtil", null);
            if (!bl) throw new IOException("Could not bind to service.");
        }
        catch (SecurityException securityException) {
            object = new Object[]{securityException.getMessage()};
            object = String.format("SecurityException while bind to auth service: %s", object);
            Log.w((String)"GoogleAuthUtil", (String)object);
            throw new IOException("SecurityException while binding to Auth service.", securityException);
        }
        try {
            object2 = object2.zza(executor.getService());
        }
        catch (Throwable throwable) {
            context.unbindService((ComponentName)object, (ServiceConnection)executor, "GoogleAuthUtil");
            throw throwable;
        }
        catch (RemoteException | InterruptedException | TimeoutException throwable) {}
        context.unbindService((ComponentName)object, (ServiceConnection)executor, "GoogleAuthUtil");
        return object2;
        {
            Log.i((String)"GoogleAuthUtil", (String)"Error on service connection.", (Throwable)throwable);
            throw new IOException("Error on service connection.", throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object zzi(Task object, String string) throws IOException, ApiException {
        Object[] objectArray;
        ExecutionException executionException2;
        String string2;
        block4: {
            try {
                return Tasks.await((Task)object);
            }
            catch (InterruptedException interruptedException) {
                Object[] objectArray2 = new Object[]{string2};
                string2 = String.format("Interrupted while waiting for the task of %s to finish.", objectArray2);
                zzd.w(string2, new Object[0]);
                throw new IOException(string2, interruptedException);
            }
            catch (CancellationException cancellationException) {
                Object[] objectArray3 = new Object[]{string2};
                string2 = String.format("Canceled while waiting for the task of %s to finish.", objectArray3);
                zzd.w(string2, new Object[0]);
                throw new IOException(string2, cancellationException);
            }
            catch (ExecutionException executionException2) {
                objectArray = executionException2.getCause();
                if (!(objectArray instanceof ApiException)) break block4;
                throw (ApiException)objectArray;
            }
        }
        objectArray = new Object[]{string2};
        string2 = String.format("Unable to get a result for %s due to ExecutionException.", objectArray);
        zzd.w(string2, new Object[0]);
        throw new IOException(string2, executionException2);
    }

    private static Object zzj(Object object) throws IOException {
        if (object == null) {
            zzd.w("Service call returned null.", new Object[0]);
            throw new IOException("Service unavailable.");
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static String getAccountId(Context ctx, String accountName) throws GoogleAuthException, IOException {
        void var1_1;
        Context context;
        Preconditions.checkNotEmpty((String)accountName, (Object)"accountName must be provided");
        Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
        zzl.zzk(context, 8400000);
        Bundle bundle = new Bundle();
        return zzl.getToken(context, (String)var1_1, "^^_account_id_^^", bundle);
    }

    /*
     * WARNING - void declaration
     */
    public static String getToken(Context context, Account account, String scope) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        void var2_2;
        void var1_1;
        return zzl.getToken(context, (Account)var1_1, (String)var2_2, new Bundle());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String getToken(Context context, String accountName, String scope) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        void var2_2;
        void var1_1;
        Context context2;
        String string = GOOGLE_ACCOUNT_TYPE;
        return zzl.getToken(context2, new Account((String)var1_1, string), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static String getToken(Context context, Account account, String scope, Bundle extras) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        void var3_3;
        void var2_2;
        void var1_1;
        Context context2;
        zzl.zzo(account);
        return zzl.zza(context2, (Account)var1_1, (String)var2_2, (Bundle)var3_3, 0L, null).zza();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String getToken(Context context, String accountName, String scope, Bundle extras) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        void var3_3;
        void var2_2;
        void var1_1;
        Context context2;
        String string = GOOGLE_ACCOUNT_TYPE;
        return zzl.getToken(context2, new Account((String)var1_1, string), (String)var2_2, (Bundle)var3_3);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<AccountChangeEvent> getAccountChangeEvents(Context context, int eventIndex, String accountName) throws GoogleAuthException, IOException {
        void var1_2;
        String string;
        Context context2;
        Preconditions.checkNotEmpty((String)accountName, (Object)"accountName must be provided");
        Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
        zzl.zzk(context2, 8400000);
        AccountChangeEventsRequest accountChangeEventsRequest = new AccountChangeEventsRequest();
        accountChangeEventsRequest.setAccountName(string);
        accountChangeEventsRequest.setEventIndex((int)var1_2);
        zzdc.zzd(context2);
        if (zzhw.zzd() && zzl.zzp(context2)) {
            Task task = com.google.android.gms.internal.auth.zzh.zza(context2).zzb(accountChangeEventsRequest);
            string = "account change events retrieval";
            try {
                AccountChangeEventsResponse accountChangeEventsResponse = (AccountChangeEventsResponse)((Object)zzl.zzi(task, string));
                zzl.zzj((Object)accountChangeEventsResponse);
                return accountChangeEventsResponse.getEvents();
            }
            catch (ApiException apiException) {
                zzl.zzl(apiException, string);
            }
        }
        zzi zzi2 = new zzi(accountChangeEventsRequest);
        return (List)zzl.zzh(context2, zzc, zzi2, 0L, null);
    }

    static /* bridge */ /* synthetic */ void zzd(Context context, String string, String string2, Intent intent, PendingIntent pendingIntent) {
        zzl.zzn(context, "requestGoogleAccountsAccess", string2, intent, pendingIntent);
    }

    static {
        String string = GOOGLE_ACCOUNT_TYPE;
        zza = new String[]{string, WORK_ACCOUNT_TYPE, "cn.google"};
        zzb = "androidPackageName";
        zzc = new ComponentName("com.google.android.gms", "com.google.android.gms.auth.GetToken");
        string = "GoogleAuthUtil";
        zzd = com.google.android.gms.auth.zzd.zza(string);
    }

    zzl() {
    }

    /*
     * WARNING - void declaration
     */
    public static void clearToken(Context context, String token) throws GoogleAuthException, IOException {
        void var1_1;
        zzl.zze(context, (String)var1_1, 0L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ShowFirstParty
    public static void zze(Context context, String string, long l) throws GoogleAuthException, IOException {
        zzh zzh2;
        Preconditions.checkNotMainThread((String)"Calling this from your main thread can lead to deadlock");
        zzl.zzk(context, 8400000);
        Bundle bundle = new Bundle();
        zzl.zzm(context, bundle);
        zzdc.zzd(context);
        if (zzhw.zze() && zzl.zzp(context)) {
            com.google.android.gms.internal.auth.zzg zzg2 = com.google.android.gms.internal.auth.zzh.zza(context);
            zzbw zzbw2 = new zzbw();
            zzbw2.zza(string);
            zzh2 = zzg2.zza(zzbw2);
            String string2 = "clear token";
            try {
                zzl.zzi((Task)zzh2, string2);
                return;
            }
            catch (ApiException apiException) {
                zzl.zzl(apiException, string2);
            }
        }
        zzh2 = new zzh(string, bundle);
        zzl.zzh(context, zzc, zzh2, 0L, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void zzk(Context context, int n) throws GoogleAuthException {
        try {
            GooglePlayServicesUtilLight.ensurePlayServicesAvailable((Context)context.getApplicationContext(), (int)n);
            return;
        }
        catch (GooglePlayServicesIncorrectManifestValueException | GooglePlayServicesNotAvailableException throwable) {
            throw new GoogleAuthException(throwable.getMessage(), throwable);
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            throw new GooglePlayServicesAvailabilityException(googlePlayServicesRepairableException.getConnectionStatusCode(), googlePlayServicesRepairableException.getMessage(), googlePlayServicesRepairableException.getIntent());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @RequiresPermission(value="android.permission.MANAGE_ACCOUNTS")
    public static void invalidateToken(Context context, String token) {
        void var1_1;
        AccountManager.get((Context)context).invalidateAuthToken(GOOGLE_ACCOUNT_TYPE, (String)var1_1);
    }

    private static void zzl(ApiException apiException, String string) {
        Object[] objectArray = new Object[]{string, Log.getStackTraceString((Throwable)apiException)};
        zzd.w("%s failed via GoogleAuthServiceClient, falling back to previous approach:\n%s", objectArray);
    }

    private static void zzm(Context object, Bundle bundle) {
        object = object.getApplicationInfo().packageName;
        bundle.putString("clientPackageName", (String)object);
        if (TextUtils.isEmpty((CharSequence)bundle.getString(zzb))) {
            bundle.putString(zzb, (String)object);
        }
        bundle.putLong("service_connection_start_time_millis", SystemClock.elapsedRealtime());
    }

    private static void zzn(Context objectArray, String string, @Nullable String string2, @Nullable Intent intent, @Nullable PendingIntent pendingIntent) throws GoogleAuthException, IOException {
        block7: {
            block6: {
                zzby zzby2;
                block5: {
                    zzby2 = zzby.zza(string2);
                    Object[] objectArray2 = new Object[]{zzby2, string};
                    zzd.w(String.format("[GoogleAuthUtil] error status:%s with method:%s", objectArray2), new Object[0]);
                    if (!zzby.zzi.equals((Object)zzby2) && !zzby.zzs.equals((Object)zzby2) && !zzby.zzw.equals((Object)zzby2) && !zzby.zzx.equals((Object)zzby2) && !zzby.zzn.equals((Object)zzby2) && !zzby.zzz.equals((Object)zzby2) && !zzby.zzN.equals((Object)zzby2) && !zzby.zzF.equals((Object)zzby2) && !zzby.zzG.equals((Object)zzby2) && !zzby.zzH.equals((Object)zzby2) && !zzby.zzI.equals((Object)zzby2) && !zzby.zzJ.equals((Object)zzby2) && !zzby.zzK.equals((Object)zzby2) && !zzby.zzM.equals((Object)zzby2) && !zzby.zzE.equals((Object)zzby2) && !zzby.zzL.equals((Object)zzby2)) break block5;
                    zzdc.zzd((Context)objectArray);
                    if (!zzht.zzc()) break block6;
                    if (pendingIntent == null || intent == null) {
                        if (GoogleApiAvailability.getInstance().getApkVersion((Context)objectArray) >= Integer.MAX_VALUE && pendingIntent == null) {
                            objectArray = new Object[]{Integer.MAX_VALUE, string, objectArray[0]};
                            zzd.e(String.format("Recovery PendingIntent is missing on current Gms version: %s for method: %s. It should always be present on or above Gms version %s. This indicates a bug in Gms implementation.", objectArray), new Object[0]);
                        }
                        if (intent == null) {
                            objectArray = new Object[]{string2, string};
                            zzd.e(String.format("no recovery Intent found with status=%s for method=%s. This shouldn't happen", objectArray), new Object[0]);
                        }
                        throw new UserRecoverableAuthException(string2, intent);
                    }
                    break block7;
                }
                if (!(zzby.zze.equals((Object)zzby2) || zzby.zzf.equals((Object)zzby2) || zzby.zzg.equals((Object)zzby2) || zzby.zzaf.equals((Object)zzby2))) {
                    if (!zzby.zzah.equals((Object)zzby2)) {
                        throw new GoogleAuthException(string2);
                    }
                }
                throw new IOException(string2);
            }
            throw new UserRecoverableAuthException(string2, intent);
        }
        throw UserRecoverableAuthException.zza(string2, intent, pendingIntent);
    }

    private static void zzo(Account account) {
        if (account == null) {
            throw new IllegalArgumentException("Account cannot be null");
        }
        if (TextUtils.isEmpty((CharSequence)account.name)) {
            throw new IllegalArgumentException("Account name cannot be empty!");
        }
        String[] stringArray = zza;
        int n = 0;
        while (true) {
            if (n < 3) {
                if (stringArray[n].equals(account.type)) {
                    return;
                }
            } else {
                throw new IllegalArgumentException("Account type not supported");
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void zzf(Intent object) {
        if (object == null) {
            throw new IllegalArgumentException("Callback cannot be null.");
        }
        object = object.toUri(1);
        try {
            Intent.parseUri((String)object, (int)1);
            return;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Parameter callback contains invalid data. It must be serializable using toUri() and parseUri().");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean zzp(Context object) {
        void var0_3;
        if (GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(object, 17895000) != 0) {
            return false;
        }
        String string = object.getApplicationInfo().packageName;
        Iterator iterator = zzhw.zzb().zzq().iterator();
        while (iterator.hasNext()) {
            if (!((String)iterator.next()).equals(string)) continue;
            return (boolean)var0_3;
        }
        return (boolean)var0_3;
    }
}

