/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.zzf;
import com.google.android.gms.common.internal.ReflectedParcelable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

public final class PasswordSpecification
extends com.google.android.gms.common.internal.safeparcel.zza
implements ReflectedParcelable {
    public static final Parcelable.Creator<PasswordSpecification> CREATOR = new zzf();
    public static final PasswordSpecification zzaiy = new zza().zzl(12, 16).zzcr("abcdefghijkmnopqrstxyzABCDEFGHJKLMNPQRSTXY3456789").zzf("abcdefghijkmnopqrstxyz", 1).zzf("ABCDEFGHJKLMNPQRSTXY", 1).zzf("3456789", 1).zzqz();
    public static final PasswordSpecification zzaiz = new zza().zzl(12, 16).zzcr("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890").zzf("abcdefghijklmnopqrstuvwxyz", 1).zzf("ABCDEFGHIJKLMNOPQRSTUVWXYZ", 1).zzf("1234567890", 1).zzqz();
    final int mVersionCode;
    final String zzaiA;
    final List<String> zzaiB;
    final List<Integer> zzaiC;
    final int zzaiD;
    final int zzaiE;
    private final int[] zzaiF;
    private final Random zzzI;

    PasswordSpecification(int n, String string, List<String> list, List<Integer> list2, int n2, int n3) {
        this.mVersionCode = n;
        this.zzaiA = string;
        this.zzaiB = Collections.unmodifiableList(list);
        this.zzaiC = Collections.unmodifiableList(list2);
        this.zzaiD = n2;
        this.zzaiE = n3;
        this.zzaiF = this.zzqy();
        this.zzzI = new SecureRandom();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzf.zza(this, parcel, n);
    }

    private int[] zzqy() {
        int[] nArray = new int[95];
        Arrays.fill(nArray, -1);
        int n = 0;
        for (String string : this.zzaiB) {
            for (char c : string.toCharArray()) {
                nArray[this.zza((char)c)] = n;
            }
            ++n;
        }
        return nArray;
    }

    private int zza(char c) {
        return c - 32;
    }

    private static String zzb(Collection<Character> collection) {
        char[] cArray = new char[collection.size()];
        int n = 0;
        for (char c : collection) {
            cArray[n++] = c;
        }
        return new String(cArray);
    }

    private static boolean zzc(int n, int n2, int n3) {
        return n < n2 || n > n3;
    }

    public static class zzb
    extends Error {
        public zzb(String string) {
            super(string);
        }
    }

    public static class zza {
        private final TreeSet<Character> zzaiG = new TreeSet();
        private final List<String> zzaiB = new ArrayList<String>();
        private final List<Integer> zzaiC = new ArrayList<Integer>();
        private int zzaiD = 12;
        private int zzaiE = 16;

        public zza zzcr(@NonNull String string) {
            this.zzaiG.addAll(this.zzv(string, "allowedChars"));
            return this;
        }

        public zza zzf(@NonNull String string, int n) {
            if (n < 1) {
                throw new zzb("count must be at least 1");
            }
            TreeSet<Character> treeSet = this.zzv(string, "requiredChars");
            this.zzaiB.add(PasswordSpecification.zzb(treeSet));
            this.zzaiC.add(n);
            return this;
        }

        public zza zzl(int n, int n2) {
            if (n < 1) {
                throw new zzb("minimumSize must be at least 1");
            }
            if (n > n2) {
                throw new zzb("maximumSize must be greater than or equal to minimumSize");
            }
            this.zzaiD = n;
            this.zzaiE = n2;
            return this;
        }

        public PasswordSpecification zzqz() {
            if (this.zzaiG.isEmpty()) {
                throw new zzb("no allowed characters specified");
            }
            this.zzqA();
            this.zzqB();
            return new PasswordSpecification(1, PasswordSpecification.zzb(this.zzaiG), this.zzaiB, this.zzaiC, this.zzaiD, this.zzaiE);
        }

        private TreeSet<Character> zzv(String string, String string2) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                throw new zzb(String.valueOf(string2).concat(" cannot be null or empty"));
            }
            TreeSet<Character> treeSet = new TreeSet<Character>();
            for (char c : string.toCharArray()) {
                if (PasswordSpecification.zzc(c, 32, 126)) {
                    throw new zzb(String.valueOf(string2).concat(" must only contain ASCII printable characters"));
                }
                treeSet.add(Character.valueOf(c));
            }
            return treeSet;
        }

        private void zzqA() {
            int n = 0;
            for (int n2 : this.zzaiC) {
                n += n2;
            }
            if (n > this.zzaiE) {
                throw new zzb("required character count cannot be greater than the max password size");
            }
        }

        private void zzqB() {
            boolean[] blArray = new boolean[95];
            for (String string : this.zzaiB) {
                for (char c : string.toCharArray()) {
                    if (blArray[c - 32]) {
                        throw new zzb(new StringBuilder(58).append("character ").append(c).append(" occurs in more than one required character set").toString());
                    }
                    blArray[c - 32] = true;
                }
            }
        }
    }
}

