/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.accounts.Account;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.os.RemoteException;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.GoogleSignInResult;
import com.google.android.gms.auth.api.signin.internal.SignInConfiguration;
import com.google.android.gms.auth.api.signin.internal.SignInHubActivity;
import com.google.android.gms.auth.api.signin.internal.zzd;
import com.google.android.gms.auth.api.signin.internal.zzi;
import com.google.android.gms.auth.api.signin.internal.zzl;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.PendingResults;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzabc;
import com.google.android.gms.internal.zzace;
import com.google.android.gms.internal.zzzv;
import java.util.HashSet;

public final class zze {
    private static zzace zzajs = new zzace("GoogleSignInCommon", new String[0]);

    public static Intent zza(Context context, GoogleSignInOptions googleSignInOptions) {
        zzajs.zzb("GoogleSignInCommon", new Object[]{"getSignInIntent()"});
        SignInConfiguration signInConfiguration = new SignInConfiguration(context.getPackageName(), googleSignInOptions);
        Intent intent = new Intent("com.google.android.gms.auth.GOOGLE_SIGN_IN");
        intent.setClass(context, SignInHubActivity.class);
        intent.putExtra("config", (Parcelable)signInConfiguration);
        return intent;
    }

    public static OptionalPendingResult<GoogleSignInResult> zza(GoogleApiClient googleApiClient, Context context, GoogleSignInOptions googleSignInOptions) {
        zzl zzl2 = zzl.zzaa((Context)context);
        GoogleSignInResult googleSignInResult = zze.zza(zzl2, googleSignInOptions);
        if (null != googleSignInResult) {
            zzajs.zzb("GoogleSignInCommon", new Object[]{"Eligible saved sign in result found"});
            return PendingResults.zzb((Result)googleSignInResult, (GoogleApiClient)googleApiClient);
        }
        return zze.zza(googleApiClient, zzl2, googleSignInOptions);
    }

    static GoogleSignInResult zza(zzl zzl2, GoogleSignInOptions googleSignInOptions) {
        HashSet hashSet;
        HashSet hashSet2;
        zzajs.zzb("GoogleSignInCommon", new Object[]{"getEligibleSavedSignInResult()"});
        zzac.zzw((Object)googleSignInOptions);
        GoogleSignInOptions googleSignInOptions2 = zzl2.zzrd();
        if (googleSignInOptions2 == null) {
            return null;
        }
        if (!zze.zza(googleSignInOptions2.getAccount(), googleSignInOptions.getAccount())) {
            return null;
        }
        if (googleSignInOptions.zzqL()) {
            return null;
        }
        if (googleSignInOptions.zzqK()) {
            if (!googleSignInOptions2.zzqK()) {
                return null;
            }
            if (!googleSignInOptions.zzqN().equals(googleSignInOptions2.zzqN())) {
                return null;
            }
        }
        if (!(hashSet2 = new HashSet(googleSignInOptions2.zzqJ())).containsAll(hashSet = new HashSet(googleSignInOptions.zzqJ()))) {
            return null;
        }
        GoogleSignInAccount googleSignInAccount = zzl2.zzrc();
        if (googleSignInAccount != null && !googleSignInAccount.zza()) {
            return new GoogleSignInResult(googleSignInAccount, Status.zzayh);
        }
        return null;
    }

    private static boolean zza(Account account, Account account2) {
        if (account == null) {
            return account2 == null;
        }
        return account.equals((Object)account2);
    }

    private static OptionalPendingResult<GoogleSignInResult> zza(GoogleApiClient googleApiClient, final zzl zzl2, final GoogleSignInOptions googleSignInOptions) {
        zzajs.zzb("GoogleSignInCommon", new Object[]{"trySilentSignIn()"});
        zzzv.zza zza2 = googleApiClient.zza((zzzv.zza)new zza<GoogleSignInResult>(googleApiClient){

            protected void zza(zzd zzd2) throws RemoteException {
                ((zzi)zzd2.zzwW()).zza(new com.google.android.gms.auth.api.signin.internal.zza(){

                    @Override
                    public void zza(GoogleSignInAccount googleSignInAccount, Status status) throws RemoteException {
                        if (googleSignInAccount != null) {
                            zzl2.zzb(googleSignInAccount, googleSignInOptions);
                        }
                        this.zzb(new GoogleSignInResult(googleSignInAccount, status));
                    }
                }, googleSignInOptions);
            }

            protected GoogleSignInResult zzn(Status status) {
                return new GoogleSignInResult(null, status);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzn(status);
            }
        });
        return new zzabc((PendingResult)zza2);
    }

    public static PendingResult<Status> zza(GoogleApiClient googleApiClient, Context context) {
        zzl zzl2 = zzl.zzaa((Context)context);
        zzl2.zzre();
        for (GoogleApiClient googleApiClient2 : GoogleApiClient.zzuM()) {
            googleApiClient2.zzuN();
        }
        return googleApiClient.zzb((zzzv.zza)new zza<Status>(googleApiClient){

            protected void zza(zzd zzd2) throws RemoteException {
                ((zzi)zzd2.zzwW()).zzb(new com.google.android.gms.auth.api.signin.internal.zza(){

                    @Override
                    public void zzl(Status status) throws RemoteException {
                        this.zzb((Result)status);
                    }
                }, zzd2.zzqU());
            }

            protected Status zzb(Status status) {
                return status;
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    public static PendingResult<Status> zzb(GoogleApiClient googleApiClient, Context context) {
        zzl zzl2 = zzl.zzaa((Context)context);
        zzl2.zzre();
        zzajs.zzb("GoogleSignInCommon", new Object[]{"Revoking access"});
        for (GoogleApiClient googleApiClient2 : GoogleApiClient.zzuM()) {
            googleApiClient2.zzuN();
        }
        return googleApiClient.zzb((zzzv.zza)new zza<Status>(googleApiClient){

            protected void zza(zzd zzd2) throws RemoteException {
                ((zzi)zzd2.zzwW()).zzc(new com.google.android.gms.auth.api.signin.internal.zza(){

                    @Override
                    public void zzm(Status status) throws RemoteException {
                        this.zzb((Result)status);
                    }
                }, zzd2.zzqU());
            }

            protected Status zzb(Status status) {
                return status;
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    public static GoogleSignInResult getSignInResultFromIntent(Intent intent) {
        if (intent == null || !intent.hasExtra("googleSignInStatus") && !intent.hasExtra("googleSignInAccount")) {
            return null;
        }
        GoogleSignInAccount googleSignInAccount = (GoogleSignInAccount)intent.getParcelableExtra("googleSignInAccount");
        Status status = (Status)intent.getParcelableExtra("googleSignInStatus");
        if (googleSignInAccount != null) {
            status = Status.zzayh;
        }
        return new GoogleSignInResult(googleSignInAccount, status);
    }

    private static abstract class zza<R extends Result>
    extends zzzv.zza<R, zzd> {
        public zza(GoogleApiClient googleApiClient) {
            super(Auth.GOOGLE_SIGN_IN_API, googleApiClient);
        }
    }
}

