/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.IdToken;
import com.google.android.gms.auth.api.credentials.zza;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zzd;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.internal.zzasq;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Credential
extends com.google.android.gms.common.internal.safeparcel.zza
implements ReflectedParcelable {
    public static final String EXTRA_KEY = "com.google.android.gms.credentials.Credential";
    public static final Parcelable.Creator<Credential> CREATOR = new zza();
    private int zzakw;
    private final String zzIl;
    @Nullable
    private final String mName;
    @Nullable
    private final Uri zzakT;
    private final List<IdToken> zzakU;
    @Nullable
    private final String zzakV;
    @Nullable
    private final String zzakW;
    @Nullable
    private final String zzakX;
    @Nullable
    private final String zzakY;
    @Nullable
    private final String zzakZ;
    @Nullable
    private final String zzala;

    Credential(int n, String string, String string2, Uri uri, List<IdToken> list, String string3, String string4, String string5, String string6, String string7, String string8) {
        this.zzakw = n;
        String string9 = ((String)zzbr.zzb((Object)string, (Object)"credential identifier cannot be null")).trim();
        zzbr.zzh((String)string9, (Object)"credential identifier cannot be empty");
        this.zzIl = string9;
        if (string2 != null && TextUtils.isEmpty((CharSequence)string2.trim())) {
            string2 = null;
        }
        this.mName = string2;
        this.zzakT = uri;
        this.zzakU = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
        this.zzakV = string3;
        if (string3 != null && string3.isEmpty()) {
            throw new IllegalArgumentException("password cannot be empty");
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            zzasq.zzbN(string4);
        }
        this.zzakW = string4;
        this.zzakX = string5;
        this.zzakY = string6;
        this.zzakZ = string7;
        this.zzala = string8;
        if (!TextUtils.isEmpty((CharSequence)this.zzakV) && !TextUtils.isEmpty((CharSequence)this.zzakW)) {
            throw new IllegalStateException("password and accountType cannot both be set");
        }
    }

    public String getId() {
        return this.zzIl;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    @Nullable
    public Uri getProfilePictureUri() {
        return this.zzakT;
    }

    public List<IdToken> getIdTokens() {
        return this.zzakU;
    }

    @Nullable
    public String getPassword() {
        return this.zzakV;
    }

    @Nullable
    public String getGeneratedPassword() {
        return this.zzakX;
    }

    @Nullable
    public String getAccountType() {
        return this.zzakW;
    }

    @Nullable
    public String getGivenName() {
        return this.zzakZ;
    }

    @Nullable
    public String getFamilyName() {
        return this.zzala;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Credential credential = this;
        int n2 = zzd.zze((Parcel)parcel2);
        zzd.zza((Parcel)parcel2, (int)1, (String)credential.getId(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)2, (String)credential.getName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)3, (Parcelable)credential.getProfilePictureUri(), (int)n, (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)4, credential.getIdTokens(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)5, (String)credential.getPassword(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)6, (String)credential.getAccountType(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)7, (String)credential.getGeneratedPassword(), (boolean)false);
        zzd.zzc((Parcel)parcel2, (int)1000, (int)credential.zzakw);
        zzd.zza((Parcel)parcel2, (int)8, (String)credential.zzakY, (boolean)false);
        zzd.zza((Parcel)parcel2, (int)9, (String)credential.getGivenName(), (boolean)false);
        zzd.zza((Parcel)parcel2, (int)10, (String)credential.getFamilyName(), (boolean)false);
        zzd.zzI((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Credential)) {
            return false;
        }
        Credential credential = (Credential)((Object)object);
        return TextUtils.equals((CharSequence)this.zzIl, (CharSequence)credential.zzIl) && TextUtils.equals((CharSequence)this.mName, (CharSequence)credential.mName) && zzbh.equal((Object)this.zzakT, (Object)credential.zzakT) && TextUtils.equals((CharSequence)this.zzakV, (CharSequence)credential.zzakV) && TextUtils.equals((CharSequence)this.zzakW, (CharSequence)credential.zzakW) && TextUtils.equals((CharSequence)this.zzakX, (CharSequence)credential.zzakX);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzIl, this.mName, this.zzakT, this.zzakV, this.zzakW, this.zzakX});
    }

    public static class Builder {
        private final String zzIl;
        private String mName;
        private Uri zzakT;
        private List<IdToken> zzakU;
        private String zzakV;
        private String zzakW;
        private String zzakX;
        private String zzakY;
        private String zzakZ;
        private String zzala;

        public Builder(String string) {
            this.zzIl = string;
        }

        public Builder(Credential credential) {
            this.zzIl = credential.zzIl;
            this.mName = credential.mName;
            this.zzakT = credential.zzakT;
            this.zzakU = credential.zzakU;
            this.zzakV = credential.zzakV;
            this.zzakW = credential.zzakW;
            this.zzakX = credential.zzakX;
            this.zzakY = credential.zzakY;
            this.zzakZ = credential.zzakZ;
            this.zzala = credential.zzala;
        }

        public Builder setName(String string) {
            this.mName = string;
            return this;
        }

        public Builder setProfilePictureUri(Uri uri) {
            this.zzakT = uri;
            return this;
        }

        public Builder setPassword(String string) {
            this.zzakV = string;
            return this;
        }

        public Builder setAccountType(String string) {
            this.zzakW = string;
            return this;
        }

        public Credential build() {
            return new Credential(4, this.zzIl, this.mName, this.zzakT, this.zzakU, this.zzakV, this.zzakW, this.zzakX, this.zzakY, this.zzakZ, this.zzala);
        }
    }
}

