/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import android.view.accessibility.AccessibilityEvent;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.SignInAccount;
import com.google.android.gms.auth.api.signin.internal.SignInConfiguration;
import com.google.android.gms.auth.api.signin.internal.zzc;
import com.google.android.gms.auth.api.signin.internal.zzp;
import com.google.android.gms.auth.api.signin.internal.zzz;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;

@KeepName
public class SignInHubActivity
extends FragmentActivity {
    private static boolean zza = false;
    private boolean zzb = false;
    @VisibleForTesting
    private SignInConfiguration zzc;
    private boolean zzd;
    private int zze;
    private Intent zzf;

    public SignInHubActivity() {
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Intent intent = this.getIntent();
        String string = intent.getAction();
        if ("com.google.android.gms.auth.NO_IMPL".equals(string)) {
            this.zza(12500);
            return;
        }
        if (zza) {
            this.setResult(0);
            this.zza(12502);
            return;
        }
        zza = true;
        if (!string.equals("com.google.android.gms.auth.GOOGLE_SIGN_IN") && !string.equals("com.google.android.gms.auth.APPAUTH_SIGN_IN")) {
            String string2 = String.valueOf(intent.getAction());
            Log.e((String)"AuthSignInClient", (String)(string2.length() != 0 ? "Unknown action: ".concat(string2) : new String("Unknown action: ")));
            this.finish();
            return;
        }
        Bundle bundle2 = intent.getBundleExtra("config");
        this.zzc = (SignInConfiguration)bundle2.getParcelable("config");
        if (this.zzc == null) {
            Log.e((String)"AuthSignInClient", (String)"Activity started with invalid configuration.");
            this.setResult(0);
            this.finish();
            return;
        }
        if (bundle == null) {
            String string3 = string;
            SignInHubActivity signInHubActivity = this;
            Intent intent2 = new Intent(string3);
            if (string3.equals("com.google.android.gms.auth.GOOGLE_SIGN_IN")) {
                intent2.setPackage("com.google.android.gms");
            } else {
                intent2.setPackage(signInHubActivity.getPackageName());
            }
            intent2.putExtra("config", (Parcelable)signInHubActivity.zzc);
            try {
                signInHubActivity.startActivityForResult(intent2, 40962);
                return;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                signInHubActivity.zzb = true;
                Log.w((String)"AuthSignInClient", (String)"Could not launch sign in Intent. Google Play Service is probably being updated...");
                signInHubActivity.zza(17);
                return;
            }
        }
        this.zzd = bundle.getBoolean("signingInGoogleApiClients");
        if (this.zzd) {
            this.zze = bundle.getInt("signInResultCode");
            this.zzf = (Intent)bundle.getParcelable("signInResultData");
            this.zza();
        }
    }

    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("signingInGoogleApiClients", this.zzd);
        if (this.zzd) {
            bundle.putInt("signInResultCode", this.zze);
            bundle.putParcelable("signInResultData", (Parcelable)this.zzf);
        }
    }

    protected void onActivityResult(int n, int n2, Intent intent) {
        if (this.zzb) {
            return;
        }
        this.setResult(0);
        switch (n) {
            case 40962: {
                Intent intent2 = intent;
                SignInHubActivity signInHubActivity = this;
                if (intent2 != null) {
                    SignInAccount signInAccount = (SignInAccount)intent2.getParcelableExtra("signInAccount");
                    if (signInAccount != null && signInAccount.zza() != null) {
                        GoogleSignInAccount googleSignInAccount = signInAccount.zza();
                        zzp.zza((Context)signInHubActivity).zza(signInHubActivity.zzc.zza(), googleSignInAccount);
                        intent2.removeExtra("signInAccount");
                        intent2.putExtra("googleSignInAccount", (Parcelable)googleSignInAccount);
                        signInHubActivity.zzd = true;
                        signInHubActivity.zze = n2;
                        signInHubActivity.zzf = intent2;
                        signInHubActivity.zza();
                        return;
                    }
                    if (intent2.hasExtra("errorCode")) {
                        int n3 = intent2.getIntExtra("errorCode", 8);
                        signInHubActivity.zza(n3);
                        return;
                    }
                }
                signInHubActivity.zza(8);
            }
        }
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return true;
    }

    private final void zza() {
        this.getSupportLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)new zza(this, null));
        zza = false;
    }

    private final void zza(int n) {
        Status status = new Status(n);
        Intent intent = new Intent();
        intent.putExtra("googleSignInStatus", (Parcelable)status);
        this.setResult(0, intent);
        this.finish();
        zza = false;
    }

    final class zza
    implements LoaderManager.LoaderCallbacks<Void> {
        private /* synthetic */ SignInHubActivity zza;

        private zza(SignInHubActivity signInHubActivity) {
            this.zza = signInHubActivity;
        }

        public final Loader<Void> onCreateLoader(int n, Bundle bundle) {
            return new zzc((Context)this.zza, GoogleApiClient.zza());
        }

        public final void onLoaderReset(Loader<Void> loader) {
        }

        public final /* synthetic */ void onLoadFinished(Loader loader, Object object) {
            zza zza2 = this;
            zza2.zza.setResult(zza2.zza.zze, zza2.zza.zzf);
            zza2.zza.finish();
        }

        /* synthetic */ zza(SignInHubActivity signInHubActivity, zzz zzz2) {
            this(signInHubActivity);
        }
    }
}

