/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.GoogleSignInResult;
import com.google.android.gms.auth.api.signin.internal.zzh;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.ApiExceptionMapper;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.internal.PendingResultUtil;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.tasks.Task;

public class GoogleSignInClient
extends GoogleApi<GoogleSignInOptions> {
    private static final zzc zzar = new zzc(null);
    @VisibleForTesting
    private static int zzas = zzd.zzau;

    GoogleSignInClient(@NonNull Context context, GoogleSignInOptions googleSignInOptions) {
        super(context, Auth.GOOGLE_SIGN_IN_API, (Api.ApiOptions)googleSignInOptions, (StatusExceptionMapper)new ApiExceptionMapper());
    }

    GoogleSignInClient(@NonNull Activity activity, GoogleSignInOptions googleSignInOptions) {
        super(activity, Auth.GOOGLE_SIGN_IN_API, (Api.ApiOptions)googleSignInOptions, (StatusExceptionMapper)new ApiExceptionMapper());
    }

    private final synchronized int zze() {
        if (zzas == zzd.zzau) {
            Context context = this.getApplicationContext();
            GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
            int n = googleApiAvailability.isGooglePlayServicesAvailable(context, 12451000);
            zzas = n == 0 ? zzd.zzax : (googleApiAvailability.getErrorResolutionIntent(context, n, null) == null && DynamiteModule.getLocalVersion((Context)context, (String)"com.google.android.gms.auth.api.fallback") != 0 ? zzd.zzaw : zzd.zzav);
        }
        return zzas;
    }

    @NonNull
    public Intent getSignInIntent() {
        Context context = this.getApplicationContext();
        switch (com.google.android.gms.auth.api.signin.zzc.zzat[this.zze() - 1]) {
            case 1: {
                return zzh.zzd(context, (GoogleSignInOptions)this.getApiOptions());
            }
            case 2: {
                return zzh.zzc(context, (GoogleSignInOptions)this.getApiOptions());
            }
        }
        return zzh.zze(context, (GoogleSignInOptions)this.getApiOptions());
    }

    public Task<GoogleSignInAccount> silentSignIn() {
        return PendingResultUtil.toTask(zzh.zzc(this.asGoogleApiClient(), this.getApplicationContext(), (GoogleSignInOptions)this.getApiOptions(), this.zze() == zzd.zzaw), (PendingResultUtil.ResultConverter)zzar);
    }

    public Task<Void> signOut() {
        return PendingResultUtil.toVoidTask(zzh.zzc(this.asGoogleApiClient(), this.getApplicationContext(), this.zze() == zzd.zzaw));
    }

    public Task<Void> revokeAccess() {
        return PendingResultUtil.toVoidTask(zzh.zzd(this.asGoogleApiClient(), this.getApplicationContext(), this.zze() == zzd.zzaw));
    }

    private static final class zzc
    implements PendingResultUtil.ResultConverter<GoogleSignInResult, GoogleSignInAccount> {
        private zzc() {
        }

        public final /* synthetic */ Object convert(Result result) {
            return ((GoogleSignInResult)result).getSignInAccount();
        }

        /* synthetic */ zzc(com.google.android.gms.auth.api.signin.zzc zzc2) {
            this();
        }
    }

    @VisibleForTesting
    static final class zzd {
        public static final /* enum */ int zzau = 1;
        public static final /* enum */ int zzav = 2;
        public static final /* enum */ int zzaw = 3;
        public static final /* enum */ int zzax = 4;
        private static final /* synthetic */ int[] zzay;

        public static int[] values$50KLMJ33DTMIUPRFDTJMOP9FC5N68SJFD5I2UPRDECNM2TBKD0NM2S395TPMIPRED5N2UHRFDTJMOPAJD5JMSIBE8DM6IPBEEGI4IRBGDHIMQPBEEHGN8QBFDOTG____0() {
            return (int[])zzay.clone();
        }

        static {
            zzay = new int[]{zzau, zzav, zzaw, zzax};
        }
    }
}

