/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.auth.api.credentials.zzd;
import com.google.android.gms.auth.api.credentials.zze;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SafeParcelable.Class(creator="CredentialPickerConfigCreator")
public final class CredentialPickerConfig
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<CredentialPickerConfig> CREATOR = new zze();
    @SafeParcelable.Field(id=1000)
    private final int zzu;
    @SafeParcelable.Field(id=1, getter="shouldShowAddAccountButton")
    private final boolean zzv;
    @SafeParcelable.Field(id=2, getter="shouldShowCancelButton")
    private final boolean mShowCancelButton;
    @Deprecated
    @SafeParcelable.Field(id=3, getter="isForNewAccount")
    private final boolean zzw;
    @SafeParcelable.Field(id=4, getter="getPromptInternalId")
    private final int zzx;

    @SafeParcelable.Constructor
    CredentialPickerConfig(@SafeParcelable.Param(id=1000) int n, @SafeParcelable.Param(id=1) boolean bl, @SafeParcelable.Param(id=2) boolean bl2, @SafeParcelable.Param(id=3) boolean bl3, @SafeParcelable.Param(id=4) int n2) {
        this.zzu = n;
        this.zzv = bl;
        this.mShowCancelButton = bl2;
        if (n < 2) {
            this.zzw = bl3;
            this.zzx = bl3 ? 3 : 1;
            return;
        }
        this.zzw = n2 == 3;
        this.zzx = n2;
    }

    private CredentialPickerConfig(Builder builder) {
        this(2, builder.zzv, builder.mShowCancelButton, false, builder.zzy);
    }

    public final boolean shouldShowAddAccountButton() {
        return this.zzv;
    }

    public final boolean shouldShowCancelButton() {
        return this.mShowCancelButton;
    }

    @Deprecated
    public final boolean isForNewAccount() {
        return this.zzx == 3;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        CredentialPickerConfig credentialPickerConfig = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)1, (boolean)credentialPickerConfig.shouldShowAddAccountButton());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)2, (boolean)credentialPickerConfig.shouldShowCancelButton());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)3, (boolean)credentialPickerConfig.isForNewAccount());
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)4, (int)credentialPickerConfig.zzx);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1000, (int)credentialPickerConfig.zzu);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ CredentialPickerConfig(Builder builder, zzd zzd2) {
        this(builder);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Prompt {
        public static final int CONTINUE = 1;
        public static final int SIGN_IN = 2;
        public static final int SIGN_UP = 3;
    }

    public static class Builder {
        private boolean zzv = false;
        private boolean mShowCancelButton = true;
        private int zzy = 1;

        public Builder setShowAddAccountButton(boolean bl) {
            this.zzv = bl;
            return this;
        }

        public Builder setShowCancelButton(boolean bl) {
            this.mShowCancelButton = bl;
            return this;
        }

        public Builder setPrompt(int n) {
            this.zzy = n;
            return this;
        }

        @Deprecated
        public Builder setForNewAccount(boolean bl) {
            this.zzy = bl ? 3 : 1;
            return this;
        }

        public CredentialPickerConfig build() {
            return new CredentialPickerConfig(this, null);
        }
    }
}

