/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.identity;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.identity.zzc;
import com.google.android.gms.auth.api.identity.zzd;
import com.google.android.gms.auth.api.identity.zzf;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

@SafeParcelable.Class(creator="BeginSignInRequestCreator")
public final class BeginSignInRequest
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<BeginSignInRequest> CREATOR = new zzc();
    @SafeParcelable.Field(id=1, getter="getPasswordRequestOptions")
    private final PasswordRequestOptions zzas;
    @SafeParcelable.Field(id=2, getter="getGoogleIdTokenRequestOptions")
    private final GoogleIdTokenRequestOptions zzat;
    @SafeParcelable.Field(id=3, getter="getSessionId")
    @Nullable
    private final String zzau;

    public static Builder builder() {
        return new Builder();
    }

    @SafeParcelable.Constructor
    BeginSignInRequest(@SafeParcelable.Param(id=1) PasswordRequestOptions passwordRequestOptions, @SafeParcelable.Param(id=2) GoogleIdTokenRequestOptions googleIdTokenRequestOptions, @SafeParcelable.Param(id=3) @Nullable String string) {
        this.zzas = (PasswordRequestOptions)((Object)Preconditions.checkNotNull((Object)((Object)passwordRequestOptions)));
        this.zzat = (GoogleIdTokenRequestOptions)((Object)Preconditions.checkNotNull((Object)((Object)googleIdTokenRequestOptions)));
        this.zzau = string;
    }

    public final PasswordRequestOptions getPasswordRequestOptions() {
        return this.zzas;
    }

    public final GoogleIdTokenRequestOptions getGoogleIdTokenRequestOptions() {
        return this.zzat;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzas, this.zzat, this.zzau});
    }

    public final boolean equals(@Nullable Object object) {
        if (!(object instanceof BeginSignInRequest)) {
            return false;
        }
        BeginSignInRequest beginSignInRequest = (BeginSignInRequest)((Object)object);
        return Objects.equal((Object)((Object)this.zzas), (Object)((Object)beginSignInRequest.zzas)) && Objects.equal((Object)((Object)this.zzat), (Object)((Object)beginSignInRequest.zzat)) && Objects.equal((Object)this.zzau, (Object)beginSignInRequest.zzau);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        BeginSignInRequest beginSignInRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)1, (Parcelable)beginSignInRequest.getPasswordRequestOptions(), (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)beginSignInRequest.getGoogleIdTokenRequestOptions(), (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)beginSignInRequest.zzau, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public static Builder zzc(BeginSignInRequest beginSignInRequest) {
        Preconditions.checkNotNull((Object)((Object)beginSignInRequest));
        Builder builder = BeginSignInRequest.builder().setGoogleIdTokenRequestOptions(beginSignInRequest.getGoogleIdTokenRequestOptions()).setPasswordRequestOptions(beginSignInRequest.getPasswordRequestOptions());
        String string = beginSignInRequest.zzau;
        if (string != null) {
            builder.zzd(string);
        }
        return builder;
    }

    @SafeParcelable.Class(creator="GoogleIdTokenRequestOptionsCreator")
    public static final class GoogleIdTokenRequestOptions
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<GoogleIdTokenRequestOptions> CREATOR = new zzd();
        @SafeParcelable.Field(id=1, getter="isSupported")
        private final boolean zzav;
        @SafeParcelable.Field(id=2, getter="getServerClientId")
        @Nullable
        private final String zzaw;
        @SafeParcelable.Field(id=3, getter="getNonce")
        @Nullable
        private final String zzax;
        @SafeParcelable.Field(id=4, getter="filterByAuthorizedAccounts")
        private final boolean zzay;

        public static Builder builder() {
            return new Builder();
        }

        @SafeParcelable.Constructor
        GoogleIdTokenRequestOptions(@SafeParcelable.Param(id=1) boolean bl, @SafeParcelable.Param(id=2) @Nullable String string, @SafeParcelable.Param(id=3) @Nullable String string2, @SafeParcelable.Param(id=4) boolean bl2) {
            this.zzav = bl;
            if (bl) {
                Preconditions.checkNotNull((Object)string, (Object)"serverClientId must be provided if Google ID tokens are requested");
            }
            this.zzaw = string;
            this.zzax = string2;
            this.zzay = bl2;
        }

        public final boolean isSupported() {
            return this.zzav;
        }

        @Nullable
        public final String getServerClientId() {
            return this.zzaw;
        }

        @Nullable
        public final String getNonce() {
            return this.zzax;
        }

        public final boolean filterByAuthorizedAccounts() {
            return this.zzay;
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.zzav, this.zzaw, this.zzax, this.zzay});
        }

        public final boolean equals(@Nullable Object object) {
            if (!(object instanceof GoogleIdTokenRequestOptions)) {
                return false;
            }
            GoogleIdTokenRequestOptions googleIdTokenRequestOptions = (GoogleIdTokenRequestOptions)((Object)object);
            return this.zzav == googleIdTokenRequestOptions.zzav && Objects.equal((Object)this.zzaw, (Object)googleIdTokenRequestOptions.zzaw) && Objects.equal((Object)this.zzax, (Object)googleIdTokenRequestOptions.zzax) && this.zzay == googleIdTokenRequestOptions.zzay;
        }

        public final void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            GoogleIdTokenRequestOptions googleIdTokenRequestOptions = this;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)1, (boolean)googleIdTokenRequestOptions.isSupported());
            SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)googleIdTokenRequestOptions.getServerClientId(), (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)googleIdTokenRequestOptions.getNonce(), (boolean)false);
            SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)4, (boolean)googleIdTokenRequestOptions.filterByAuthorizedAccounts());
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }

        public static final class Builder {
            private boolean zzav = false;
            @Nullable
            private String zzaw = null;
            @Nullable
            private String zzax = null;
            private boolean zzay = true;

            public final Builder setSupported(boolean bl) {
                this.zzav = bl;
                return this;
            }

            public final Builder setServerClientId(@NonNull String string) {
                this.zzaw = Preconditions.checkNotEmpty((String)string);
                return this;
            }

            public final Builder setNonce(@Nullable String string) {
                this.zzax = string;
                return this;
            }

            public final Builder setFilterByAuthorizedAccounts(boolean bl) {
                this.zzay = bl;
                return this;
            }

            public final GoogleIdTokenRequestOptions build() {
                return new GoogleIdTokenRequestOptions(this.zzav, this.zzaw, this.zzax, this.zzay);
            }
        }
    }

    @SafeParcelable.Class(creator="PasswordRequestOptionsCreator")
    public static final class PasswordRequestOptions
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<PasswordRequestOptions> CREATOR = new zzf();
        @SafeParcelable.Field(id=1, getter="isSupported")
        private final boolean zzav;

        public static Builder builder() {
            return new Builder();
        }

        @SafeParcelable.Constructor
        PasswordRequestOptions(@SafeParcelable.Param(id=1) boolean bl) {
            this.zzav = bl;
        }

        public final boolean isSupported() {
            return this.zzav;
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.zzav});
        }

        public final boolean equals(@Nullable Object object) {
            if (!(object instanceof PasswordRequestOptions)) {
                return false;
            }
            PasswordRequestOptions passwordRequestOptions = (PasswordRequestOptions)((Object)object);
            return this.zzav == passwordRequestOptions.zzav;
        }

        public final void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            PasswordRequestOptions passwordRequestOptions = this;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)1, (boolean)passwordRequestOptions.isSupported());
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }

        public static final class Builder {
            private boolean zzav = false;

            public final Builder setSupported(boolean bl) {
                this.zzav = bl;
                return this;
            }

            public final PasswordRequestOptions build() {
                return new PasswordRequestOptions(this.zzav);
            }
        }
    }

    public static final class Builder {
        private PasswordRequestOptions zzas = PasswordRequestOptions.builder().setSupported(false).build();
        private GoogleIdTokenRequestOptions zzat = GoogleIdTokenRequestOptions.builder().setSupported(false).build();
        @Nullable
        private String zzau;

        public final Builder setPasswordRequestOptions(@NonNull PasswordRequestOptions passwordRequestOptions) {
            this.zzas = (PasswordRequestOptions)((Object)Preconditions.checkNotNull((Object)((Object)passwordRequestOptions)));
            return this;
        }

        public final Builder setGoogleIdTokenRequestOptions(@NonNull GoogleIdTokenRequestOptions googleIdTokenRequestOptions) {
            this.zzat = (GoogleIdTokenRequestOptions)((Object)Preconditions.checkNotNull((Object)((Object)googleIdTokenRequestOptions)));
            return this;
        }

        public final Builder zzd(@NonNull String string) {
            this.zzau = string;
            return this;
        }

        public final BeginSignInRequest build() {
            return new BeginSignInRequest(this.zzas, this.zzat, this.zzau);
        }
    }
}

