/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.GoogleSignInResult;
import com.google.android.gms.auth.api.signin.internal.zzg;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.internal.ApiExceptionMapper;
import com.google.android.gms.common.api.internal.StatusExceptionMapper;
import com.google.android.gms.common.internal.PendingResultUtil;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.tasks.Task;

public class GoogleSignInClient
extends GoogleApi<GoogleSignInOptions> {
    private static final zzc zzbp = new zzc(null);
    @VisibleForTesting
    private static int zzbq = zzd.zzbt;

    GoogleSignInClient(@NonNull Context context, GoogleSignInOptions googleSignInOptions) {
        super(context, Auth.GOOGLE_SIGN_IN_API, (Api.ApiOptions)googleSignInOptions, (StatusExceptionMapper)new ApiExceptionMapper());
    }

    GoogleSignInClient(@NonNull Activity activity, GoogleSignInOptions googleSignInOptions) {
        super(activity, Auth.GOOGLE_SIGN_IN_API, (Api.ApiOptions)googleSignInOptions, (StatusExceptionMapper)new ApiExceptionMapper());
    }

    private final synchronized int zzh() {
        if (zzbq == zzd.zzbt) {
            Context context = this.getApplicationContext();
            GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
            int n = googleApiAvailability.isGooglePlayServicesAvailable(context, 12451000);
            zzbq = n == 0 ? zzd.zzbw : (googleApiAvailability.getErrorResolutionIntent(context, n, null) == null && DynamiteModule.getLocalVersion((Context)context, (String)"com.google.android.gms.auth.api.fallback") != 0 ? zzd.zzbv : zzd.zzbu);
        }
        return zzbq;
    }

    @NonNull
    public Intent getSignInIntent() {
        Context context = this.getApplicationContext();
        switch (com.google.android.gms.auth.api.signin.zzc.zzbr[this.zzh() - 1]) {
            case 1: {
                return zzg.zzd(context, (GoogleSignInOptions)this.getApiOptions());
            }
            case 2: {
                return zzg.zzc(context, (GoogleSignInOptions)this.getApiOptions());
            }
        }
        return zzg.zze(context, (GoogleSignInOptions)this.getApiOptions());
    }

    public Task<GoogleSignInAccount> silentSignIn() {
        return PendingResultUtil.toTask(zzg.zzc(this.asGoogleApiClient(), this.getApplicationContext(), (GoogleSignInOptions)this.getApiOptions(), this.zzh() == zzd.zzbv), (PendingResultUtil.ResultConverter)zzbp);
    }

    public Task<Void> signOut() {
        return PendingResultUtil.toVoidTask(zzg.zzc(this.asGoogleApiClient(), this.getApplicationContext(), this.zzh() == zzd.zzbv));
    }

    public Task<Void> revokeAccess() {
        return PendingResultUtil.toVoidTask(zzg.zzd(this.asGoogleApiClient(), this.getApplicationContext(), this.zzh() == zzd.zzbv));
    }

    private static final class zzc
    implements PendingResultUtil.ResultConverter<GoogleSignInResult, GoogleSignInAccount> {
        private zzc() {
        }

        @Nullable
        public final /* synthetic */ Object convert(Result result) {
            return ((GoogleSignInResult)result).getSignInAccount();
        }

        /* synthetic */ zzc(com.google.android.gms.auth.api.signin.zzc zzc2) {
            this();
        }
    }

    @VisibleForTesting
    static final class zzd {
        public static final /* enum */ int zzbt = 1;
        public static final /* enum */ int zzbu = 2;
        public static final /* enum */ int zzbv = 3;
        public static final /* enum */ int zzbw = 4;
        private static final /* synthetic */ int[] zzbx;

        public static int[] zzi() {
            return (int[])zzbx.clone();
        }

        static {
            zzbx = new int[]{zzbt, zzbu, zzbv, zzbw};
        }
    }
}

