/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.accounts.Account;
import android.content.Context;
import android.content.Intent;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInApi;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.GoogleSignInResult;
import com.google.android.gms.auth.api.signin.internal.zzd;
import com.google.android.gms.auth.api.signin.internal.zzg;
import com.google.android.gms.auth.api.signin.internal.zzh;
import com.google.android.gms.auth.api.signin.internal.zzq;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.PendingResults;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.api.internal.zzr;
import com.google.android.gms.common.internal.zzx;
import java.util.HashSet;

public class zzc
implements GoogleSignInApi {
    @Override
    public Intent getSignInIntent(GoogleApiClient client) {
        zzx.zzz((Object)client);
        return ((zzd)client.zza(Auth.zzVx)).zznc();
    }

    @Override
    public OptionalPendingResult<GoogleSignInResult> silentSignIn(GoogleApiClient client) {
        GoogleSignInOptions googleSignInOptions = this.zzb(client);
        GoogleSignInResult googleSignInResult = this.zza(client.getContext(), googleSignInOptions);
        if (googleSignInResult != null) {
            return PendingResults.zzb((Result)googleSignInResult, (GoogleApiClient)client);
        }
        return this.zza(client, googleSignInOptions);
    }

    public GoogleSignInResult zza(Context context, GoogleSignInOptions googleSignInOptions) {
        HashSet hashSet;
        HashSet hashSet2;
        Log.d((String)"GoogleSignInApiImpl", (String)"getSavedSignInResultIfEligible");
        zzx.zzz((Object)googleSignInOptions);
        zzq zzq2 = zzq.zzaf((Context)context);
        GoogleSignInOptions googleSignInOptions2 = zzq2.zznp();
        if (googleSignInOptions2 == null) {
            return null;
        }
        if (!this.zza(googleSignInOptions2.getAccount(), googleSignInOptions.getAccount())) {
            return null;
        }
        if (googleSignInOptions.zzmP()) {
            return null;
        }
        if (googleSignInOptions.zzmO()) {
            if (!googleSignInOptions2.zzmO()) {
                return null;
            }
            if (!googleSignInOptions.zzmR().equals(googleSignInOptions2.zzmR())) {
                return null;
            }
        }
        if (!(hashSet2 = new HashSet(googleSignInOptions2.zzmN())).containsAll(hashSet = new HashSet(googleSignInOptions.zzmN()))) {
            return null;
        }
        GoogleSignInAccount googleSignInAccount = zzq2.zzno();
        if (googleSignInAccount != null && !googleSignInAccount.zzb()) {
            return new GoogleSignInResult(googleSignInAccount, Status.zzagC);
        }
        return null;
    }

    private boolean zza(Account account, Account account2) {
        if (account == null) {
            return account2 == null;
        }
        return account.equals((Object)account2);
    }

    private OptionalPendingResult<GoogleSignInResult> zza(GoogleApiClient googleApiClient, final GoogleSignInOptions googleSignInOptions) {
        Log.d((String)"GoogleSignInApiImpl", (String)"trySilentSignIn");
        zza.zza zza2 = googleApiClient.zza((zza.zza)new zza<GoogleSignInResult>(googleApiClient){

            protected void zza(zzd zzd2) throws RemoteException {
                final zzq zzq2 = zzq.zzaf((Context)zzd2.getContext());
                ((zzh)zzd2.zzqJ()).zza((zzg)new com.google.android.gms.auth.api.signin.internal.zza(){

                    @Override
                    public void zza(GoogleSignInAccount googleSignInAccount, Status status) throws RemoteException {
                        if (googleSignInAccount != null) {
                            zzq2.zzb(googleSignInAccount, googleSignInOptions);
                        }
                        this.zza((Result)new GoogleSignInResult(googleSignInAccount, status));
                    }
                }, googleSignInOptions);
            }

            protected GoogleSignInResult zzn(Status status) {
                return new GoogleSignInResult(null, status);
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzn(status);
            }
        });
        return new zzr((PendingResult)zza2);
    }

    @Override
    public PendingResult<Status> signOut(GoogleApiClient client) {
        zzq zzq2 = zzq.zzaf((Context)client.getContext());
        zzq2.zznr();
        for (GoogleApiClient googleApiClient : GoogleApiClient.zzoV()) {
            googleApiClient.zzoW();
        }
        return client.zzb((zza.zza)new zza<Status>(client){

            protected void zza(zzd zzd2) throws RemoteException {
                ((zzh)zzd2.zzqJ()).zzb((zzg)new com.google.android.gms.auth.api.signin.internal.zza(){

                    @Override
                    public void zzl(Status status) throws RemoteException {
                        this.zza((Result)status);
                    }
                }, zzd2.zznd());
            }

            protected Status zzb(Status status) {
                return status;
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    @Override
    public PendingResult<Status> revokeAccess(GoogleApiClient client) {
        zzq zzq2 = zzq.zzaf((Context)client.getContext());
        zzq2.zznr();
        for (GoogleApiClient googleApiClient : GoogleApiClient.zzoV()) {
            googleApiClient.zzoW();
        }
        return client.zzb((zza.zza)new zza<Status>(client){

            protected void zza(zzd zzd2) throws RemoteException {
                ((zzh)zzd2.zzqJ()).zzc(new com.google.android.gms.auth.api.signin.internal.zza(){

                    @Override
                    public void zzm(Status status) throws RemoteException {
                        this.zza((Result)status);
                    }
                }, zzd2.zznd());
            }

            protected Status zzb(Status status) {
                return status;
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    @Override
    public GoogleSignInResult getSignInResultFromIntent(Intent data) {
        if (data == null || !data.hasExtra("googleSignInStatus") && !data.hasExtra("googleSignInAccount")) {
            return null;
        }
        GoogleSignInAccount googleSignInAccount = (GoogleSignInAccount)data.getParcelableExtra("googleSignInAccount");
        Status status = (Status)data.getParcelableExtra("googleSignInStatus");
        if (googleSignInAccount != null) {
            status = Status.zzagC;
        }
        return new GoogleSignInResult(googleSignInAccount, status);
    }

    private GoogleSignInOptions zzb(GoogleApiClient googleApiClient) {
        return ((zzd)googleApiClient.zza(Auth.zzVx)).zznd();
    }

    private abstract class zza<R extends Result>
    extends zza.zza<R, zzd> {
        public zza(GoogleApiClient googleApiClient) {
            super(Auth.zzVx, googleApiClient);
        }
    }
}

